var table;

$(function () {

    var form = $('form');

    /** Altera os formulários **/
    form.attr ('enctype','multipart/form-data');

    /** Corrige o ID de campos do tipo array **/
    $('input,select,textarea').each(function()
    {
        if ($(this).attr('name') !== undefined && $(this).attr('name').substr(-1) === ']')
        {
            $(this).attr('id',md5($(this).attr('name')+'-'+Math.floor((Math.random() * 100) + 1).toString()));
        }
    }).attr ({
        'autoComplete'  : 'off'
    });

    /** Selects **/
    $('select.select2:not(.select2-offscreen)').select2();

    /** Select multi seleção **/
    $('input.select2').each (function () {
        var select = $(this);

        /** Se não estiver inicializado **/
        if (!select.hasClass('select2-offscreen'))
        {

            select.select2({
                placeholder : '-- Selecione --',
                allowClear: true,
                multiple : select.attr('data-multiple') === '1',
                minimumInputLength: 1,
                ajax: {
                    url         : select.attr('data-url'),
                    dataType    : 'jsonp',
                    data: function (term, page)
                    {
                        return {
                            q: term
                        };
                    },
                    results : function (data, page)
                    {
                        var retorno = [];

                        jQuery.each(data, function(index, obj)
                        {

                            retorno.push({
                                id: obj.id,
                                text: obj.text,
                                disabled: obj.disabled === 'true'
                            });
                        });

                        return {
                            results: retorno
                        };
                    }
                }
            });

            if(select.attr('data-value') !== undefined && select.attr('data-value') !== '[]')
            {
                if (select.attr('data-multiple') === '1')
                {
                    select.select2("data", $.parseJSON(select.attr('data-value')));
                }
                else
                {
                    stringArray = $.parseJSON(select.attr('data-value'));

                    stringArray.forEach(function(objeto)
                    {
                        if(objeto !== undefined)
                        {
                            select.select2("data", {id: objeto.id, text: objeto.text});
                        }
                    });
                }
            }
        }
    });

    /** Validação de formulários **/
    form.validate({
        errorClass : 'obrigatorio',

        ignore:':hidden',

        invalidHandler: function()
        {

            swal("Atenção", "Preencha todos os campos obrigatórios.");

        },

        highlight: function (element, errorClass, validClass) {
            var elem = $(element);

            if (elem.hasClass("select2"))
            {
                elem.parents('.form-group').find('.select2-container').addClass(errorClass);
            }
            else
            {
                elem.addClass(errorClass);
            }
        },

        unhighlight: function (element, errorClass, validClass) {
            var elem = $(element);

            if (elem.hasClass("select2"))
            {
                elem.parents('.form-group').find('.select2-container').removeClass(errorClass);
            }
            else
            {
                elem.removeClass(errorClass);
            }
        }

    });

    /** Máscaras **/
    $('input.data').mask('00/00/0000', {
        clearIfNotMatch: true,
        selectOnFocus: true,
        placeholder : '00/00/0000'
    }).datepicker({
        orientation: "top auto",
        autoclose: true,
        format : 'dd/mm/yyyy',
        language : 'pt-BR',
        todayHighlight: true
    }).on('changeDate', function ()
    {

        if ($(this).val().length === 10)
        {

            $(this).focus();

        }

    });

    $('input.time').mask('00:00', {
        clearIfNotMatch: true,
        selectOnFocus: true,
        placeholder : '00:00'
    });

    $('input.CEP').mask('00000-000', {
        clearIfNotMatch: true,
        selectOnFocus: true,
        placeholder : '00000-000'
    });

    $('.telefone').mask('(00) 0000-00009', {
        clearIfNotMatch: true,
        placeholder: '(00) 0000-0000'
    })
        .blur(function()
        {

            if($(this).val().length === 15)
            {

                $('.telefone').mask('(00) 00000-00009', {
                    placeholder: '(00) 00000-0000'
                })

            }
            else
            {

                $('.telefone').mask('(00) 0000-00009', {
                    clearIfNotMatch: true,
                    placeholder: '(00) 0000-0000'
                })

            }

        });

    $('.telefone:first').each( function () {

        $(this).trigger('blur');

    });

    $('input.CPF').mask('000.000.000-00', {
        reverse: true,
        clearIfNotMatch: true,
        selectOnFocus: true,
        placeholder : '000.000.000-00'
    });

    $('input.CNPJ').mask('00.000.000/0000-00', {
        reverse: true,
        clearIfNotMatch: true,
        selectOnFocus: true,
        placeholder : '00.000.000/0000-00'
    });

    $('input.hora').mask('00:00', {
        selectOnFocus: true,
        clearIfNotMatch: true,
        placeholder : '00:00'
    });

    $('input.RG').mask('0.000.000', {
        reverse: true,
        clearIfNotMatch: true,
        selectOnFocus: true,
        placeholder : '0.000.000'
    });

    $('input.ano').mask('0000', {
        selectOnFocus: true,
        clearIfNotMatch: true,
        placeholder : '0000'
    });

    $('input.placa').mask('ZZZ-BBBB', {
        translation: {
            'Z': {
                pattern: /[aA*]/
            },
            'B': {
                pattern: /[9*]/
            }
        },
        selectOnFocus: true,
        clearIfNotMatch: true,
        placeholder : 'AAA-9999'
    });

    $('input.inteiro').mask('000000000', {
        reverse: true,
        selectOnFocus: true,
        placeholder : '000000000'
    });

    $('input.real').mask("#.##0,00", {
        reverse: true,
        selectOnFocus: true,
        placeholder : '0,00'
    });

    $('input.porcentagem').mask('##0,00%', {
        reverse: true,
        selectOnFocus: true,
        placeholder : '0,00'
    });

    /** Mensagens de alerta **/
    setTimeout (function () {

        $('.mensagem').fadeOut();

    },3500);

    /** Remove a sombra **/
    setInterval(function ()
    {

        $('#content-sombra').fadeOut('medium');

    },350);

    /** Adiciona a overlay ao sair da página **/
    window.onbeforeunload = function()
    {

        $('#content-sombra').show();

    };

    toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": false,
        "progressBar": true,
        "positionClass": "toast-top-center",
        "preventDuplicates": true,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    };

    var overlay = $('.overlay');

    setTimeout(function ()
    {

        overlay.fadeOut('fast');

    },250);

    /** Adiciona a overlay ao sair da página **/
    window.onbeforeunload = function()
    {

        overlay.show();

    };

    /** Ao clicar no menu **/
    $('.menu.accordion-menu .waves-button').on ('click', function ()
    {

        var title = '';

        if ($(this).parents('li').hasClass('droplink'))
        {

            title = $(this).find('p').html();

        }

        ajax ('ajax/sidebar-menu','title='+title);

    });

    $('input.upper').on('keyup',function ()
    {

        this.value = this.value.toUpperCase();

    });

    summerEditor();

});

function summerEditor ()
{


    /** Textarea **/
    $('textarea.comEditor:visible').each (function ()
    {

        $(this).summernote({
            lang: 'pt-BR',
            height: 250,
            dialogsInBody: true,
            onCreateLink : function(originalLink) {
                return originalLink; // return original link
            },
        });


    });

}

function exclui (prURL,prMensagem)
{

    if (typeof(prMensagem) === 'undefined') { prMensagem  = 'Você confirma a exclusão deste registro?'; }

    swal({
            title: "Atenção",
            text: prMensagem,
            type: "warning",
            showCancelButton: true,
            confirmButtonText: "Salvar",
            closeOnConfirm: false
        },
        function()
        {

            document.location.href = prURL;

        });

}

function sidebar ()
{

    setTimeout(function ()
    {

        $.ajax({
            url     : 'ajax/sidebar',
            type    : 'POST',
            data    : 'aberto='+($('body').hasClass('small-sidebar') ? '0' : '1')
        });

    },150);

}

/** Ajax **/
function ajax (prURL,prData,prOnSuccess, prType)
{

    if (typeof(prType) === 'undefined')
    {
        prType = 'POST';
    }

    $.ajax({
        url		: prURL,
        data	: prData,
        type	: prType,
        success : function (prRetorno)
        {

            if (typeof(prOnSuccess) !== 'undefined' && typeof(prOnSuccess) === 'function')
            {

                prOnSuccess(prRetorno);

            }

        }
    });

}

function menuAbre (prLabel)
{

    $('.menu.accordion-menu .waves-button p').each (function ()
    {

        if ($(this).html() === prLabel)
        {

            $(this).parents('li').addClass('open');

        }

    });

}

function redirect (prURL)
{

    document.location.href = prURL;

}

/**
 * Converte uma string (Campo decimal) para Float JS
 * @param prString
 * @returns {Number}
 */
function stringParaFloat (prString)
{

    return prString === '' ? '0' : parseFloat(prString.replace('.','').replace(',','.'));

}

function stringParaData (prString)
{
    var tmp = $.trim(prString);
    var data;

    tmp = tmp.replace('/','-');
    tmp = tmp.replace('/','-');
    tmp = tmp.replace('/','-');

    data = new Date(parseInt(tmp.substr(-4)),parseInt(tmp.substr(3,2)) - 1,parseInt(tmp.substr(0,2)));

    return data;
}

/**
 * Exibe um float
 * @param prNumero
 * @returns {string|*}
 */
function float (prNumero)
{
    x = 0;

    if(prNumero < 0) {
        prNumero = Math.abs(prNumero);

        x = 1;
    }

    if(isNaN(prNumero)) prNumero = "0";
    cents = Math.floor((prNumero*100+0.5)%100);

    prNumero = Math.floor((prNumero*100+0.5)/100).toString();

    if(cents < 10) cents = "0" + cents;
    for (var i = 0; i < Math.floor((prNumero.length-(1+i))/3); i++)
        prNumero = prNumero.substring(0,prNumero.length-(4*i+3))+'.'
            +prNumero.substring(prNumero.length-(4*i+3));

    ret = prNumero + ',' + cents;
    if (x === 1) ret = ' - ' + ret;return ret;

}

function emailValida (prEmail)
{

    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;

    return re.test(prEmail);

}