@extends('frontend/base/section')

@section('content')

    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.5/angular.min.js"></script>
    <script src="https://angular-file-upload.appspot.com/js/ng-file-upload-shim.js"></script>
    <script src="https://angular-file-upload.appspot.com/js/ng-file-upload.js"></script>

    <style>
        .drop-box {
            padding: 10px;
            border: 3px solid #aaaaaa;
            border-style: dashed;
            text-align: center;
        }

        .veiculos_list {
            width: 100px;
            float: left;
            padding-left: 10px;
        }


    </style>

    <div class="centralizado" ng-app="myApp" ng-controller="myCtrl">

        <h2 class="pagina_titulo visuallyhidden">{{ $pagina }}</h2>

        <div class="b-xs-12 b-md-6">


            <div class="conteudo">

                Você está querendo vender o seu veículo? Podemos lhe ajudar!
                Preenche as informações ao lado que nossa equipe de vendedores fará contato com você.

            </div>

        </div>

        <div class="b-xs-12 b-md-6">

            <form name="myForm">
                <div class="campo">

                    <label class="visuallyhidden">Nome</label>
                    <input ng-model="objForm.nome" type="text" name="nome" required placeholder="*Nome">

                </div>

                <div class="campo">

                    <label class="visuallyhidden">Telefone</label>
                    <input ng-model="objForm.telefone" type="text" name="telefone" required placeholder="*Telefone">

                </div>

                <div class="campo">

                    <label class="visuallyhidden">E-mail</label>
                    <input ng-model="objForm.email" type="text" name="email" required placeholder="*Email">

                </div>

                <div class="campo">

                    <label class="visuallyhidden">Marca</label>
                    <input ng-model="objForm.marca" type="text" name="marca" required placeholder="*Marca">

                </div>

                <div class="campo">

                    <label class="visuallyhidden">Modelo</label>
                    <input ng-model="objForm.modelo" type="text" name="modelo" required placeholder="*Modelo">
                </div>

                <div class="campo">

                    <label class="visuallyhidden">Ano de Fabricação</label>
                    <input ng-model="objForm.ano_fabricacao" type="text" name="ano_fabricacao" class="ano_sem_place"
                           required
                           placeholder="*Ano de Fabricação">

                </div>

                <div class="campo">

                    <label class="visuallyhidden">Ano Modelo</label>
                    <input ng-model="objForm.ano_modelo" type="text" name="ano_modelo" class="ano_sem_place" required
                           placeholder="*Ano Modelo">

                </div>

                <div class="campo">

                    <label class="visuallyhidden">Cor</label>
                    <input ng-model="objForm.cor" type="text" name="cor" required placeholder="*Cor">

                </div>

                <div class="campo">

                    <label class="visuallyhidden">Observações</label>

                    <textarea ng-model="objForm.observacao" name="observacao"
                              placeholder="Observações sobre o veículo"></textarea>

                </div>

                <div class="b-xs-12">

                    <div class="campo">


                        <div
                                ng-show="files.length>=5?false:true;"
                                ngf-drop
                                ngf-select
                                name="files"
                                ng-model="files"
                                ngf-resize="{width: 1024, height: 768, centerCrop: true}"
                                class="drop-box fs-upload-target"
                                ngf-drag-over-class="'dragover'"
                                accept="image/*"
                                ngf-max-files="5"
                                ngf-multiple="true"
                                id="upload"
                        >
                            Selecione e envie-nos algumas fotos do seu veículo.
                        </div>


                        <div ng-repeat="files in files" class="lista">
                            <div class="veiculos_list">
                                <img ng-show="myForm.files.$valid" ngf-thumbnail="files" class="thumb">
                                <span class="remove_veiculo" ng-click="files = null" ng-show="files">
                                    <i class="fa fa-close"></i> remover
                                </span>
                            </div>
                        </div>


                        <small ng-show="files.length>=5?true:false;" style="color:red;font-size: 12px;">Limite de 5
                            fotos
                        </small>
                    </div>
                </div>



                <div class="b-xs-12">

                    @if($recaptcha)
                        <div class="g-recaptcha" data-sitekey="{{$recaptcha}}"></div>
                    @endif


                    <div class="campo campo--spaced-top">
                        <input type="button" ng-click="uploadPic(files)" value="Enviar">

                        <div ng-show="carregando_fotos">
                            Enviando ...
                        </div>


                        <div class="text-danger">
                            @{{mensagem}}
                        </div>

                    </div>
                </div>
            </form>

        </div>

    </div>

@endsection

@section('javascript')


    <script>
        var app = angular.module('myApp', ['ngFileUpload']);
        app.controller('myCtrl', function ($scope, Upload, $timeout) {

            $scope.arrFotoUpload = [];
            $scope.files = [];
            $scope.objForm = {
                nome:null,
                telefone:null,
                email:null,
                marca: null,
                modelo: null,
                ano_fabricacao: null,
                ano_modelo: null,
                cor: null,
                observacao: null,
                fotos: [],
                recaptcha:null

            }



            $scope.mensagem = null;


            $scope.limparFormulario = function(){
                $scope.arrFotoUpload = [];
                $scope.files = [];
                $scope.objForm = {
                    nome:null,
                    telefone:null,
                    email:null,
                    marca: null,
                    modelo: null,
                    ano_fabricacao: null,
                    ano_modelo: null,
                    cor: null,
                    observacao: null,
                    fotos: [],
                    recaptcha:null

                }
            }

            $scope.uploadPic = function (files) {

                $scope.objForm.fotos = files;
                $scope.uploadFiles(files);

            }


            $scope.uploadFiles = function (files) {



                $scope.carregando_fotos = true;

                @if($recaptcha)
                var response = grecaptcha.getResponse();

                if(response.length == 0){
                    $scope.objForm.recaptcha = false;
                }else{
                    $scope.objForm.recaptcha = true;
                }

                @endif

                @if(!$recaptcha)
                    $scope.objForm.recaptcha = true;
                @endif



                $scope.files = files;
                if (files && files.length) {


                    Upload.upload({
                        url: '/upload-foto',
                        data: {
                            file: files,
                            outros: $scope.objForm
                        }
                    }).then(function (response) {
                        $timeout(function () {
                            $scope.result = response.data;


                            if($scope.result.status){
                                $scope.limparFormulario();
                            }

                            $scope.mensagem = $scope.result.mensagem;




                        });
                    }, function (response) {
                        if (response.status > 0) {
                            $scope.errorMsg = response.status + ': ' + response.data;
                        }
                    }, function (evt) {
                        $scope.progress = Math.min(100, parseInt(100.0 * evt.loaded / evt.total));
                    }).finally(function () {
                        $scope.carregando_fotos = false;
                    });
                }else{
                    alert('Selecione as fotos do veículo');
                    $scope.carregando_fotos = false;
                }


            };

        });
    </script>



@endsection


