@extends('frontend/base/section')

@section('content')

    <div class="centralizado">

        <h2 class="pagina_titulo visuallyhidden">{{ $pagina }}</h2>

        <div class="b-xs-12 b-md-8">

            <div class="lista-noticias">

                @foreach($noticia as $item)

                    <a href="noticias/{{ $item->alias }}" target="_blank" class="noticia" rel="lightbox">

                        <div class="noticia_imagem_container">

                            <time class="noticia_data">

                                <span class="noticia_data_dia">{{ \Lib\Date::date($item->data, 'd') }}</span>

                                <span class="noticia_data_mes">{{ \Lib\Date::mesExtenso(\Lib\Date::date($item->data, 'm')) }}</span>

                            </time>

                            <div style="width: 100%;">

                                <img src="{{$url}}/arquivo/{{ $cliente->id }}/noticia/{{ $item->id }}/{{ $item->imagem }}" alt="{{ $item->chamada }}" class="noticia_imagem">

                            </div>

                        </div>

                        <div class="noticia_texto_container">

                            <h3 class="noticia_titulo">{{ $item->chamada }}</h3>

                            <div class="noticia_resumo">{{ substr(strip_tags($item->integra),0, 150) }}...</div>

                        </div>

                    </a>

                @endforeach

                {{ \Lib\Paginacao::paginacao(6) }}

            </div>

        </div>

        <div class="b-xs-12 b-md-4">

            <aside class="arquivos">

                <h2 class="arquivos_titulo">Arquivo Mensal</h2>

                <ul class="arquivos_lista">

                    @foreach($aFiltro as $mes => $label)

                        <li class="arquivos_item {{ $mes == $ativo ? 'is-active' : '' }}">

                            <a href="noticias/filtro?mes={{ $mes }}"  class="arquivos_link">

                                {{ $label }}

                            </a>

                        </li>

                    @endforeach

                </ul>

            </aside>

        </div>

    </div>

@endsection

