@extends('frontend/base/section')

@section('content')

    <section class="banners">

        <h2 class="visuallyhidden">Anúncios</h2>

        <div class="banner-slider_container">

            <div class="banner-slider">

                @foreach($aBanner as $imagem)

                    <div class="banner-slider_slide">

                        @if($imagem->link)

                            <a href="{{ $imagem->link }}" id="{{$imagem->arquivo}}" target="_blank">

                        @endif

                        <img src="{{$url}}/arquivo/{{ $cliente->id }}/banner/{{ $imagem->arquivo }}" alt="{{ $imagem->descricao }}" class="banner-slider_slide_imagem banner-slider_slide_imagem-desktop">
                        <img src="{{$url}}/arquivo/{{ $cliente->id }}/banner/{{ $imagem->arquivo }}" alt="{{ $imagem->descricao }}" class="banner-slider_slide_imagem banner-slider_slide_imagem-mobile">

                        @if($imagem->link)

                            </a>

                        @endif

                    </div>

                @endforeach

            </div>

        </div>

    </section>

    @if($geral->tema!= 'tema_1'&&strtolower($pagina)=='home')
        @include('frontend/base/topo_linha_3')
    @endif

    <section class="destaques">

        <div class="centralizado">

            <div class="b-xs-12">

                @if($geral->exibe_estoque_home == 'Sim')
                    <h2 class="destaques_titulo">NOSSO ESTOQUE</h2>
                @else
                    <h2 class="destaques_titulo">{{ ($cliente->tema == 'tema_3' ? 'Destaque' : 'Veículos em Destaque')  }}</h2>
                @endif

            </div>

            <div class="lista-veiculos">


                @foreach($veiculo as $index => $item)

                    <div class="b-xs-12 b-sm-6 b-md-4 {{ ((($index+1) % 2) == 1 ? 'b-sm-c' : '') }} {{ ((($index+1) % 3) == 1 ? 'b-md-c b-lg-c b-xl-c' : '') }}">


                        <div class="veiculo veiculo-destaque">

                            @if($item->oferta == 1)
                            <div class="ribbon_3"><span>OFERTA</span></div>
                            @endif

                            @if($item->destaque == 1)
                                <div class="ribbon_3"><span>DESTAQUE</span></div>
                            @endif

                            @if($item->repasse == 1)
                                <div class="ribbon_3"><span>REPASSE</span></div>
                            @endif

                            <a href="veiculo/{{ $item->alias }}" class="veiculo_imagem_container">

                                @if($item->imagem)

                                    <img src="{{$url}}/arquivo/{{ $cliente->id }}/veiculo/{{ $item->id }}/{{ $item->imagem }}" alt="" class="veiculo_imagem IMAGEM1">

                                @else

                                    <img src="{{$url}}/assets/frontend/{{$geral->tema}}/imagens/padrao.jpg" alt="" class="veiculo_imagem">

                                @endif

                                @if($item->destaque == 1)

                                        <span class="veiculo_selo-destaque">Destaque</span>

                                @endif

                            </a>

                            <div class="veiculo_info">
                                <div class="veiculo_modelo">{{ substr($item->nome,0,-9) }}</div>

                                @if($item->valor == 0)

                                    <div class="veiculo_preco">Consultar Preço</div>
                                @else

                                    <div class="veiculo_preco">R$ {{ \Base\Decimal::exibe($item->valor) }}</div>

                                @endif

                                <div class="veiculo_dados">

                                    Ano {{ $geral->exibe_ano == 'Ano modelo' ? $item->modelo : $item->fabricacao.'/'.$item->modelo }} / {{ ($item->placa != NULL ? ($item->quilometragem < 100 ? 'Consultar Km' : \Base\Decimal::exibe($item->quilometragem, 0).' Km') : \Base\Decimal::exibe($item->quilometragem, 0).' Km') }} / {{ $item->combustivel }}

                                </div>

                            </div>

                        </div>

                    </div>

                @endforeach

            </div>

           

        </div>

        <div class="align-center">

            <a href="estoque" class="bt">Ver todo o estoque</a>

        </div>

    </section>

    @if($youtube->exibe == 'Sim')

        <section class="videos">

            <div class="centralizado">

                <div class="b-xs-12">

                    <h2 class="videos_titulo">Vídeos</h2>

                </div>

                <div class="lista-videos">

                    @foreach(range(1,3) as $x)

                        @if($youtube->{'video_'.$x})

                            <div class="b-xs-12 b-md-4">

                                <div class="video">

                                    <iframe width="346" height="195" src="{{ $youtube->{'video_'.$x} }}" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen class="video__embed"></iframe>

                                </div>

                            </div>

                        @endif

                    @endforeach

                </div>

                <div class="clearfix"></div>

                <div class="align-center">

                    <a href="{{ $youtube->canal }}" target="_blank" class="bt">Nosso Canal</a>

                </div>

            </div>

        </section>

    @endif

    @if($temNoticia == '1')

        <section class="noticias">

            <div class="centralizado">

                <div class="b-xs-12">

                    <h2 class="noticias_titulo">Notícias</h2>

                </div>

                <div class="lista-noticias">

                    @foreach($noticia as $index => $item)

                        @if($geral->tema == 'tema_3')

                            <div class="b-xs-12 b-md-3 {{ ( (($index+1) % 4 == 1) ? 'b-md-c b-lg-c b-xl-c' : '') }}">

                        @else

                            <div class="b-xs-12 b-md-6 {{ ((($index+1) % 2 == 1) ? 'b-md-c b-lg-c b-xl-c' : '') }}">

                                @endif

                                <a href="noticias/{{ $item->alias }}" class="noticia noticia-home" rel="lightbox">

                                    <div class="noticia_imagem_container">

                                        <time class="noticia_data">

                                            <span class="noticia_data_dia">{{ \Lib\Date::date($item->data, 'd') }}</span>

                                            <span class="noticia_data_mes">{{ \Lib\Date::mesExtenso(\Lib\Date::date($item->data, 'm')) }}</span>

                                        </time>

                                        <img src="arquivo/{{ $cliente->id }}/noticia/{{ $item->id }}/{{ $item->imagem }}" class="noticia_imagem noticia_imagem-index">

                                    </div>

                                    <div class="noticia_texto_container">

                                        <h3 class="noticia_titulo">{{ $item->chamada }}</h3>

                                        <div class="noticia_resumo">{{ substr(strip_tags($item->integra), 0, 75) }}...</div>

                                    </div>

                                </a>

                            </div>

                    @endforeach

                </div>
        </section>

    @endif

@endsection

