@extends('frontend/base/section')

@section('script_personal')
    <script>

        var filtroSelecionado = [];

        function init() {

            var urlParams = new URLSearchParams(window.location.search);

            for (var pair of urlParams.entries()) {
                var data = {[pair[0]]: pair[1]};
                filtroSelecionado.push(data);
            }

        }

        init();


        function removerFiltro(field) {


            if (field == 'ano') {
                removeFilter('ano_de');
                removeFilter('ano_ate');

            }

            if (field == 'faixa') {
                removeFilter('faixa_de');
                removeFilter('faixa_ate');
            }


            removeFilter(field)

            console.log(filtroSelecionado);
            buscar();
        }

        function removeFilter(field) {
            var indice_a_remover = null;

            filtroSelecionado.map(function (object, indice) {
                if (object.hasOwnProperty(field)) {

                    indice_a_remover = indice;
                    filtroSelecionado.splice(indice_a_remover, 1);
                }
            });


        }


        function setParamsField(field, value) {

            console.log(field);
            console.log(value);

            var data = {[field]: value};
            var existe_a_variavel = false;
            filtroSelecionado.map(function (o) {
                //Se existir a chave no filtro
                if (o.hasOwnProperty(field)) {
                    o[field] = value;
                    existe_a_variavel = true;
                }
                return o;
            })
            //se a key já existe e se o valor já foi alterado então faz a busca
            if (existe_a_variavel) {
                return
            }

            filtroSelecionado.push(data);
            return;
        }

        function setParams(field, value) {

            var data = {[field]: value};


            var existe_a_variavel = false;
            filtroSelecionado.map(function (o) {
                //Se existir a chave no filtro
                if (o.hasOwnProperty(field)) {
                    o[field] = value;
                    existe_a_variavel = true;
                }
                return o;
            })


            //se a key já existe e se o valor já foi alterado então faz a busca
            if (existe_a_variavel) {
                buscar();
                return
            }


            filtroSelecionado.push(data);

            buscar();
            return;
        }

        function clearFilter() {
            alert('clear filter');
        }


        function toTransformString(obj) {

            data = obj.map(function (x, y) {
                ref = $.map(x, function (val, index) {
                    var str = index + "=" + val;
                    return str;
                }).join('&');
                return ref;
            }).join('&');

            return data;

        }

        function buscar() {

            jsonString = toTransformString(filtroSelecionado)

            console.log(jsonString);

            url = '/estoque?' + jsonString;

            window.location.href = url;

        }
    </script>
@endsection
@section('content')

    <div class="centralizado">

        <h2 class="pagina_titulo visuallyhidden">{{ $pagina }}</h2>

        <div class="b-xs-12 b-md-3">

            <nav class="filtros">

                <div class="js-accordion" data-accordion-prefix-classes="accordion">


                    @include('frontend/estoque/partial/filtro_selecionado')






                    @if(!$aFiltradoPor['marca'])
                        @if($geral->filtro_exibe_marca == 'Sim')

                            <h3 class="js-accordion__header">Marca</h3>

                            <div class="js-accordion__panel">

                                <ul class="filtros_lista">

                                    @foreach($aFiltro['aMarca'] as $id => $marca)

                                        <li class="filtros_item">

                                            <a onclick="setParams('marca', '{{ $id }}')" class="filtros_link">
                                                {{ $marca }}
                                            </a>

                                        </li>

                                    @endforeach

                                </ul>

                            </div>

                        @endif
                    @endif

                    @if(!$aFiltradoPor['modelo'])
                        @if($geral->filtro_exibe_modelo == 'Sim')
                            <h3 class="js-accordion__header">Modelo</h3>

                            <div class="js-accordion__panel">

                                <ul class="filtros_lista">

                                    @foreach($aFiltro['aModelo'] as $id => $modelo)

                                        <li class="filtros_item">


                                            <a onclick="setParams('modelo', '{{ $id }}')" class="filtros_link">
                                                {{ $modelo }}
                                            </a>

                                        </li>

                                    @endforeach

                                </ul>

                            </div>
                        @endif
                    @endif

                    @if($geral->filtro_exibe_ano == 'Sim')
                        @if(!$aFiltradoPor['ano_de']||!$aFiltradoPor['ano_ate'])



                            <h3 class="js-accordion__header">Ano</h3>

                            <div class="js-accordion__panel">

                                <form class="filtros_form" name="filtro_valor" id="filtro_valor" method="post">
                                    <div class="grid-container">
                                        <div class="{{ $inputClass }}">
                                            <select name="ano_de" class="ano_de"
                                                    onChange="setParamsField('ano_de',  this.value)">
                                                <option value="">De</option>
                                                @foreach($aFiltro['aAno'] as $ano)
                                                    <option value="{{ $ano }}" {{$aFiltradoPor['ano_de']==$ano ? 'selected':''}}>{{ $ano }}</option>
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="{{ $inputClass }}">
                                            <select name="ano_ate" class=""
                                                    onChange="setParamsField('ano_ate',  this.value)">
                                                <option value="">Até</option>
                                                @foreach($aFiltro['aAno'] as $ano)
                                                    <option value="{{ $ano }}" {{$aFiltradoPor['ano_ate']==$ano ? 'selected':''}}>{{ $ano }}</option>
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="{{ $buttonClass }}">

                                            @if($geral->tema == 'tema_2')

                                                <button class="bt filtros_form_botao" type="button" onclick="buscar()">

                                                    <span class="bt_texto">Filtrar </span>

                                                </button>

                                            @else

                                                <button type="button" class="bt filtros_form_botao_ano"
                                                        onclick="buscar()">

                                                    <span class="fa fa-angle-right bt_icone"></span>

                                                </button>

                                            @endif

                                        </div>

                                    </div>
                                </form>


                            </div>
                        @endif
                    @endif

                    @if(!$aFiltradoPor['combustivel'])

                        <h3 class="js-accordion__header">Combustível</h3>

                        <div class="js-accordion__panel">

                            <ul class="filtros_lista">

                                @foreach($aFiltro['aCombustivel'] as $combustivel)

                                    <li class="filtros_item">

                                        <a onclick="setParams('combustivel', '{{ $combustivel }}')"
                                           class="filtros_link">

                                            {{ $combustivel }}

                                        </a>

                                    </li>

                                @endforeach

                            </ul>

                        </div>
                    @endif
                    <h3 class="js-accordion__header" data-accordion-opened="true" id="filtro_faixa_preco">Faixa de
                        Preço</h3>

                    <div class="js-accordion__panel">

                        <form class="filtros_form" name="filtro_valor" id="filtro_valor" method="post">

                            <div class="grid-container">

                                <div class="{{ $inputClass }}">

                                    <input type="text" name="faixa_de" id="faixa_de" class="text real"
                                           value="{{ $aFiltradoPor['faixa_de'] }}"
                                           onblur="setParamsField('faixa_de',this.value)">

                                </div>


                                <div class="{{ $inputClass }}">

                                    <input type="text" name="faixa_ate" id="faixa_ate" class="text real"
                                           value="{{ $aFiltradoPor['faixa_ate'] }}"
                                           onblur="setParamsField('faixa_ate',this.value)">

                                </div>

                                <div class="{{ $buttonClass }}">

                                    @if($geral->tema == 'tema_2')

                                        <button class="bt filtros_form_botao" type="button" onclick="buscar()">

                                            <span class="bt_texto">Filtrar </span>

                                        </button>

                                    @else

                                        <button type="button" class="bt filtros_form_botao" onclick="buscar()">

                                            <span class="fa fa-angle-right bt_icone"></span>

                                        </button>

                                    @endif

                                </div>

                            </div>

                        </form>

                    </div>

                    @if(!$aFiltradoPor['outros'])

                        <h3 class="js-accordion__header">Outros</h3>

                        <div class="js-accordion__panel">

                            <ul class="filtros_lista">

                                @foreach($aFiltro['aOutro'] as $outro)

                                    <li class="filtros_item">

                                        <a onclick="setParams('outros','{{ $outro }}')" class="filtros_link">
                                            {{ $outro }}
                                        </a>


                                    </li>

                                @endforeach

                            </ul>

                        </div>

                    @endif

                </div>

            </nav>

        </div>

        <div class="b-xs-12 b-md-9">

            <div class="lista-veiculo">

                @if( count($veiculo) == 0)

                    <div class="alert alert-danger" style="font-size: 20px;">
                        Desculpem, nenhum veículo encontrado.

                        <a href="estoque/remove-filtro?filtro=all" style="text-decoration: none; ">Limpar filtro</a>
                    </div>
                @endif


                @foreach($veiculo as $index => $item)

                    <div class="b-xs-12 b-sm-6 b-md-4 {{ (($index+1%2 == 1) ? 'b-sm-c' : '') }} {{ (($index+1%3 == 1) ? 'b-md-c b-lg-c b-xl-c' : '') }}">
                        <div class="veiculo veiculo-destaque" {{($geral->tema=='tema_2')?'style="min-height: 311px;"':''}}>

                            @if($item->oferta == 1)
                                <div class="ribbon_3"><span>OFERTA</span></div>
                            @endif

                            @if($item->destaque == 1)
                                <div class="ribbon_3"><span>DESTAQUE</span></div>
                            @endif

                            @if($item->repasse == 1)
                                <div class="ribbon_3"><span>REPASSE</span></div>
                            @endif
                            <a href="veiculo/{{ $item->alias }}" class="veiculo_imagem_container">

                                @if(!$item->imagem)

                                    <img src="{{$url}}/assets/frontend/{{$geral->tema}}/imagens/padrao.jpg" alt=""
                                         class="veiculo_imagem">

                                @else

                                    <img src="{{$url}}/arquivo/{{ $cliente->id }}/veiculo/{{ $item->id }}/{{ $item->imagem }}"
                                         alt="" class="veiculo_imagem">

                                @endif

                                @if($item->destaque == 1)

                                    <span class="veiculo_selo-destaque">Destaque</span>

                                @endif

                                @if($item->oferta == 1)

                                    <span class="veiculo_selo-destaque">Oferta</span>

                                @endif

                                @if($item->repasse == 1)

                                    <span class="veiculo_selo-destaque">repasse</span>

                                @endif

                            </a>

                            <div class="veiculo_info">

                                <div class="veiculo_modelo">{{ substr($item->nome,0,-9) }}</div>

                                @if($item->valor == 0)

                                    <div class="veiculo_preco">Consultar Preço</div>
                                @else

                                    <div class="veiculo_preco">R$ {{ \Base\Decimal::exibe($item->valor) }}</div>

                                @endif


                                <div class="veiculo_dados">
                                    Ano {{ $geral->exibe_ano == 'Ano modelo' ? $item->modelo : $item->fabricacao.'/'.$item->modelo}}
                                    / {{ ($item->placa != NULL ? ($item->quilometragem < 100 ? 'Consultar Km' : \Base\Decimal::exibe($item->quilometragem, 0).' Km') : \Base\Decimal::exibe($item->quilometragem, 0).' Km') }}
                                    / {{ $item->combustivel }}
                                </div>

                            </div>

                        </div>

                    </div>

                @endforeach

            </div>

            <div class="clear"></div>

            @if( count($veiculo) != 0)

                {{ \Lib\Paginacao::paginacao($quantidadePagina) }}

            @endif
        </div>

    </div>

@endsection

