@extends('frontend/base/section')

@section('content')

    @if(sizeof($filial) == 1)

        <div class="centralizado">

            <h2 class="pagina_titulo visuallyhidden">{{ $pagina }}</h2>

            <div class="clearfix">

                <div class="b-xs-12 b-md-5">

                    <form method="POST" class="form-contato" onsubmit="return validarFormulario()">

                        <div class="campo">
                            <label class="visuallyhidden" for="contato_nome">Nome</label>
                            <input placeholder="Nome *" type="text" id="contato_nome" name="contato_nome"
                                   value="{{$_SESSION['form']['contato_nome']}}" class="text" required>
                        </div>

                        <div class="campo">
                            <label class="visuallyhidden" for="contato_email">E-mail</label>
                            <input placeholder="E-mail *" type="email" id="contato_email" name="contato_email"
                                   value="{{$_SESSION['form']['contato_email']}}" class="text" required>
                        </div>

                        <div class="campo">
                            <label class="visuallyhidden" for="contato_telefone">Telefone</label>
                            <input placeholder="Telefone" type="text" id="contato_telefone" name="contato_telefone"
                                   value="{{$_SESSION['form']['contato_telefone']}}" class="text telefone">
                        </div>

                        <div class="campo">
                            <label class="visuallyhidden" for="contato_assunto">Assunto</label>
                            <input placeholder="Assunto *" type="text" id="contato_assunto" name="contato_assunto"
                                   value="{{$_SESSION['form']['contato_assunto']}}" class="text" required>
                        </div>

                        <div class="campo">
                            <label class="visuallyhidden" for="contato_mensagem">Mensagem</label>
                            <textarea placeholder="Mensagem *" id="contato_mensagem" name="contato_mensagem" required>
                                {{$_SESSION['form']['contato_mensagem']}}
                            </textarea>
                        </div>

                        @if($recaptcha)
                        <div class="g-recaptcha" data-sitekey="{{$recaptcha}}"></div>
                        @endif

                        @if($_SESSION['msg_error'])

                            <div style="background-color: red;color:#FFFFFF;padding: 20px;margin-bottom: 20px;">
                                {{$_SESSION['msg_error']}}
                                {{ ''; unset($_SESSION['msg_error']); }}

                            </div>

                        @endif
                        @if($_SESSION['msg'])

                            <div style="background-color: #13B5C7;color:#FFFFFF;padding: 20px;margin-bottom: 20px;">
                                {{$_SESSION['msg']}}
                                {{ ''; unset($_SESSION['msg']); }}

                            </div>

                        @endif
                        <div class="botao">
                            <input type="submit" value="Enviar" class="bt form-contato_botao">
                        </div>


                    </form>

                </div>

                <div class="b-xs-12 b-md-7">

                    <div class="mapa">

                        <iframe src="{{ $matriz->endereco_mapa }}" width="100%" height="100%" frameborder="0"
                                style="border:0"></iframe>

                    </div>

                </div>

            </div>

            <div class="clearfix">

                @foreach($filial as $matriz)

                    <aside itemscope itemtype="http://schema.org/Organization" class="orgschema">

                        <h2 itemprop="name" class="visuallyhidden">{{ $matriz->nome }}</h2>
                        <div class="b-xs-12 b-md-5">

                            <div class="contatos-icones">

                                @foreach(range(1,3) as $x)

                                    @if($matriz->{'telefone_tipo_'.$x})

                                        {{ $matriz->{'telefone_tipo_'.$x} }}:

                                        @if((strtolower($matriz->{'telefone_icone_'.$x}) == 'whatsapp'))

                                            <a href="/base/redirect?n={{ str_replace(array('(', ')', ' ', '-'),array('', '', '', ''),$matriz->{'telefone_valor_'.$x}) }}"
                                               class="rodape-filiais_endereco--destaque"
                                               itemprop="telephone"
                                            >
                                               {{ \Lib\Mascara::telefone($matriz->{'telefone_valor_'.$x}) }}
                                            </a>
                                            <br/>
                                        @else
                                            <a href="tel:0{{ str_replace(['(',')','-', ' '], ['','','',''],$matriz->{'telefone_valor_'.$x}) }}"
                                               itemprop="telephone">{{ \Lib\Mascara::telefone($matriz->{'telefone_valor_'.$x}) }}</a>
                                            <br/>
                                        @endif

                                    @endif

                                @endforeach

                                <a href="mailto:{{ $matriz->email }}" itemprop="email">{{ $matriz->email }}</a>

                            </div>

                            @if($matriz->{'horario_tipo_1'} != null)

                                <time itemprop="openingHours">

                                    @foreach(range(1,3) as $x)

                                        @if($matriz->{'horario_tipo_'.$x})

                                            {{ $matriz->{'horario_tipo_'.$x} }}:
                                            <span> {{ $matriz->{'horario_valor_'.$x} }} </span><br/>

                                        @endif

                                    @endforeach

                                </time>

                            @endif

                        </div>

                        <div class="b-xs-12 b-md-7">

                            <div itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">

                                <span itemprop="streetAddress">{{ $matriz->endereco_rua }}
                                    , {{ $matriz->endereco_numero }}{{ $matriz->endereco_complemento ? ', '.$matriz->endereco_complemento : '' }}</span><br>

                                {{ $matriz->endereco_bairro }}, <span
                                        itemprop="addressLocality">{{ $matriz->endereco_cidade }}</span> / <acronym
                                        itemprop="addressRegion">{{ $matriz->endereco_uf }}</acronym><br>

                                CEP: <span class="postalCode">{{ $matriz->endereco_cep }}</span>

                            </div>

                        </div>

                    </aside>

                @endforeach

            </div>

        </div>

    @else

        <div class="centralizado">

            <h2 class="pagina_titulo visuallyhidden">{{ $pagina }}</h2>

            <div class="clearfix">

                <div class="b-xs-12">

                    <form method="POST" class="form-contato">

                        <div class="grid-container">

                            <div class="b-xs-6">

                                <div class="campo">

                                    <label class="visuallyhidden" for="contato_nome">Nome</label>

                                    <input placeholder="Nome *" type="text" id="contato_nome" name="contato_nome"
                                           class="text" required>

                                </div>

                            </div>

                            <div class="b-xs-6">

                                <div class="campo">
                                    <label class="visuallyhidden" for="contato_email">E-mail</label>
                                    <input placeholder="E-mail *" type="email" id="contato_email" name="contato_email"
                                           class="text" required>
                                </div>

                            </div>

                            <div class="b-xs-6">

                                <div class="campo">
                                    <label class="visuallyhidden" for="contato_telefone">Telefone</label>
                                    <input placeholder="Telefone" type="text" id="contato_telefone"
                                           name="contato_telefone" class="text telefone">
                                </div>

                            </div>

                            <div class="b-xs-6">

                                <div class="campo">
                                    <label class="visuallyhidden" for="contato_assunto">Assunto</label>
                                    <input placeholder="Assunto *" type="text" id="contato_assunto"
                                           name="contato_assunto" class="text" required>
                                </div>

                            </div>

                            <div class="b-xs-12">

                                <div class="campo">
                                    <label class="visuallyhidden" for="contato_mensagem">Mensagem</label>
                                    <textarea placeholder="Mensagem *" id="contato_mensagem" name="contato_mensagem"
                                              required></textarea>
                                </div>

                            </div>

                            <div class="b-xs-12">

                                <div class="botao">
                                    <input type="submit" value="Enviar" class="bt form-contato_botao">
                                </div>

                            </div>

                        </div>

                    </form>

                    <hr>

                </div>

            </div>

            <!-- INÍCIO: Filiais -->
            <!-- A partir daqui só exibe se houver filiais -->
            <div class="lista-filiais" id="filiais">

                @foreach($filial as $item)

                    <aside itemscope itemtype="http://schema.org/Organization"
                           class="orgschema orgschema-filial clearfix">

                        <div class="b-xs-12">

                            <h4 itemprop="name">{{ $item->tipo }} - {{ $item->nome }}</h4>

                        </div>

                        @if($item->endereco_mapa)

                            <div class="b-xs-12">

                                <div class="orgschema_mapa">

                                    <iframe src="{{ $item->endereco_mapa }}" width="100%" height="350" frameborder="0"
                                            style="border:0"></iframe>

                                </div>

                            </div>

                        @endif

                        <div class="b-xs-12 b-sm-4">

                            <div class="contatos-icones">


                                @foreach(array(1,2,3) as $x)

                                    @if($item->{'telefone_tipo_'.$x})

                                        {{ $item->{'telefone_tipo_'.$x} }}

                                        @if((strtolower($item->{'telefone_icone_'.$x}) == 'whatsapp'))

                                                <a href="/base/redirect?n={{ str_replace(array('(', ')', ' ', '-'),array('', '', '', ''),$item->{'telefone_valor_'.$x}) }}"
                                                   class="rodape-filiais_endereco--destaque"
                                                   itemprop="telephone"
                                                >
                                                {{ \Lib\Mascara::telefone($item->{'telefone_valor_'.$x}) }}
                                            </a>
                                            <br/>
                                        @else
                                            <a href="tel:0{{ str_replace(['(',')','-', ' '], ['','','',''],$item->{'telefone_valor_'.$x}) }}"
                                               itemprop="telephone">{{ \Lib\Mascara::telefone($item->{'telefone_valor_'.$x}) }}</a>
                                            <br/>
                                        @endif

                                    @endif

                                @endforeach

                            </div>

                        </div>

                        <div class="b-xs-12 b-sm-4">

                            @if($item->{'horario_tipo_1'})

                                <time itemprop="openingHours">

                                    @foreach(range(1,3) as $x)

                                        @if($item->{'horario_tipo_'.$x})

                                            {{ $item->{'horario_tipo_'.$x} }}:
                                            <span> {{ $item->{'horario_valor_'.$x} }} </span><br/>

                                        @endif

                                    @endforeach

                                </time>

                            @endif

                            <br/>
                        </div>

                        <div class="b-xs-12 b-sm-4">

                            <div itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">

                                <span itemprop="streetAddress">{{ $item->endereco_rua }} {{ ($item->endereco_numero ? ', '.$item->endereco_numero : '') }}{{ $item->endereco_complemento ? ', '.$item->endereco_complemento : '' }}</span><br>

                                {{ $item->endereco_bairro }}, <span
                                        itemprop="addressLocality">{{ $item->endereco_cidade }}</span> / <acronym
                                        itemprop="addressRegion">{{ $item->endereco_uf }}</acronym><br>

                                CEP: <span class="postalCode">{{ $item->endereco_cep }}</span>

                            </div>

                        </div>

                    </aside>

                    <hr>

                @endforeach

            </div>
            <!-- FIM: Filiais -->

        </div>

    @endif

@endsection

@section('javascript')

    <script>
        function validarFormulario(){


            @if(!$recaptcha)
                return true;
            @endif

            var response = grecaptcha.getResponse();

            if(response.length == 0){
                alert('Preencha o captcha');
                return false;
            }

            return true;
        }
        @if($_SESSION['msg'])

        alert('{{ $_SESSION['msg'] }}');

        {{ ''; unset($_SESSION['msg']); }}

        @endif


    </script>

@endsection

