@extends('backend/base/section')

@section('content')

    <form method="post">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="backend/noticia/index" class="btn btn-default">Voltar</a>

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                @include('backend/noticia/partial/painel/cadastro')

            </div><!-- .col -->

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>

    $('form').submit( function(){


        var editor = CKEDITOR.instances['integra'];
        var valor = editor.getData();
        var erroIntegra = $('#erro-integra');
        var erroInput = $('#erro-input');
        var imagem = $("#imagem-exibe").attr("src");

        erroIntegra.removeClass('vermelho');
        erroIntegra.text('');
        erroInput.removeClass('vermelho');
        erroInput.text('');

        if (valor === '')
        {

            erroIntegra.addClass('vermelho');
            erroIntegra.text('Este campo é requerido.');

            swal('Atenção', 'Preencha todos os campos obrigatórios.');

            if (imagem == '' || imagem == undefined)
            {

                erroInput.addClass('vermelho');
                erroInput.text('Este campo é requerido.');

                swal('Atenção','Preencha todos os campos obrigatórios.');

            }

            return false;

        }

        if (imagem == '' || imagem == undefined)
        {

            erroInput.addClass('vermelho');
            erroInput.text('Este campo é requerido.');

            swal('Atenção','Preencha todos os campos obrigatórios.');

            return false;

        }




        return true;

    });

    function imagemClick ()
    {

        $('#file-upload').trigger('click');

    }

    $("#file-upload").change(function (event)
    {

        var img = $('#imagem-exibe');

        var reader = new FileReader();

        $(reader).load(function (event)
        {
            $("#imagem-exibe").attr("src", event.target.result);

            img.show();

        });

        reader.readAsDataURL(event.target.files[0]);

    });



    </script>

@endsection