@extends('backend/base/section')

@section('content')

    <form method="post">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="backend/foto/index" class="btn btn-default">Voltar</a>

                @if (\Parvus\Input::get('id') != NULL)

                    <a href="javascript:void(0);" onClick="exclui('backend/foto/delete?id={{ $item['id'] }}')" class="btn btn-danger pull-right">Excluir</a>

                @endif

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                @include('backend/foto/partial/painel/cadastro')

            </div><!-- .col -->

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>

    $('form').submit( function(){


        var editor = CKEDITOR.instances['descricao'];
        var valor = editor.getData();
        var erroDescricao = $('#erro-descricao');
        var erroIcone = $('#erro-icone');
        var erroImagem = $('#erro-imagem');
        var icone = $("#icone-exibe").attr("src");
        var imagem = $("#imagem-exibe").attr("src");

        erroDescricao.removeClass('vermelho');
        erroDescricao.text('');

        erroIcone.removeClass('vermelho');
        erroIcone.text('');


        if (imagem != '')
        {

            erroImagem.removeClass('vermelho');
            erroImagem.text('');

        }

        if (valor === '')
        {

            erroDescricao.addClass('vermelho');
            erroDescricao.text('Este campo é requerido.');

            if (icone === '' || icone === undefined)
            {

                erroIcone.addClass('vermelho');
                erroIcone.text('Este campo é requerido.');

            }

            if (imagem === '' || imagem === undefined)
            {

                erroImagem.addClass('vermelho');
                erroImagem.text('Este campo é requerido.');

            }

            swal('Atenção','Preencha todos os campos obrigatórios.');

            return false;

        }

        if (icone === '' || icone === undefined)
        {

            erroIcone.addClass('vermelho');
            erroIcone.text('Este campo é requerido.');

            swal('Atenção','Preencha todos os campos obrigatórios.');

            return false;

        }

        if (imagem === '' || imagem === undefined)
        {

            erroImagem.addClass('vermelho');
            erroImagem.text('Este campo é requerido.');

            swal('Atenção','Preencha todos os campos obrigatórios.');

            return false;

        }

        return true;

    });

    function iconeClick ()
    {

        $('#icone-upload').trigger('click');

    }

    function imagemClick ()
    {

        $('#imagem-upload').trigger('click');

    }

    $("#icone-upload").change(function (event)
    {

        var img = $('#icone-exibe');

        var reader = new FileReader();

        $(reader).load(function (event)
        {
            $("#icone-exibe").attr("src", event.target.result);

            img.show();

        });

        reader.readAsDataURL(event.target.files[0]);

    });

    $("#imagem-upload").change(function (event)
    {

        var img = $('#imagem-exibe');

        var reader = new FileReader();

        $(reader).load(function (event)
        {
            $("#imagem-exibe").attr("src", event.target.result);

            img.show();

        });

        reader.readAsDataURL(event.target.files[0]);

    });





    </script>

@endsection