@extends('backend/base/section')

@section('content')

    <form method="post">

        <input type="hidden" name="id" value="1">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="backend/usuario/inicio" class="btn btn-default">Voltar</a>

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                <div class="panel panel-white">

                    <div class="panel-body">

                        <div class="row">

                            <div class="col-sm-12 col-lg-12">

                                <div class="form-group obrigatorio">

                                    <label for="exibe">Exibe</label>

                                    <select class="select2" name="exibe" id="exibe" required>

                                        {{ $aEnumeracao['exibe'] }}

                                    </select>

                                </div>

                            </div><!-- .col -->

                            <div class="col-sm-12 col-lg-12">

                                <div class="form-group {{ $item['exibe'] == 'Sim' ? 'obrigatorio' : ''}} div-link">

                                    <label for="canal">Link do canal</label>

                                    <input type="text" class="form-control" id="canal" name="canal" value="{{ $item['canal'] }}" {{ $item['exibe'] == 'Sim' ? 'required' : ''}}>

                                </div>

                            </div><!-- .col -->

                            <div class="clearfix"></div>

                            @foreach(range(1,3) as $x)

                                <div class="col-sm-12 col-lg-4">

                                    <div class="form-group">

                                        <label for="video_{{ $x }}">Link do vídeo {{ $x }}</label>

                                        <input type="text" class="form-control" id="video_{{ $x }}" name="video_{{ $x }}" value="{{ $item['video_'.$x] }}">

                                    </div>

                                </div><!-- .col -->

                            @endforeach

                        </div>

                    </div>

                </div><!-- .panel -->

            </div>

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>


        $('#exibe').change( function () {

            if($(this).val() === 'Sim')
            {

                $('#canal').attr('required', 'required');
                $('.div-link').addClass('obrigatorio');

            }
            else
            {

                $('#canal').removeAttr('required', 'required');
                $('.div-link').removeClass('obrigatorio');

            }

        })

    </script>

@endsection

