@extends('backend/base/section')

@section('content')

    <form method="post">

        <input type="hidden" name="id" value="{{ $item->id }}">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="backend/usuario/inicio" class="btn btn-default">Voltar</a>

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                <div class="panel panel-white">

                    <div class="panel-body">

                        <div class="row">

                            <div class="col-sm-12 col-lg-12">

                                <div class="form-group obrigatorio">

                                    <label for="exibe">Exibe</label>

                                    <select class="select2" name="exibe" id="exibe" required>

                                        {{ $aEnumeracao['exibe'] }}

                                    </select>

                                </div>

                            </div>

                            <div class="col-sm-12 col-lg-6">

                                <div class="form-group">

                                    <label for="frase_principal">Frase principal</label>

                                    <input type="text" class="form-control" id="frase_principal" name="frase_principal" value="{{ $item['frase_principal'] }}">

                                </div>

                            </div>

                            <div class="col-sm-12 col-lg-6">

                                <div class="form-group">

                                    <label for="frase_secundaria">Frase secundária</label>

                                    <input type="text" class="form-control" id="frase_secundaria" name="frase_secundaria" value="{{ $item['frase_secundaria'] }}">

                                </div>

                            </div>



                            <div class="col-sm-12 col-lg-6">

                                <div class="form-group">

                                    <label for="frase_principal">Frase do whatsapp</label>

                                    <input type="text" class="form-control" id="frase_whatsapp" name="frase_whatsapp" value="{{ $item['frase_whatsapp'] }}">

                                </div>

                            </div>


                            <div class="clearfix"></div>

                            <div class="col-sm-12 col-lg-6">

                                <div class="row">

                                    <div class="col-sm-12 col-lg-4">

                                        <div class="form-group">

                                            <label for="telefone_tipo_1">Telefone tipo 1</label>

                                            <select class="select2" name="telefone_tipo_1" id="telefone_tipo_1">

                                                {{ $aEnumeracao['telefone_tipo_1'] }}

                                            </select>

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-8">

                                        <div class="form-group">

                                            <label for="telefone_numero_1">Telefone 1</label>

                                            <input type="text" class="form-control telefone" id="telefone_numero_1" name="telefone_numero_1" value="{{ \Lib\Mascara::telefone($item['telefone_numero_1']) }}">

                                        </div>

                                    </div>


                                    <div class="col-sm-12 col-lg-12">

                                        <div class="form-group">

                                            <label for="telefone_frase_1">Telefone frase 1</label>

                                            <input type="text" class="form-control" id="telefone_frase_1" name="telefone_frase_1" value="{{ $item['telefone_frase_1'] }}">

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-4">

                                        <div class="form-group">

                                            <label for="telefone_tipo_3">Telefone tipo 3</label>

                                            <select class="select2" name="telefone_tipo_3" id="telefone_tipo_3">

                                                {{ $aEnumeracao['telefone_tipo_3'] }}

                                            </select>

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-8">

                                        <div class="form-group">

                                            <label for="telefone_numero_3">Telefone 3</label>

                                            <input type="text" class="form-control telefone" id="telefone_numero_3" name="telefone_numero_3" value="{{ \Lib\Mascara::telefone($item['telefone_numero_3']) }}">

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-12">

                                        <div class="form-group">

                                            <label for="telefone_frase_3">Telefone frase 3</label>

                                            <input type="text" class="form-control" id="telefone_frase_3" name="telefone_frase_3" value="{{ $item['telefone_frase_3'] }}">

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <div class="col-sm-12 col-lg-6">

                                <div class="row">

                                    <div class="col-sm-12 col-lg-4">

                                        <div class="form-group">

                                            <label for="telefone_tipo_2">Telefone tipo 2</label>

                                            <select class="select2" name="telefone_tipo_2" id="telefone_tipo_2">

                                                {{ $aEnumeracao['telefone_tipo_2'] }}

                                            </select>

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-8">

                                        <div class="form-group">

                                            <label for="telefone_numero_2">Telefone 2</label>

                                            <input type="text" class="form-control telefone" id="telefone_numero_2" name="telefone_numero_2" value="{{ \Lib\Mascara::telefone($item['telefone_numero_2']) }}">

                                        </div>

                                    </div>


                                    <div class="col-sm-12 col-lg-12">

                                        <div class="form-group">

                                            <label for="telefone_frase_2">Telefone frase 2</label>

                                            <input type="text" class="form-control" id="telefone_frase_2" name="telefone_frase_2" value="{{ $item['telefone_frase_2'] }}">

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-4">

                                        <div class="form-group">

                                            <label for="telefone_tipo_4">Telefone tipo 4</label>

                                            <select class="select2" name="telefone_tipo_4" id="telefone_tipo_4">

                                                {{ $aEnumeracao['telefone_tipo_4'] }}

                                            </select>

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-8">

                                        <div class="form-group">

                                            <label for="telefone_numero_4">Telefone 4</label>

                                            <input type="text" class="form-control telefone" id="telefone_numero_4" name="telefone_numero_4" value="{{ $item['telefone_numero_4'] ? \Lib\Mascara::telefone($item['telefone_numero_4']) : ''}}">

                                        </div>

                                    </div>

                                    <div class="col-sm-12 col-lg-12">

                                        <div class="form-group">

                                            <label for="telefone_frase_4">Telefone frase 4</label>

                                            <input type="text" class="form-control" id="telefone_frase_4" name="telefone_frase_4" value="{{ $item['telefone_frase_4'] }}">

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div><!-- .panel -->

            </div>

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>

        setTimeout( function () {

            $('#telefone_numero_1').trigger('blur');
            $('#telefone_numero_2').trigger('blur');

        }, 50)


    </script>

@endsection