@extends('backend/base/section')

@section('content')

    <form method="post">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="javascript:history.go(-1)" class="btn btn-default">Voltar</a>

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                @include('backend/configuracao/logo/partial/painel/cadastro')

            </div><!-- .col -->

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>

        $('form').submit( function()
        {

            var favicon = $("#favicon-exibe").attr("src");
            var logo = $("#logo-exibe").attr("src");
            var erroFavicon = $('#erro-favicon');
            var erroLogo = $('#erro-logo');


            if (logo != '')
            {

                erroLogo.removeClass('vermelho');
                erroLogo.text('');

            }

            if (favicon != '')
            {

                erroFavicon.removeClass('vermelho');
                erroFavicon.text('');

            }

            if (logo != '' && favicon === '')
            {

                erroFavicon.addClass('vermelho');

                erroFavicon.text('Este campo é requerido.');

                swal('Atenção','Preencha todos os campos obrigatórios.');

                return false;

            }

            if (logo === '' || logo === undefined)
            {

                erroLogo.addClass('vermelho');

                erroLogo.text('Este campo é requerido.');

                if (favicon === '' || favicon === undefined)
                {

                    erroFavicon.addClass('vermelho');

                    erroFavicon.text('Este campo é requerido.');

                    swal('Atenção','Preencha todos os campos obrigatórios.');

                    return false;

                }

                swal('Atenção','Preencha todos os campos obrigatórios.');

                return false;

            }

            return true;

        });

        function faviconClick ()
        {

            $('#favicon-upload').trigger('click');

        }

        $("#favicon-upload").change(function (event)
        {

            var img = $('#favicon-exibe');

            var reader = new FileReader();

            $(reader).load(function (event)
            {
                $("#favicon-exibe").attr("src", event.target.result);

                img.show();

            });

            reader.readAsDataURL(event.target.files[0]);

        });

        function logoClick ()
        {

            $('#logo-upload').trigger('click');

        }

        $("#logo-upload").change(function (event) {

            var img = $('#logo-exibe');

            var reader = new FileReader();

            $(reader).load(function (event) {
                $("#logo-exibe").attr("src", event.target.result);

                img.show();

            });

            reader.readAsDataURL(event.target.files[0]);
        });


    </script>

@endsection