@extends('backend/base/section')

@section('content')

    <form method="post">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="backend/usuario/inicio" class="btn btn-default">Voltar</a>

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                @include('backend/configuracao/contato/partial/painel/endereco')

            </div><!-- .col -->

            <div class="col-md-6">

                @include('backend/configuracao/contato/partial/painel/telefone')

            </div><!-- .col -->

            <div class="col-md-6">

                @include('backend/configuracao/contato/partial/painel/horario')

            </div><!-- .col -->

            <div class="col-md-12">

                {{--@include('backend/configuracao/contato/partial/painel/mapa')--}}

            </div><!-- .col -->

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>

        $('.telefone_tipo').on('change', function ()
        {

            var div = $('.telefone_'+$(this).data('ordem'));

            if($(this).val() !== '')
            {

                $(this).parent().addClass('obrigatorio');

                div.addClass('obrigatorio');

                div.find('input').removeAttr('disabled').attr('required');

            }
            else
            {

                $(this).parent().removeClass('obrigatorio');

                div.removeClass('obrigatorio');

                div.find('input').removeAttr('required').attr('disabled','disabled').val('');

            }

        });

        $('.horario_tipo').on('change', function ()
        {

            var div = $('.horario_'+$(this).data('ordem'));

            if($(this).val() !== '')
            {

                $(this).parent().addClass('obrigatorio');

                div.addClass('obrigatorio');

                div.find('input').removeAttr('disabled').attr('required');

            }
            else
            {

                $(this).parent().removeClass('obrigatorio');

                div.removeClass('obrigatorio');

                div.find('input').removeAttr('required').attr('disabled','disabled').val('');

            }

        });

        $('.telefone_tipo').trigger('change');
        $('.horario_tipo').trigger('change');

    </script>

@endsection
