<?php
namespace Model;

    use Illuminate\Database\Eloquent\Builder;
    use Illuminate\Database\Eloquent\ScopeInterface;
    use Parvus\Date;

    class Base extends \Illuminate\Database\Eloquent\Model
    {

        protected 	$primaryKey 	= 'id';
        public      $timestamps     = false;
        protected   $temLog         = true;
        private     $usuario        = NULL;

        public function __construct()
        {

            parent::__construct();
            parent::boot();

            /** Ao inserir, salva os logs */
            static::creating(function ($model)
            {

                if (!$this->temLog)
                {
                    return true;
                }

                $usuario_id = empty($_SESSION['usuario_id'])?1:$_SESSION['usuario_id'];

                $model->log_cadastro_data        = date ('Y-m-d H:i:s');
                $model->log_cadastro_usuario_id  = $usuario_id;

                return true;
            });

            /** Ao alterar, insere os logs */
            static::updating(function ($model)
            {

                if (!$this->temLog)
                {
                    return true;
                }

                $model->log_alterado_data        = date ('Y-m-d H:i:s');
                $model->log_alterado_usuario_id  = $_SESSION['usuario_id'];

                return true;

            });

            /** Quando salva um registro, remove os campos nulos */
            static::saving(function($model)
            {
                foreach ($model->toArray() as $name => $value)
                {
                    if ((string) $value == NULL)
                    {
                        $model->{$name} = null;
                    }
                }

                return true;
            });

            /** Se tem log, remove os registros excluídos */
            if ($this->temLog)
            {

                static::addGlobalScope(new ExcluidoScope());

            }

        }

        /**
         * Salva um array no objeto
         * @param $prArray
         */
        public final function saveArray ($prArray)
        {

            foreach ($prArray as $label => $value)
            {

                $this->$label = $value;

            }

            $this->save();

        }

        /**
         * Transformar os campos informados para lower
         * @param $prArray
         */
        public final function lower ($prArray)
        {

            foreach ($prArray as $label)
            {
                $this->$label = strToLower($this->$label);
            }

        }

        /**
         * Transformar os campos informados para upper
         * @param $prArray
         */
        public final function upper ($prArray)
        {

            foreach ($prArray as $label)
            {
                $this->$label = strToUpper($this->$label);
            }

        }

        /**
         * Exibe uma data em formato brasileiro
         * @param $prValue
         * @return bool|null|string
         */
        public final function date ($prValue, $prFormato = 'd/m/Y')
        {

            return Date::date($prValue, $prFormato);

        }

        public function excluir(){
            parent::delete();
        }

        /**
         * Gera o log de exclusão de um registro
         */
        public final function delete ($prId)
        {

            if (!$this->temLog)
            {
                parent::delete();
                return true;
            }

            $model = $this->find($prId);

            $model->log_excluido_data        = date ('Y-m-d H:i:s');
            $model->log_excluido_usuario_id  = $_SESSION['usuario_id'];

            $model->save();

            return true;

        }
        
    }

    class ExcluidoScope implements ScopeInterface
    {

        public function apply(Builder $builder)
        {
            $builder->whereNull('log_excluido_data');
        }

        public function remove(Builder $builder) {}
        
    }