<?php

    namespace Lib;

    use Illuminate\Support\Facades\File;
    use Imagine\Gd\Imagine;
    use Imagine\Image\Box;
    use Imagine\Image\ImageInterface;

    class Imagem
    {

        public $nome = null, $pasta = null, $tamanho = null;
        public $aFile = array(),$aExtensao = array(), $aDimensao = array();

        /**
         * Imagem constructor.
         * @param array $prFile
         * @param string $prNome
         * @param string $prPasta
         * @param array $prADimensao (altura, largura)
         * @param array $prAExtensao
         * @param string $prTamanho (MB)
         */
        public final function __construct($prFile, $prNome = null, $prPasta, $prADimensao = null, $prAExtensao = ['jpg', 'jpeg', 'png'], $prTamanho = '3')
        {

            $this->aFile        = $prFile;
            $this->nome         = $prNome;
            $this->pasta        = $prPasta;
            $this->aDimensao    = $prADimensao ? $prADimensao : array('altura' => $prFile['dimension']['height'], 'largura' => $prFile['dimension']['width']);
            $this->aExtensao    = $prAExtensao;
            $this->tamanho      = $prTamanho;

            if(!is_dir('arquivo/'))
            {

                mkdir('arquivo/');

            }

            if(!is_dir('arquivo/1/'))
            {

                mkdir('arquivo/1');

            }

            /**
             * Gera nome do arquivo
             */
            if($this->nome == NULL)
            {

                $this->nome = time().rand(1,999).md5(rand(1,999999)).md5(time()).uniqid().'.'.$this->aFile['extension'];

            }
            else
            {

                $this->nome = $this->nome.'_'.md5(time()).uniqid().'.'.$this->aFile['extension'];

            }

        }

        public final function setNome ($prNome)
        {

            $this->nome = $prNome;

        }

        public final function criaPasta($prCaminho = null)
        {

            if(!is_dir('arquivo/'))
            {

                mkdir('arquivo/');

            }

            if(!is_dir('arquivo/1/'))
            {

                mkdir('arquivo/1');

            }

            if($prCaminho)
            {

                if(!is_dir($prCaminho))
                {

                    mkdir($prCaminho);

                }

            }

        }

        /**
         * Redimensiona uma imagem
         * @return bool|null|string
         */
        public final function resize()
        {

            /**
             * Valida as extensões e tamanho
             */
            if(in_array($this->aFile['extension'], $this->aExtensao) && $this->aFile['size']['megabyte'] <= $this->tamanho)
            {

                mkdir($this->pasta);

                /**
                 * Copia a imagem
                 */
                if(copy($this->aFile['tmp_name'], $this->pasta.'/'.$this->nome))
                {

                    $imagine = new Imagine();

                    $imagine
                        ->open($this->pasta.'/'.$this->nome)
                        ->resize(new Box($this->aDimensao['largura'],$this->aDimensao['altura']))
                        ->save($this->pasta.'/'.$this->nome);

                    return $this->nome;

                }

            }

            return false;

        }

        /**
         * Redimensiona uma imagem
         * @return bool|null|string
         */
        public final function thumbnail()
        {

            /**
             * Valida as extensões e tamanho
             */
            if(in_array($this->aFile['extension'], $this->aExtensao) && $this->aFile['size']['megabyte'] <= $this->tamanho)
            {

                @mkdir($this->pasta);
                /**
                 * Copia a imagem
                 */
                if(copy($this->aFile['tmp_name'], $this->pasta.'/'.$this->nome))
                {

                    $imagine = new Imagine();

                    $imagine
                        ->open($this->pasta.'/'.$this->nome)
                        ->thumbnail(new Box($this->aDimensao['largura'],$this->aDimensao['altura']), ImageInterface::THUMBNAIL_OUTBOUND)
                        ->save($this->pasta.'/'.$this->nome);

                    return $this->nome;

                }

            }

            return false;

        }

        public final function move()
        {

            /**
             * Valida as extensões e tamanho
             */
            if(in_array($this->aFile['extension'], $this->aExtensao) && $this->aFile['size']['megabyte'] <= $this->tamanho)
            {

                /**
                 * Copia a imagem
                 */
                if(copy($this->aFile['tmp_name'], $this->pasta.'/'.$this->nome))
                {

                    return $this->nome;

                }

            }

            return false;

        }

    }