<?php

namespace Lib;

use Model\Cliente;
use Model\ConfiguracaoEmail;

class Email
{

    public static function envia($prCorpoEmail, $prAssunto, $prCliente, $prTipo = null, $prAnexo = null)
    {

        $cliente = Cliente::where('id', $prCliente->id)->first();

        $configuracaoEmail = \Model\ConfiguracaoEmail::where('cliente_id', $prCliente->id)->first();

        if ($prTipo == NULL) {

            $receptor = $configuracaoEmail->emissor_email;
            $receptor_nome = $cliente->nome;

        } else {

            if ($configuracaoEmail->{'email_' . $prTipo} == NULL) {

                $configuracaoEmail->saveArray([
                    'nome_' . $prTipo => $configuracaoEmail->receptor_nome,
                    'email_' . $prTipo => $configuracaoEmail->receptor_email
                ]);

                $receptor = $configuracaoEmail->receptor_email;
                $receptor_nome = $configuracaoEmail->receptor_nome;

                $configuracaoEmail = \Model\ConfiguracaoEmail::where('cliente_id', $prCliente->id)->first();

            } else {

                $receptor = $configuracaoEmail->{'email_' . $prTipo};
                $receptor_nome = $configuracaoEmail->{'nome_' . $prTipo};

            }

        }

        if ($receptor == NULL) {

            $receptor = $configuracaoEmail->emissor_email;

        }

        if ($receptor_nome == NULL) {

            $receptor_nome = $cliente->nome;

        }

        $email = new \Parvus\Mail();

        $email->setHost($configuracaoEmail->smtp);
        $email->setUser($configuracaoEmail->emissor_email);
        $email->setPassword($configuracaoEmail->emissor_senha);
        $email->setPort($configuracaoEmail->porta);
        $email->setSMTPSecure($configuracaoEmail->autenticacao_seguranca);
        $email->setFrom($receptor_nome, $configuracaoEmail->emissor_email);

        $email->address($receptor, $receptor_nome);

        $email->subject($prAssunto);

        $email->body($prCorpoEmail);

        $email->setView('frontend/base/email', [
            'cliente' => $cliente,
        ]);

        if ($prAnexo) {

            foreach ($prAnexo as $anexo) {

                $email->attachment($anexo['tmp_name'], $anexo['name']);

            }

        };

        $email->sent(false);

        return true;

    }

}