<?php
    namespace Base;

    class W2O
    {

        /**
         * Valida se a senha é a master da W2O
         * @param $prSenha
         * @return bool
         */
        public final static function senha ($prSenha)
        {

            /** Se for local, sempre retorna verdadeiro e não usa senha */
            if (environment == 'local')
            {

                return true;

            }

            if (!extension_loaded('curl'))
            {

                trigger_error('cURL não instalado no servidor.',E_CORE_ERROR);

            }

            $cURL = curl_init();
            curl_setopt($cURL, CURLOPT_URL, 'http://www.w2o.com.br/componentes/W2OPass/');
            curl_setopt($cURL, CURLOPT_POSTFIELDS, http_build_query(array('senha' => $prSenha)));
            curl_setopt($cURL, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($cURL, CURLOPT_CONNECTTIMEOUT, 5);
            $resultado = curl_exec($cURL);

            if (!$resultado)
            {
                $resultado = '0';
            }

            curl_close($cURL);

            return $resultado == '1' ? true : false;

        }

    }