<?php
    namespace Base;

    class Menu
    {

        /**
         * @return string
         */
        public static final function get ()
        {

            $aMenu = array();
            $aId = array();

            $aMenu = array(
                '0' => array(
                    'nome'      => 'Configuração',
                    'id'        => 'configuracao',
                    'URL'       => '',
                    'icone'     => 'fa-wrench',
                    'aSubmenu'  => array(
                        '1' => array(
                            'nome'      => 'E-mail',
                            'id'        => 'email',
                            'URL'       => 'backend/email/form'
                        ),
                        '2' => array(
                            'nome'      => 'Cores',
                            'id'        => 'cor',
                            'URL'       => 'backend/cor/form'
                        ),
                        '3' => array(
                            'nome'      => 'Logo',
                            'id'        => 'logo',
                            'URL'       => 'backend/logo/form'
                        ),
                        '4' => array(
                            'nome'      => 'Scripts',
                            'id'        => 'analytics',
                            'URL'       => 'backend/analytics/form'
                        ),
                        '5' => array(
                            'nome'      => 'Chat',
                            'id'        => 'chat',
                            'URL'       => 'backend/chat/form'
                        ),
                        '6' => array(
                            'nome'      => 'Páginas',
                            'id'        => 'pagina',
                            'URL'       => 'backend/pagina/form'
                        ),
                        '7' => array(
                            'nome'      => 'Redes Sociais',
                            'id'        => 'rede_social',
                            'URL'       => 'backend/rede-social/index'
                        ),
                        '8' => array(
                            'nome'      => 'Contato',
                            'id'        => 'contato',
                            'URL'       => 'backend/contato-filial/index'
                        ),
                        '9' => array(
                            'nome'      => 'Parâmetros Gerais',
                            'id'        => 'parametro_geral',
                            'URL'       => 'backend/parametro-geral/form',
                        ),
                        '10' => array(
                            'nome'      => 'Rodapé Fixo',
                            'id'        => 'rodape_fixo',
                            'URL'       => 'backend/rodape-fixo/form',
                        ),
                        '11' => array(
                            'nome'      => 'Youtube',
                            'id'        => 'youtube',
                            'URL'       => 'backend/youtube/form',
                        ),
                        '12' => array(
                            'nome' => 'Google 360º',
                            'id' => 'google360',
                            'URL' => 'backend/google/form'
                        ),
                        '13' => array(
                            'nome' => 'Links externos',
                            'id' => 'links',
                            'URL' => 'backend/links/form'
                        ),
                    )
                ),
                '1' => array(
                    'nome'      => 'Banner',
                    'id'        => 'banner',
                    'URL'       => 'backend/banner/index',
                    'icone'     => 'fa-desktop',
                ),
                '2' => array(
                    'nome'      => 'Noticias',
                    'id'        => 'noticias',
                    'URL'       => 'backend/noticia/index',
                    'icone'     => 'fa-newspaper-o',
                ),
                '3' => array(
                    'nome'      => 'Empresa',
                    'id'        => 'empresa',
                    'URL'       => 'backend/empresa/form',
                    'icone'     => 'fa-briefcase'
                ),
                '4' => array(
                    'nome'      => 'Fotos',
                    'id'        => 'fotos',
                    'URL'       => 'backend/foto/index',
                    'icone'     => 'fa-camera'
                ),
                '5' => array(
                    'nome'      => 'Janela de aviso',
                    'id'        => 'modal',
                    'URL'       => 'backend/modal/form',
                    'icone'     => 'fa-bullhorn'
                ),
                '6' => array(
                    'nome'      => 'Versão',
                    'id'        => 'versao',
                    'URL'       => 'backend/versao/index',
                    'icone'     => 'fa-file-text'
                ),
            );

            $html = '<ul class="menu accordion-menu">';

                $html .= '<li><a href="backend/usuario/inicio" class="waves-effect waves-button"><span class="menu-icon glyphicon glyphicon-home"></span><p>Inicio</p></a></li>';

                foreach ($aMenu as $item)
                {

                    $html .= '<li class="'.($item['aSubmenu'] != NULL ? 'droplink' : NULL).'">';

                        $html.= '<a title="'.$item['nome'].'" id="menu-'.$item['id'].'" class="link" href="'.($item['URL'] != NULL ? $item['URL'] : 'javascript:void(0);').'">';

                            $html.= '<span class="menu-icon fa '.$item['icone'].'"></span><p>'.$item['nome'].'</p>';

                            if ($item['aSubmenu'] != NULL)
                            {

                                $html.= '<span class="arrow"></span>';

                            }

                        $html.= '</a>';

                        if ($item['aSubmenu'] != NULL)
                        {

                            $html .= self::submenu($item['aSubmenu']);

                        }

                    $html.= '</li>';

                }

            $html.= '</ul>';

            return $html;

        }

        /**
         * @param $prArray
         * @return string
         */
        private static final function submenu ($prArray)
        {

            $html = '<ul class="sub-menu">';

                foreach ($prArray as $item)
                {

                    $html.= '<li><a title="'.$item['nome'].'" href="'.$item['URL'].'">'.$item['nome'].'</a></li>';

                }

            $html.= '</ul>';

            return $html;

        }

    }