<?php
	namespace Controller;

    use Lib\Lib;
    use Model\Analytics;
    use Model\Cliente;
    use Model\ContatoFilial;
    use Model\ParametroGeral;
    use Model\RodapeFixo;
    use Model\VeiculoImagem;
    use Parvus\Input;
    use Parvus\Redirect;

    class Veiculo extends Base
	{

		public final function actionGetVeiculo ()
		{

		    unset($_SESSION['filtro']);

		    $veiculo = \Model\Veiculo::where('alias', Input::get('alias'))->first();

		    $veiculoImagem = VeiculoImagem::where('veiculo_id', $veiculo->id)->get();




            $localizacao = $this->buscarFilial($veiculo->filial_apelido);


		    $this->pagina = 'Estoque';

		    $this->sub_pagina = substr($veiculo->nome,0,-9);

            //Ordenar o array de opcionais
            $arrDados = explode("\n", $veiculo->opcional);
            sort($arrDados);
            $veiculo->opcional = $arrDados;

            $http = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
            $host = $_SERVER[HTTP_HOST];
		    $url = $http .'://'. $host . '/veiculo/' . $veiculo->alias;
            $titulo =  $veiculo->nome;
            $descricao = $veiculo->nome;
            $imagem = $http .'://'. $host . '/arquivo/' . $this->clienteId . '/veiculo/' . $veiculoImagem[0]->veiculo_id . '/' . $veiculoImagem[0]->nome;


            //contatos do whatsapp

            $modelRodape = RodapeFixo::where('id', 1)->first();
            $arrTelefones = [];
            $indice = 0;
            foreach (range(1, 4) as $x) {
                if ($modelRodape->{'telefone_tipo_' . $x} == 'WhatsApp') {
                    $arrTelefones[$indice]['telefone'] = '55'.str_replace(array('(',')','-',' '),array(''), $modelRodape->{'telefone_numero_' . $x});
                    $arrTelefones[$indice]['nome'] = $modelRodape->{'telefone_frase_' . $x};
                    $indice ++;
                }
            }

            $total = count($arrTelefones) - 1 ;
            $numero_sorteado = $arrTelefones[rand(0,$total)];




            $configuracao_geral = ParametroGeral::where('cliente_id', $this->clienteId)->first();




		    $this->view('estoque/veiculo', [
		        'localizacao'=>$localizacao,
		        'tipo_formulario'=>$configuracao_geral->tipo_formulario,
                'modelos'=>$configuracao_geral->modelos,
		        'numero_whatsapp_sorteado'=>$numero_sorteado,
		        'veiculo'       => $veiculo,
                'veiculoImagem' => $veiculoImagem,
                'url'=>$url,
                'titulo'=>$titulo,
                'imagem'=>$imagem,
                'descricao'=>$descricao,
                'exibir_localizacao'=>$configuracao_geral->exibe_localizacao
            ]);





		}

		public final function actionPostProposta()
        {

            $arrForm['interesse_nome'] = Input::get('interesse_nome');
            $arrForm['interesse_email'] = Input::get('interesse_email');
            $arrForm['interesse_telefone'] = Input::get('interesse_telefone');
            $arrForm['interesse_mensagem'] = Input::get('interesse_mensagem');
            $_SESSION['form'] = $arrForm;



            $existeRecaptcha = (isset($_POST['g-recaptcha-response']));

            if ($existeRecaptcha) {
                $dados = Input::get('g-recaptcha-response');
                if (empty($dados)) {
                    $_SESSION['msg'] = 'Captcha não preenchido';
                    Redirect::back();
                }
            }








            $veiculo = \Model\Veiculo::where('id', Input::get('id'))->first();

            $html = "<b>Nome: </b>".Input::get('interesse_nome')."<br />";
            $html.= "<b>E-mail: </b>".Input::get('interesse_email')."<br />";
            $html.= "<b>Telefone: </b>".Input::get('interesse_telefone')."<br />";
            $html.= "<b>Mensagem: <br /></b>".nl2br(Input::get('interesse_mensagem'))."<br />";

            $cliente = Cliente::where('id', $this->clienteId)->first();
            $geral   = ParametroGeral::where('cliente_id', $this->clienteId)->first();

            $email = \Lib\Email::envia($html,'Proposta - '.$veiculo->nome, $cliente, 'proposta');

            $model_script = Analytics::where('id', 1)->first();

            if($model_script->script_proposta)
            {

                $_SESSION['proposta'] = 1;

            }

            unset( $_SESSION['form']);
            $_SESSION['msg'] = 'Proposta enviada com sucesso!';

            Redirect::to('veiculo/'.$veiculo->alias);


        }

        public function buscarFilial($filial_apelido){


            $configuracao_geral = ParametroGeral::first();


            if($configuracao_geral->exibe_localizacao=='Sim'){

                $filial_encontrada = $this->procurarPorChaveFilial($filial_apelido);
                if(empty($filial_encontrada)){
                    return $filial_apelido;
                }
                $filial_apelido = $filial_encontrada;

                return $filial_apelido;
            }

            return null;


        }

        public function procurarPorChaveFilial($chave_filial){


            $contatoEncontrado = ContatoFilial::where('chave',$chave_filial)->first();

            if(empty($contatoEncontrado)){
                return;
            }

            if($contatoEncontrado->custom_exibicao=='Sim'){
                return $contatoEncontrado->descricao_exibicao;
            }


            return $contatoEncontrado->nome . " - " . $contatoEncontrado->telefone_valor_1;

        }

	}