<?php
	namespace Controller;

	use Base\Mensagem;
    use Base\W2O;
    use Lib\Date;
    use Model\Banner;
    use Model\Noticia;
    use Model\ParametroGeral;
    use Model\Veiculo;
    use Parvus\Input;
    use Parvus\Redirect;

    class Index extends Base
	{

		public final function actionGetIndex ()
		{

            unset($_SESSION['filtro']);

		    $this->pagina = 'Home';

            $geral = ParametroGeral::where('cliente_id', $this->clienteId)->first();

            if ( $geral->tema == 'Tema 1' )
            {
                $banner = array(
                    'width' => 1082,
                    'height' => 450
                );
            }
            elseif ( $geral->tema == 'Tema 2' )
            {
                $banner = array(
                    'width' => 2000,
                    'height' => 550
                );
            }
            else
            {
                $banner = array(
                    'width' => 2000,
                    'height' => 550
                );
            }

            if($geral->exibe_estoque_home == 'Sim')
            {

                $veiculo = \Model\Veiculo::where('cliente_id', $this->clienteId);

                $veiculo = $veiculo->orderBy('destaque', 'desc');

                 if($geral->ordem == 'Maior Preço Primeiro')
                 {

                     $veiculo = $veiculo->orderBy('valor','desc');

                 }
                 elseif($geral->ordem == 'Menor Preço Primeiro')
                 {

                     $veiculo = $veiculo->orderBy('valor','asc');

                 }
                 elseif($geral->ordem == 'Ordem Alfabética dos Modelos')
                 {

                     $veiculo = $veiculo->orderBy('nome','asc');

                 }

                $veiculo = $veiculo->get();

            }
            else
            {

                $veiculo = Veiculo::where('cliente_id', $this->clienteId)
                    ->limit($geral->quantidade_veiculo_home)
                    ->offset(0)
                    ->orderby('destaque', 'desc')
                    ->orderby('data', 'desc');

                $veiculo = $veiculo->get();

            }

            $noticia = Noticia::where('cliente_id', $this->clienteId)
                ->where('situacao', 'Ativo')
                ->orderBy('data','desc')
                ->limit(4)
                ->offset(0)
                ->get();

		    $this->view('index/index', [
		        'aBanner'       => Banner::where('cliente_id', '1')->orderBy('ordem', 'asc')->get(),
                'bannerTamanho' => $banner,
                'veiculo'       => $veiculo,
                'noticia'       => $noticia
            ]);

		}

	}