<?php

namespace Controller;

use Lib\Lib;
use Lib\Mascara;
use Model\Cliente;
use Model\ParametroGeral;
use Parvus\Input;
use Parvus\Redirect;
use Parvus\Date;
use Base\Mensagem;

class FichaCadastral extends Base
{

    public final function actionGetIndex()
    {

        $this->pagina = 'Ficha Cadastral';

        $enumeracao = new \Base\Enumeracao();

        if (isset($_SESSION['msg'])) {

            $mensagem = $_SESSION['msg'];

            unset( $_SESSION['msg']);

        } else {
            $mensagem = null;
        }



        $this->view('fichaCadastral/index', array(
            'aMensagem' => $mensagem,
            'aEnumeracao' => array(
                'estado' => $enumeracao->estado(),
                'sexo' => $enumeracao->exibeSexo(),
                'estadoCivil' => $enumeracao->exibeEstadoCivil(),
            )
        ));

    }

    public final function actionPostIndex()
    {

        $model = new \Model\FichaCadastral();


        $existeRecaptcha = (isset($_POST['g-recaptcha-response']));


        if ($existeRecaptcha) {
            $dados = Input::get('g-recaptcha-response');
            if (empty($dados)) {
                $_SESSION['msg'] = 'Captcha não preenchido';
                Redirect::back();
            }
        }

        $model->saveArray([
            'cliente_id' => $this->clienteId,
            'nome' => Input::get('nome'),
            'cpf' => Input::get('cpf'),
            'rg' => Input::get('rg'),
            'orgao_emissor_rg' => Input::get('orgao_emissor_rg'),
            'data_emissao_rg' => Date::save(Input::get('data_emissao_rg')),
            'uf_rg' => Input::get('uf_rg'),
            'telefone' => Input::get('telefone'),
            'celular' => Input::get('celular'),
            'email' => Input::get('email'),
            'naturalidade' => Input::get('naturalidade'),
            'data_nascimento' => Date::save(Input::get('data_nascimento')),
            'sexo' => Input::get('sexo'),
            'estado_civil' => Input::get('estado_civil'),
            'profissao' => Input::get('profissao'),
            'numero_dependente' => Input::get('numero_dependente'),
            'nome_pai' => Input::get('nome_pai'),
            'nome_mae' => Input::get('nome_mae'),
            'endereco' => Input::get('endereco_residencial'),
            'endereco_numero' => Input::get('endereco_numero'),
            'endereco_complemento' => Input::get('endereco_complemento'),
            'endereco_bairro' => Input::get('endereco_bairro'),
            'endereco_cep' => Input::get('endereco_cep'),
            'endereco_cidade' => Input::get('endereco_cidade'),
            'endereco_uf' => Input::get('endereco_uf'),
            'endereco_tipo_residencia' => Input::get('endereco_tipo_residencia'),
            'endereco_tempo_residencia' => Input::get('endereco_tempo_residencia'),
            'endereco_telefone' => Input::get('endereco_telefone'),
            'endereco_tipo_telefone' => Input::get('endereco_tipo_telefone'),
            'endereco_correspondencia' => Input::get('endereco_correspondencia'),
            'profissional_tipo_ocupacao' => Input::get('profissional_tipo_ocupacao'),
            'profissional_profissao' => Input::get('profissional_profissao'),
            'profissional_empresa' => Input::get('profissional_empresa'),
            'profissional_cnpj' => Input::get('profissional_cnpj'),
            'profissional_cargo_funcao' => Input::get('profissional_cargo_funcao'),
            'profissional_data_admissao' => Date::save(Input::get('profissional_data_admissao')),
            'profissional_telefone' => Input::get('profissional_telefone'),
            'profissional_endereco_comercial' => Input::get('profissional_endereco_comercial'),
            'profissional_endereco_numero' => Input::get('profissional_endereco_numero'),
            'profissional_endereco_bairro' => Input::get('profissional_endereco_bairro'),
            'profissional_endereco_cep' => Input::get('profissional_endereco_cep'),
            'profissional_endereco_cidade' => Input::get('profissional_endereco_cidade'),
            'profissional_endereco_uf' => Input::get('profissional_endereco_uf'),
            'profissional_salario' => Input::get('profissional_salario'),
            'profissional_fonte_renda' => Input::get('profissional_fonte_renda'),
            'profissional_origem' => Input::get('profissional_origem'),
            'profissional_renda_bruta' => Input::get('profissional_renda_bruta'),
            'profissional_mes_ano' => Input::get('profissional_mes_ano'),
            'referencia_pessoal_1' => Input::get('referencia_pessoal_1'),
            'referencia_telefone_1' => Input::get('referencia_telefone_1'),
            'referencia_pessoal_2' => Input::get('referencia_pessoal_2'),
            'referencia_telefone_2' => Input::get('referencia_telefone_2'),
            'referencia_banco_1' => Input::get('referencia_banco_1'),
            'referencia_agencia_1' => Input::get('referencia_agencia_1'),
            'referencia_conta_corrente_1' => Input::get('referencia_conta_corrente_1'),
            'referencia_gerente_1' => Input::get('referencia_gerente_1'),
            'referencia_banco_telefone_1' => Input::get('referencia_banco_telefone_1'),
            'referencia_banco_2' => Input::get('referencia_banco_2'),
            'referencia_agencia_2' => Input::get('referencia_agencia_2'),
            'referencia_conta_corrente_2' => Input::get('referencia_conta_corrente_2'),
            'referencia_gerente_2' => Input::get('referencia_gerente_2'),
            'referencia_banco_telefone_2' => Input::get('referencia_banco_telefone_2'),
            'marca' => Input::get('marca'),
            'modelo' => Input::get('modelo'),
            'ano' => Input::get('ano'),
            'combustivel' => Input::get('combustivel'),
            'valor_venda' => Input::get('valor_venda'),
            'numero_parcela' => Input::get('numero_parcela'),
            'valor_financiado' => Input::get('valor_financiado'),
            'conjuge_nome' => Input::get('conjuge_nome'),
            'conjuge_cpf' => Input::get('conjuge_cpf'),
            'conjuge_rg' => Input::get('conjuge_rg'),
            'conjuge_data_nascimento' => Date::save(Input::get('conjuge_data_nascimento')),
            'log_cadastro_data' => Date::now(),
        ]);


        $aDado = $_POST;





        $html = 'Ficha Cadastral enviada pelo site:<br /><br />';

        $html .= '<table width="100%" cellpadding="3" cellspacing="0" border="1">';

        $html .= '<tr style="display: none">';

        foreach (range(1, 12) as $x) {
            $html .= '<td width="8.33%">';
        }

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="12" style="background-color: #c7c7c7"><b>Dados Pessoais</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4"><b>Nome</b></td>';
        $html .= '<td colspan="2"><b>CPF</b></td>';
        $html .= '<td colspan="2"><b>RG</b></td>';
        $html .= '<td colspan="2"><b>Órgão Emissor</b></td>';
        $html .= '<td colspan="2"><b>Data Emissão</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4">' . $aDado['nome'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['cpf'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['rg'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['orgao_emissor_rg'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['data_emissao_rg'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>UF</b></td>';
        $html .= '<td colspan="2"><b>Telefone</b></td>';
        $html .= '<td colspan="2"><b>Celular</b></td>';
        $html .= '<td colspan="4"><b>E-mail</b></td>';
        $html .= '<td colspan="2"><b>Naturalidade</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['uf_rg'] . '</td>';
        $html .= '<td colspan="2">' . Mascara::telefone($aDado['telefone']) . '</td>';
        $html .= '<td colspan="2">' . Mascara::telefone($aDado['celular']) . '</td>';
        $html .= '<td colspan="4">' . $aDado['email'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['naturalidade'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Data Nascimento</b></td>';
        $html .= '<td colspan="2"><b>Sexo</b></td>';
        $html .= '<td colspan="2"><b>Estado Civil</b></td>';
        $html .= '<td colspan="4"><b>Profissão</b></td>';
        $html .= '<td colspan="2"><b>Nº Dependentes</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['data_nascimento'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['sexo'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['estado_civil'] . '</td>';
        $html .= '<td colspan="4">' . $aDado['profissao'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['numero_dependente'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4"><b>Nome do Pai</b></td>';
        $html .= '<td colspan="8"><b>Nome da Mãe</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4">' . Input::get('nome_pai') . '</td>';
        $html .= '<td colspan="8">' . Input::get('nome_mae') . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="12" style="background-color: #c7c7c7"><b>Dados do Cônjuge</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="6"><b>Nome</b></td>';
        $html .= '<td colspan="2"><b>CPF</b></td>';
        $html .= '<td colspan="2"><b>RG</b></td>';
        $html .= '<td colspan="2"><b>Data de Nascimento</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="6">' . $aDado['conjuge_nome'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['conjuge_cpf'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['conjuge_rg'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['conjuge_data_nascimento'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="12" style="background-color: #c7c7c7"><b>Endereço</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="10"><b>Endereço Residencial</b></td>';
        $html .= '<td colspan="2"><b>Número</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="10">' . $aDado['endereco_residencial'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['endereco_numero'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="8"><b>Complemento</b></td>';
        $html .= '<td colspan="4"><b>Bairro</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="8">' . $aDado['endereco_complemento'] . '</td>';
        $html .= '<td colspan="4">' . $aDado['endereco_bairro'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>CEP</b></td>';
        $html .= '<td colspan="4"><b>Cidade</b></td>';
        $html .= '<td colspan="2"><b>UF</b></td>';
        $html .= '<td colspan="2"><b>Tipo Residência</b></td>';
        $html .= '<td colspan="2"><b>Tempo Residência</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['endereco_cep'] . '</td>';
        $html .= '<td colspan="4">' . $aDado['endereco_cidade'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['endereco_uf'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['endereco_tipo_residencia'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['endereco_tempo_residencia'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Telefone</b></td>';
        $html .= '<td colspan="2"><b>Tipo Telefone</b></td>';
        $html .= '<td colspan="8"><b>Endereço p/ Corresp.</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . Mascara::telefone($aDado['endereco_telefone']) . '</td>';
        $html .= '<td colspan="2">' . $aDado['endereco_tipo_telefone'] . '</td>';
        $html .= '<td colspan="8">' . $aDado['endereco_correspondencia'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="12" style="background-color: #c7c7c7"><b>Dados Profissionais</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3"><b>Tipo de Ocupação</b></td>';
        $html .= '<td colspan="3"><b>Profissão</b></td>';
        $html .= '<td colspan="4"><b>Empresa</b></td>';
        $html .= '<td colspan="2"><b>CNPJ</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3">' . $aDado['profissional_tipo_ocupacao'] . '</td>';
        $html .= '<td colspan="3">' . $aDado['profissional_profissao'] . '</td>';
        $html .= '<td colspan="4">' . $aDado['profissional_empresa'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['profissional_cnpj'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3"><b>Cargo ou Função</b></td>';
        $html .= '<td colspan="2"><b>Data de Admissão</b></td>';
        $html .= '<td colspan="2"><b>Telefone</b></td>';
        $html .= '<td colspan="5"><b>Endereço Comercial</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3">' . $aDado['profissional_cargo_funcao'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['profissional_data_admissao'] . '</td>';
        $html .= '<td colspan="2">' . Mascara::telefone($aDado['profissional_telefone']) . '</td>';
        $html .= '<td colspan="5">' . $aDado['profissional_endereco_comercial'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Número</b></td>';
        $html .= '<td colspan="3"><b>Bairro</b></td>';
        $html .= '<td colspan="2"><b>CEP</b></td>';
        $html .= '<td colspan="3"><b>Cidade</b></td>';
        $html .= '<td colspan="2"><b>UF</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['profissional_endereco_numero'] . '</td>';
        $html .= '<td colspan="3">' . $aDado['profissional_endereco_bairro'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['profissional_endereco_cep'] . '</td>';
        $html .= '<td colspan="3">' . $aDado['profissional_endereco_cidade'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['profissional_endereco_uf'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3"><b>Salário</b></td>';
        $html .= '<td colspan="6"><b>Outras fontes de renda</b></td>';
        $html .= '<td colspan="3"><b>Origem</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3">' . $aDado['profissional_salario'] . '</td>';
        $html .= '<td colspan="6">' . $aDado['profissional_fonte_renda'] . '</td>';
        $html .= '<td colspan="3">' . $aDado['profissional_origem'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3"><b>Renda Bruta</b></td>';
        $html .= '<td colspan="9"><b>Mês/Ano</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3">' . $aDado['profissional_renda_bruta'] . '</td>';
        $html .= '<td colspan="9">' . $aDado['profissional_mes_ano'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="12" style="background-color: #c7c7c7"><b>Referências</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4"><b>Pessoal</b></td>';
        $html .= '<td colspan="2"><b>Telefone</b></td>';
        $html .= '<td colspan="4"><b>Pessoal</b></td>';
        $html .= '<td colspan="2"><b>Telefone</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4">' . $aDado['referencia_pessoal_1'] . '</td>';
        $html .= '<td colspan="2">' . Mascara::telefone($aDado['referencia_telefone_1']) . '</td>';
        $html .= '<td colspan="4">' . $aDado['referencia_pessoal_2'] . '</td>';
        $html .= '<td colspan="2">' . Mascara::telefone($aDado['referencia_telefone_2']) . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3"><b>Banco</b></td>';
        $html .= '<td colspan="2"><b>Agência</b></td>';
        $html .= '<td colspan="2"><b>Conta Corrente</b></td>';
        $html .= '<td colspan="3"><b>Gerente</b></td>';
        $html .= '<td colspan="2"><b>Telefone</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3">' . $aDado['referencia_banco_1'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['referencia_agencia_1'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['referencia_conta_corrente_1'] . '</td>';
        $html .= '<td colspan="3">' . $aDado['referencia_gerente_1'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['referencia_banco_telefone_1'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3"><b>Banco</b></td>';
        $html .= '<td colspan="2"><b>Agência</b></td>';
        $html .= '<td colspan="2"><b>Conta Corrente</b></td>';
        $html .= '<td colspan="3"><b>Gerente</b></td>';
        $html .= '<td colspan="2"><b>Telefone</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="3">' . $aDado['referencia_banco_2'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['referencia_agencia_2'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['referencia_conta_corrente_2'] . '</td>';
        $html .= '<td colspan="3">' . $aDado['referencia_gerente_2'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['referencia_banco_telefone_2'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="12" style="background-color: #c7c7c7"><b>Descrição do Bem a ser Financiado</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4"><b>Marca</b></td>';
        $html .= '<td colspan="4"><b>Modelo</b></td>';
        $html .= '<td colspan="2"><b>Ano</b></td>';
        $html .= '<td colspan="2"><b>Combustível</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="4">' . $aDado['marca'] . '</td>';
        $html .= '<td colspan="4">' . $aDado['modelo'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['ano'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['combustivel'] . '</td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="5"><b>Valor de Venda</b></td>';
        $html .= '<td colspan="5"><b>Valor Financiado</b></td>';
        $html .= '<td colspan="2"><b>Nº de Parcelas</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="5">' . $aDado['valor_venda'] . '</td>';
        $html .= '<td colspan="5">' . $aDado['valor_financiado'] . '</td>';
        $html .= '<td colspan="2">' . $aDado['numero_parcela'] . '</td>';

        $html .= '</tr>';

        $html .= '</table>';

        $email = \Lib\Email::envia(
            $html,
            'Ficha Cadastral - ' . Input::get('nome'),
            Cliente::where('id', $this->clienteId)->first(),
            'ficha_cadastral'
        );


        $_SESSION['msg'] = 'Ficha Cadastral enviada com sucesso!';

        Redirect::back();

    }

}