<?php

namespace Controller;

use Base\Decimal;
use Base\Mensagem;
use Base\W2O;
use Lib\Date;
use Lib\Filtro;
use Model\Banner;
use Model\Noticia;
use Model\ParametroGeral;
use Model\Veiculo;
use Parvus\DB;
use Parvus\Input;
use Parvus\Redirect;

class Estoque extends Base
{

    public final function actionGetIndex()
    {

        $this->pagina = 'Estoque';

        /** Filtro */
        if (Input::get('filtro') && Input::get('codigo')) {
            unset($_SESSION['init']);
            $_SESSION['filtro'][Input::get('filtro')][Input::get('codigo')] = Input::get('codigo');

        }

        //unset($_SESSION['filtro']);
        //unset($_SESSION['ano_de']);
        //unset($_SESSION['ano_ate']);
        //unset($_SESSION['faixa_de']);
        //unset($_SESSION['faixa_ate']);
        /*pre_print_r($_SESSION);
        die;*/



        foreach (array('Destaque', 'Oferta', 'Repasse', 'Mais Recentes') as $item) {

            if ($_SESSION['filtro']['outro'][$item] == NULL) {

                $optionsSideBar['aOutro'][$item] = $item;

            }

        }

        //Gerar filtro
        $filtro = $this->GerarFiltro();


        /**  Estoque */
        $veiculo = \Model\Veiculo::where('cliente_id', $this->clienteId);
        $veiculo = Filtro::veiculo($veiculo, $filtro);


        $filtroAtivo = [];


        //Filtro fixos
        if(isset($_SESSION['filtro']['pesquisa'])){
            $filtroAtivo['pesquisa'] = $_SESSION['filtro']['pesquisa'];
        }

        if (isset($filtro['ano_de'])) {
            $filtroAtivo['ano_de'] = $filtro['ano_de'];
        }
        if (isset($filtro['ano_ate'])) {
            $filtroAtivo['ano_ate'] = $filtro['ano_ate'];
        }

        if (isset($filtro['faixa_de'])) {
            $filtroAtivo['faixa_de'] = $filtro['faixa_de'];
        }

        if (isset($filtro['faixa_ate'])) {
            $filtroAtivo['faixa_ate'] = $filtro['faixa_ate'];
        }

        if (isset($filtro['outros'])) {
            $filtroAtivo['outros'] = $filtro['outros'];
        }
        if (isset($filtro['combustivel'])) {
            $filtroAtivo['combustivel'] = $filtro['combustivel'];
        }


        foreach ($veiculo->get() as $item) {

            $optionsSideBar['aMarca'][$item->veiculoMarca->id] = $item->veiculoMarca->nome;
            $optionsSideBar['aModelo'][$item->veiculoMarcaModelo->id] = $item->veiculoMarcaModelo->nome;
            $optionsSideBar['aAno'][$item->fabricacao] = $item->fabricacao;


            if (isset($filtro['marca'])) {

                if ($filtro['marca'] == $item->veiculoMarca->id) {
                    $filtroAtivo['marca']['id'] = $item->veiculoMarca->id;
                    $filtroAtivo['marca']['descricao'] = $item->veiculoMarca->nome;
                }

            }



            if (isset($filtro['modelo'])) {

                if ($filtro['modelo'] == $item->veiculoMarcaModelo->id) {
                    $filtroAtivo['modelo']['id'] = $item->veiculoMarcaModelo->id;
                    $filtroAtivo['modelo']['descricao'] = $item->veiculoMarcaModelo->nome;
                }

            }
            foreach (explode(',', $item->combustivel) as $combustivel) {
                $optionsSideBar['aCombustivel'][$combustivel] = $combustivel;
            }




        }




        asort($optionsSideBar['aModelo']);
        asort($optionsSideBar['aMarca']);
        arsort($optionsSideBar['aAno']);
        arsort($optionsSideBar['aCombustivel']);
        asort($optionsSideBar['aOutro']);

        $geral = ParametroGeral::where('cliente_id', $this->clienteId)->first();

        if ($geral->tema == 'Tema 2') {

            $input_class = 'b-xs-6';
            $button_class = 'b-xs-12';
        } else {
            $input_class = 'b-xs-5';
            $button_class = 'b-xs-2';
        }

        /**
         * Lista de veiculos
         */
        $veiculo = \Model\Veiculo::where('cliente_id', $this->clienteId)
            ->limit($geral->filtro_exibe_quantidade_veiculo)
            ->offset($_SESSION['init'] ? $_SESSION['init'] : 0);


        $veiculo = Filtro::veiculo($veiculo, $filtro);

        /**
         * Ordenação
         */
        if ($_SESSION['filtro']['outro']['Mais Recentes']) {

            $veiculo = $veiculo->orderBy('data', 'desc');

        }

        if ($geral->ordem == 'Maior Preço Primeiro') {

            $veiculo = $veiculo->orderBy('valor', 'desc');

        } elseif ($geral->ordem == 'Menor Preço Primeiro') {

            $veiculo = $veiculo->orderBy('valor', 'asc');

        } else {
            $veiculo = $veiculo->orderBy('nome', 'asc');

        }

        $veiculo = $veiculo->select([
            DB::raw('SQL_CALC_FOUND_ROWS * ')
        ])->get();

        $_SESSION['totalRegistro'] = DB::select('SELECT FOUND_ROWS() as quantidade')[0]['quantidade'];


        $this->view('estoque/index', [
            'veiculo' => $veiculo,
            'aFiltro' => $optionsSideBar,
            'inputClass' => $input_class,
            'buttonClass' => $button_class,
            'aFiltradoPor' => $filtroAtivo,
            'quantidadePagina' => $geral->filtro_exibe_quantidade_veiculo
        ]);

    }

    public final function actionGetRemoveFiltro()
    {

        if (Input::get('filtro') == 'all') {
            unset($_SESSION['filtro']);
        }


        if (Input::get('filtro') == 'pesquisa') {
            unset($_SESSION['filtro']['pesquisa']);
        } else {


            if (Input::get('filtro') == 'faixa_ate') {
                unset($_SESSION['filtro']['faixa_ate']);
            }

            if (Input::get('filtro') == 'faixa_de') {
                unset($_SESSION['filtro']['faixa_de']);
            }


            if (Input::get('filtro') == 'ano_de') {
                unset($_SESSION['filtro']['ano_de']);
                unset($_SESSION['filtro']['ano_ate']);
            } else {
                unset($_SESSION['filtro'][Input::get('filtro')][Input::get('codigo')]);
            }


        }


        if (sizeof($_SESSION['filtro']['faixa_de']) + sizeof($_SESSION['filtro']['faixa_ate']) + sizeof($_SESSION['filtro']['modelo']) + sizeof($_SESSION['filtro']['outro']) + sizeof($_SESSION['filtro']['marca']) + sizeof($_SESSION['filtro']['ano']) + sizeof($_SESSION['filtro']['combustivel']) == 0 && sizeof($_SESSION['filtro']['pequisa']) == NULL) {

            unset($_SESSION['filtro']);

        }

        Redirect::to('estoque');

    }

    public final function actionPostIndex()
    {


        $_SESSION['filtro']['faixa_de'] = Input::get('faixa_de');
        $_SESSION['filtro']['faixa_ate'] = Input::get('faixa_ate');

        $_SESSION['filtro']['ano_de'] = Input::get('ano_de');
        $_SESSION['filtro']['ano_ate'] = Input::get('ano_ate');


        //print_r($_SESSION);
        //die;
        Redirect::to('estoque');

    }

    public final function actionPostPesquisa()
    {

        unset($_SESSION['init']);

        if (Input::get('palavra-chave')) {

            $_SESSION['filtro']['pesquisa'] = Input::get('palavra-chave');

        } else {

            unset($_SESSION['filtro']['pesquisa']);

        }

        Redirect::to('estoque');

    }

    private function verificarSeMarcaFoiSelecionada($marca, $item)
    {

        if (empty($marca)) {
            return $item->veiculoMarcaModelo->nome;
        }


        if ($marca[$item->veiculoMarcaModelo->id] == $item->veiculo_marca_id) {
            return $item->veiculoMarcaModelo->nome;
        }


    }

    private function GerarFiltro()
    {

        $marca = Input::get('marca');
        $modelo = Input::get('modelo');
        $faixa_de = Input::get('faixa_de');
        $faixa_ate = Input::get('faixa_ate');

        $ano_de = Input::get('ano_de');
        $ano_ate = Input::get('ano_ate');

        $outros = Input::get('outros');

        $combustivel = Input::get('combustivel');

        if (!empty($outros)) {
            $filtro['outros'] = $outros;
        }
        if (!empty($marca)) {
            $filtro['marca'] = $marca;

        }
        if (!empty($modelo)) {
            $filtro['modelo'] = $modelo;
        }
        if (!empty($combustivel)) {
            $filtro['combustivel'] = $combustivel;
        }

        if(!empty($ano_de)||!empty($ano_ate)){

            $ano_inicio = $ano_de;
            $ano_final = $ano_ate;

            if($ano_inicio > $ano_final){
                $ano_final = $ano_inicio;
            }

            if($ano_final < $ano_inicio){
                $ano_final = $ano_inicio;
            }

            $filtro['ano']['de'] = $ano_inicio;
            $filtro['ano']['ate'] = $ano_final;


            $filtro['ano_de'] = $ano_inicio;
            $filtro['ano_ate'] = $ano_final;

        }



        if(!empty($faixa_de)||!empty($faixa_ate)){

            $faixa_inicio = $faixa_de;
            $faixa_final = $faixa_ate;

            if($faixa_inicio > $faixa_final){
                $faixa_final = $faixa_inicio;
            }

            if($faixa_final < $faixa_inicio){
                $faixa_final = $faixa_inicio;
            }

            $filtro['preco']['de'] = $faixa_inicio;
            $filtro['preco']['ate'] = $faixa_final;


            $filtro['faixa_de'] = $faixa_inicio;
            $filtro['faixa_ate'] = $faixa_final;

        }



        return $filtro;


    }


}