<?php

namespace Controller;

use Model\Cliente;
use Model\ContatoFilial;
use Model\Google;
use Model\Link;
use Model\Modal;
use Model\Pagina;
use Model\PaginaCliente;
use Model\ParametroGeral;
use Model\RedeSocial;
use Model\Rodape;
use Model\RodapeFixo;
use Model\Seo;
use Model\Youtube;
use Parvus\DB;
use Parvus\Redirect;

class Base
{

    public $clienteId = '1';
    public $pagina = '', $sub_pagina = '';

    /**
     * @param $prView
     * @param array $prArray
     * @return mixed
     */
    public final function view($prView, $prArray = array())
    {

        /**
         * Padrão
         */
        $cliente = Cliente::where('id', $this->clienteId)->first();

        $configuracao_geral = ParametroGeral::where('cliente_id', $this->clienteId)->first();



        $prArray['versao'] = $configuracao_geral->versao;
        $prArray['recaptcha'] = $configuracao_geral->recaptcha;
        $prArray['cliente'] = $cliente;
        $prArray['geral'] = $configuracao_geral;
        $prArray['google'] = \Model\Analytics::where('cliente_id', $this->clienteId)->first();
        $prArray['aRedeSocial'] = RedeSocial::where('cliente_id', $this->clienteId)->first();
        $prArray['rodapeFixo'] = RodapeFixo::where('id', 1)->first();
        $prArray['modal'] = Modal::where('id', 1)->first();
        $tabSeo = Seo::where('id', 1)->first();
        $prArray['seo'] = $tabSeo->palavra_chave;


        $modelRodape = RodapeFixo::where('id', 1)->first();
        $verSeTemNumeroWhatsapp = false;


        foreach (range(1, 4) as $x) {

            if ($modelRodape->{'telefone_tipo_' . $x} == 'WhatsApp') {
                $verSeTemNumeroWhatsapp = true;
            }


            if ($modelRodape->{'telefone_numero_' . $x}) {

                $prArray['aRodapeId'][] = $x;

            }

        }


        $prArray['rodapeTemWhastapp'] = $verSeTemNumeroWhatsapp;
        $prArray['rodapeFixoSize'] = sizeof($prArray['aRodapeId']);

        /**
         * Pagina
         */
        $prArray['temNoticia'] = '1';


        $prArray['aPaginaHome'] = $configuracao_geral['nome_pagina_home'];
        foreach (Pagina::get() as $posicao => $item) {

            $model = PaginaCliente::where('pagina_id', $item->id)
                ->where('cliente_id', '1')
                ->first();

            $link = str_replace([' ', 'í'], ['-', 'i'], strtolower($item->nome));


            $prArray['aPagina'][] = array(
                'nome' => $item->nome,
                'nome-exibe' => $model->nome ? $model->nome : $item->nome,
                'link' => $link,
                'exibe' => ($model->exibe == 'Sim' ? 'Sim' : 'Não'),
                'new_guide' => false,
            );

            if ($item->nome == 'Notícias' && $model->exibe != 'Sim') {

                $prArray['temNoticia'] = '2';

            }

            if ($this->pagina == $item->nome) {

                $pagina_exibe = $model->nome ? $model->nome : $item->nome;

            }

        }


        foreach (Link::get() as $posicao => $item) {

            $prArray['aPagina'][] = array(
                'nome' => $item->titulo,
                'nome-exibe' => $item->titulo,
                'link' => $item->url,
                'exibe' => 'Sim',
                'new_guide' => true,
            );


        }


        $prArray['geral']->tema = strtolower(str_replace(' ', '_', $prArray['geral']->tema));

        $prArray['pagina'] = $this->pagina;

        $prArray['pagina_exibe'] = $pagina_exibe;
        $prArray['sub_pagina'] = $this->sub_pagina;

        $prArray['contato'] = ContatoFilial::orderBy(DB::raw('FIELD(tipo, "Matriz", "Filial")'))->get();

        $prArray['matriz'] = ContatoFilial::where('tipo', 'Matriz')->first();


        $prArray['css'] = \Lib\Cor::setCor($configuracao_geral->tema, $cliente->cor_primaria, $cliente->cor_secundaria, $configuracao_geral->tem_fundo_preco_estoque);

        $prArray['youtube'] = Youtube::where('id', 1)->first();

        $prArray['google360'] = Google::where('id', 1)->first();


        $arrFliaisExibirTopo = \Model\ContatoFilial::where('exibir_topo','sim')->first();
        $enderecoTopo = null;
        if(!empty($arrFliaisExibirTopo)){


            if(empty($arrFliaisExibirTopo->descricao_endereco)){
                $enderecoTopo =  $arrFliaisExibirTopo->endereco_rua . ' ' . $arrFliaisExibirTopo->endereco_numero . ' - ' . $arrFliaisExibirTopo->endereco_bairro . ' - ' . $arrFliaisExibirTopo->endereco_cidade . ' ' .$arrFliaisExibirTopo->endereco_uf;
            }else{
                $enderecoTopo = $arrFliaisExibirTopo->descricao_endereco;
            }


        }

        $prArray['endereco_topo'] = $enderecoTopo;



        $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

        $host = $_SERVER['HTTP_HOST'];
        $url = $protocolo . $host;

        $new_url = $cliente['url'];
        if (!empty($new_url)) {
            $url = $new_url;
        }


        $prArray['url_whatsapp'] = $this->getURLWhatapp();
        $prArray['url'] = $url;

        $view = new \Parvus\View();

        $html = $view->render('frontend/' . $prView, $prArray);

        exit($html);

    }

    public function getURLWhatapp(){

        $iphone = strpos($_SERVER['HTTP_USER_AGENT'], "iPhone");
        $android = strpos($_SERVER['HTTP_USER_AGENT'], "Android");
        $palmpre = strpos($_SERVER['HTTP_USER_AGENT'], "webOS");
        $berry = strpos($_SERVER['HTTP_USER_AGENT'], "BlackBerry");
        $ipod = strpos($_SERVER['HTTP_USER_AGENT'], "iPod");


        // check if is a mobile
        if ($iphone || $android || $palmpre || $ipod || $berry == true) {
            return 'https://api.whatsapp.com/send';
        }else {
            return 'https://web.whatsapp.com/send';
        }

    }

    public function actionredirect()
    {

        $telefone = $_GET['n'];


        if (empty($telefone)) {

            Redirect::to('/');
        }


        $telefone = '55' . $telefone;
        $mensagem = 'Olá, acessei seu site ' . $_SERVER['HTTP_HOST'] . ' e gostaria de algumas informações';

        $item = \Model\RodapeFixo::where('id', 1)->first();

        $personal = $item->frase_whatsapp;
        if(!empty($personal)){
            $mensagem = $personal;
        };



        // Fix Api Whatsapp on Desktops
        // Dev: Jean Livino
        $iphone = strpos($_SERVER['HTTP_USER_AGENT'], "iPhone");
        $android = strpos($_SERVER['HTTP_USER_AGENT'], "Android");
        $palmpre = strpos($_SERVER['HTTP_USER_AGENT'], "webOS");
        $berry = strpos($_SERVER['HTTP_USER_AGENT'], "BlackBerry");
        $ipod = strpos($_SERVER['HTTP_USER_AGENT'], "iPod");


        // check if is a mobile
        if ($iphone || $android || $palmpre || $ipod || $berry == true) {
            header('Location: https://api.whatsapp.com/send?phone=' . $telefone . '&text=' . $mensagem . '');
            //OR
            //echo "<script>window.location='https://api.whatsapp.com/send?phone='.$telefone.'&text='.$mensagem.''</script>";
        } // all others
        else {
            header('Location: https://web.whatsapp.com/send?phone=' . $telefone . '&text=' . $mensagem . '');
            //OR
            //echo "<script>window.location='https://web.whatsapp.com/send?phone='.$telefone.'&text='.$mensagem.''</script>";
        }
    }
}
