<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class Youtube extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Youtube';

            $item = \Model\Youtube::where('id', 1)->first();

            $enumeracao = new Enumeracao();

            $this->view('configuracao/youtube/form', array(
                'item'        => $item,
                'aEnumeracao' => array(
                    'exibe'    => $enumeracao->simNao($item->exibe),
                )
            ));

        }

        public final function actionPostForm()
        {

            $model = \Model\Youtube::where('id', '1')
                ->first();

            if($model->id == null)
            {

                $model = new \Model\Youtube();

            }

            $model->saveArray([
                'id'       => '1',
                'exibe'    => Input::get('exibe'),
                'canal'    => Input::get('canal'),
                'video_1'  => Input::get('video_1'),
                'video_2'  => Input::get('video_2'),
                'video_3'  => Input::get('video_3'),
            ]);

            Mensagem::sucesso('Informações do Youtube alteradas com sucesso!');
            Redirect::back();

        }

    }