<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class Telefone extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Telefones';

            $item = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $this->view('configuracao/telefone/form', array(
                'item'        => $item,
            ));

        }

        public final function actionPostForm()
        {

            $model = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $model->saveArray([
                'telefone_cabecalho' => Input::get('telefone_cabecalho'),
                'telefone_rodape'    => Input::get('telefone_rodape'),
            ]);

            Mensagem::sucesso('Telefones alterados com sucesso!');
            Redirect::back();

        }

    }