<?php

namespace Backend;

use Base\Enumeracao;
use Base\Mensagem;
use Base\Table;
use Parvus\Date;
use Parvus\Input;
use Parvus\Redirect;

class RedeSocial extends Base
{

    public final function actionGetIndex ()
    {

        $this->titulo = 'Redes Sociais';

        $table = new Table();

        $table->th('Link Facebook');
        $table->th('Link Twitter');
        $table->th('Link Instagram');
        $table->th('Link Youtube');
        $table->th('Link Google+');
        $table->acao();

        $item = \Model\RedeSocial::where('cliente_id', $this->usuario->cliente_id)->first();

        $table->td(array(
            $item->link_facebook,
            $item->link_twitter,
            $item->link_instagram,
            $item->link_youtube,
            $item->{'link_google+'},
            $table->button('Editar','backend/rede-social/form?id='.$item->id)
        ));

        $this->view('configuracao/redeSocial/index', array(
            'table'        => $table->html(),
            'item'  => $item
        ));

    }

    public final function actionGetDelete ()
    {

        $model = new \Model\RedeSocial();
        $model->delete(Input::get('id'));

        Mensagem::sucesso('Rede social excluída com sucesso!');

        Redirect::to('backend/redeSocial/index');

    }

    public final function actionPostForm ()
    {

        $aItem = array(
            'cliente_id'      => $this->usuario->cliente_id,
            'link_facebook'   => Input::get('link_facebook'),
            'link_instagram'  => Input::get('link_instagram'),
            'link_twitter'    => Input::get('link_twitter'),
            'link_youtube'    => Input::get('link_youtube'),
            'link_google+'    => Input::get('link_google+'),
        );

        /**
         * Se não foi inserido uma imagem, pega a que já está cadastrada
         */
        $model = \Model\RedeSocial::where('id', Input::get('id'))->first();

        if($model->id == null)
        {

            $model = new \Model\RedeSocial();

        }

        $model->saveArray($aItem);

        Mensagem::sucesso('Redes sociais salvas com sucesso!');

        Redirect::to('backend/redeSocial/index');

    }

    public final function actionGetForm ()
    {

        $this->titulo = 'Redes Sociais';

        $model = \Model\RedeSocial::where('id',Input::get('id'))->first();

        $aItem = array(
            'cliente_id'     => $this->usuario->cliente_id,
            'id'             => $model->id,
            'link_facebook'  => $model->link_facebook,
            'link_instagram' => $model->link_instagram,
            'link_twitter'   => $model->link_twitter,
            'link_youtube'   => $model->link_youtube,
            'link_google+'   => $model->{'link_google+'},
        );

        $this->view('configuracao/redeSocial/form', array(
            'item' => $aItem,
        ));

    }

}