<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Lib\Imagem;
    use Parvus\Input;
    use Parvus\Redirect;

    class Logo extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Logo';

            $model = \Model\Cliente::where('id',$this->usuario->cliente_id)->first();

            $model_parametro = \Model\ParametroGeral::where('id', '1')->first();

            switch ($model_parametro->tema)
            {

                case 'Tema 1' : $aTamanho = ['altura' => 80, 'largura' => '254']; break;
                default       : $aTamanho = ['altura' => 70, 'largura' => '254']; break;

            }

            $this->view('configuracao/logo/form',array(
                'item'      => $model,
                'aTamanho'  => $aTamanho
            ));

        }

        public final function actionPostForm()
        {


            $model_parametro = \Model\ParametroGeral::where('id', '1')->first();

            switch ($model_parametro->tema)
            {

                case 'Tema 1' : $aTamanho = ['altura' => 80, 'largura' => '254']; break;
                default       : $aTamanho = ['altura' => 70, 'largura' => '254']; break;

            }


            if(Input::file('favicon') != null)
            {

                if(Input::file('favicon')['size']['megabyte'] <= '2')
                {

                    $imagem = new Imagem(Input::file('favicon'), null, 'arquivo/'.$this->usuario->cliente_id.'/logo', array('altura' => 25, 'largura' => 25));

                    $aItem['favicon'] = $imagem->resize();

                }
                else
                {

                    Mensagem::erro('O tamanho do arquivo deve ser de até 2 MB');

                    Redirect::back();
                    exit;

                }

            }

            if(Input::file('logo') != null)
            {

                if(Input::file('logo')['dimension']['width'] > $aTamanho['largura'] || Input::file('logo')['dimension']['height'] > $aTamanho['altura'])
                {

                    Mensagem::erro('Tamanho da imagem deve ser de  '.$aTamanho['altura'].'px altura X até '.$aTamanho['largura'].'px largura');

                    Redirect::back();

                }

                if(Input::file('logo')['size']['megabyte'] <= '2')
                {

                    $imagem = new Imagem(Input::file('logo'), null, 'arquivo/'.$this->usuario->cliente_id.'/logo', array('altura' => Input::file('logo')['dimension']['height'], 'largura' => Input::file('logo')['dimension']['width']));

                    $aItem['logo'] = $imagem->resize();

                }
                else
                {

                    Mensagem::erro('O tamanho do arquivo deve ser de até 2 MB');

                    Redirect::back();
                    exit;

                }

            }

            $model = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $model->saveArray($aItem);

            Mensagem::sucesso('Logo alterada com sucesso!');

            Redirect::back();

        }

    }