<?php

namespace Backend;

use Base\Mensagem;
use Base\W2O;
use Parvus\Input;
use Parvus\Redirect;
use PHPMailer\PHPMailer\Exception;

class Links extends Base
{
    protected $session = false;

    public final function actionGetForm()
    {

        session_destroy();

        $this->titulo = 'Links externos';


        $arrLinks = \Model\Link::get()->toArray();

        $this->view(
            'configuracao/links/form',
            array(
                'arrLinks' => $arrLinks
            )
        );

    }


    public final function actionPostForm()
    {
        $status = true;
        $url = Input::get('url');
        $titulo = Input::get('titulo');


        if (!filter_var($url, FILTER_VALIDATE_URL)) {
            $status = false;
            Mensagem::erro('Informe uma URL válida');
        }

        if (empty($titulo)) {
            $status = false;
            Mensagem::erro('Informe um titulo para esse link');
        }



        if ($status == false) {
           Redirect::to('backend/links/form');
        }



        $arrSave['titulo'] = $titulo;
        $arrSave['url'] =  $url;

        $model = new \Model\Link();
        $model->saveArray($arrSave);

        Mensagem::sucesso('Salvo com sucesso');
        Redirect::to('backend/links/form');

    }


    public final function actionGetDelete()
    {

        try{

            \Model\Link::where('id',Input::get('id'))->delete();

            Mensagem::sucesso('Excluido com sucesso!');
        }catch (\Exception $e){

            pre_print_r($e);
            Mensagem::erro($e->getMessage());
        }





        Redirect::to('backend/links/form');
    }
}