<?php

namespace Backend;

use Base\Enumeracao;
use Base\Mensagem;
use Base\Table;
use Parvus\Date;
use Parvus\Input;
use Parvus\Redirect;

class Foto extends Base
{

    public final function actionGetIndex ()
    {

        $this->titulo = 'Fotos';

        $table = new Table();

        $table->th('Descrição');
        $table->acao();

        foreach (\Model\Foto::get() as $aDados)
        {

            $table->td(array(
                $aDados->descricao,
                $table->button('Editar','backend/foto/form?id='.$aDados->id),
            ));

        }

        $this->view('foto/index',array(
            'table' => $table->html(),
        ));

    }

    public final function actionGetDelete ()
    {

        $model = new \Model\Foto();
        $model->delete(Input::get('id'));

        Mensagem::sucesso('Foto excluída com sucesso!');

        Redirect::to('backend/foto/index');

    }

    public final function actionPostForm ()
    {

        $model = \Model\Foto::where('id',Input::get('id'))->first();

        if ($model->id == NULL)
        {

            $model = new \Model\Foto();

        }

        /**
         * Passa os valores para o array
         */

        $aItem = array(
            'cliente_id' => $this->usuario->cliente_id,
            'descricao'  => Input::get('descricao'),
        );

        if(Input::file('icone') != NULL)
        {

            if(Input::file('icone')['size']['megabyte'] <= 2)
            {

                $icone = new \Lib\Imagem(Input::file('icone'), '', 'arquivo/'.$this->usuario->cliente_id.'/icone/', array('altura' => 250, 'largura' => 250));
                $aItem['icone'] = $icone->thumbnail();

            }
            else
            {

                Mensagem::erro('O tamanho do arquivo deve ser de até 2 MB');

                Redirect::back();
                exit;

            }


        }else{
            Mensagem::erro('O campo icone é obrigatório');
            Redirect::to('backend/foto/form');
        }



        /**
         * Se a foto não existe, insere uma nova
         */
        if(Input::file('foto') != NULL)
        {

            if(Input::file(('foto'))['size']['megabyte'] <= 2)
            {

                $foto = new \Lib\Imagem(Input::file('foto'), '', 'arquivo/'.$this->usuario->cliente_id.'/foto/');
                $aItem['foto'] = $foto->resize();

            }
            else
            {

                Mensagem::erro('O tamanho do arquivo deve ser de até 2 MB');

                Redirect::back();
                exit;

            }

        }else{
            Mensagem::erro('Selecione uma foto');
            Redirect::to('backend/foto/form');
        }

        $model->saveArray($aItem);

        Mensagem::sucesso('Foto inserida com sucesso!');

        Redirect::to('backend/foto/index');

    }

    public final function actionGetForm ()
    {

        $model =  \Model\Foto::where('id',Input::get('id'))->first();

        $aItem = array(
            'id'         => $model['id'],
            'cliente_id' => $this->usuario->cliente_id,
            'descricao'  => $model['descricao'],
            'icone'      => $model['icone'],
            'foto'       => $model['foto'],
        );

        $this->view('foto/form', array(
            'item' => $aItem
        ));


    }

}