<?php

    namespace Backend;

    use Base\Mensagem;
    use Model\EmpresaGaleria;
    use Parvus\Input;
    use Parvus\Redirect;

    class Empresa extends Base
    {

        public final function actionPostForm ()
        {

            $model = \Model\Empresa::where('cliente_id',$this->usuario->cliente_id)->first();

            /**
             * Passa os valores para o array
             */

            $aItem = array(
                'cliente_id' => $this->usuario->cliente_id,
                'descricao'  => Input::get('descricao'),
            );

            $aItem['descricao'] = str_replace(array('<p>','</p>'),'',$aItem['descricao']);

            /**
             * Se não estiver cadastrada, insere uma nova
             */
            if ($model == NULL)
            {

                $model = new \Model\Empresa();

            }

            if(Input::file('imagem'))
            {

                if(Input::file('imagem')['size']['megabyte'] <= 2)
                {

                    if(Input::file('imagem')['dimension']['width'] == 346 || Input::file('imagem')['dimension']['height'] == 346)
                    {

                        $imagem = new \Lib\Imagem(Input::file('imagem'), $this->usuario->cliente_id.'_'.$this->usuario->cliente->nome, 'arquivo/'.$this->usuario->cliente_id.'/empresa', array('altura' => 346, 'largura' => 346));
                        $aItem['imagem'] = $imagem->resize();

                    }
                    else
                    {

                        Mensagem::erro('Tamanho da imagem deve ser de  346px altura X até 346px largura');

                        Redirect::back();

                    }

                }
                else
                {

                    Mensagem::erro('O tamanho do arquivo deve ser de até 2 MB');

                    Redirect::back();

                }

            }

            $model->saveArray($aItem);

            /**
             * Imagens da galeria
             */
            if(Input::file('aImagem', true)[0])
            {

                foreach ( Input::file('aImagem', true) as $imagem)
                {

                    $name = date('His').'-'.$imagem['name'];

                    $imagem = new \Lib\Imagem($imagem, $name, 'arquivo/'.$this->usuario->cliente_id.'/empresa/galeria');
                    $name = $imagem->resize();

                    $galeria_model = new EmpresaGaleria();

                    $galeria_model->saveArray([
                        'imagem' => $name
                    ]);

                }

            }

            Mensagem::sucesso('Empresa inserida com sucesso!');
            Redirect::to('backend/empresa/form');

        }

        public final function actionGetForm ()
        {

            $this->view('empresa/form', [
                'item'           => \Model\Empresa::where('cliente_id', $this->usuario->cliente_id)->first(),
                'galeria_model'  => EmpresaGaleria::get()
            ]);

        }

        public final function actionPostDeleteImagem ()
        {

            $model = new \Model\EmpresaGaleria();
            $model->delete(Input::get('id'));

        }

    }