<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class Cor extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Cores';

            $item = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $this->view('configuracao/cor/form', array(
                'item'        => $item,
            ));

        }

        public final function actionPostForm()
        {


            $model = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $model->saveArray([
                'cor_primaria'      => Input::get('cor_primaria'),
                'cor_secundaria'    => Input::get('cor_secundaria'),
            ]);

            Mensagem::sucesso('Cores alteradas com sucesso!');
            Redirect::back();

        }

    }