<?php

namespace Backend;

use Base\Enumeracao;
use Base\Mensagem;
use Base\Table;
use Base\W2O;
use Parvus\Input;
use Parvus\Redirect;

class ContatoFilial extends Base
{

    public final function actionGetIndex()
    {


        $this->titulo = 'Contato';

        $table = new Table();

        $table->th('Nome');
        $table->th('Tipo');
        $table->acao();

        foreach (\Model\ContatoFilial::get() as $item) {

            $table->td(array(
                $item->nome,
                $item->tipo,
                $table->button('Editar', 'backend/contato-filial/form?id=' . $item->id)
            ));

        }

        $this->view('contato/index', array(
            'table' => $table->html(),
        ));

    }

    public final function actionGetForm()
    {


        $this->titulo = 'Contato';

        $item = \Model\ContatoFilial::where('id', Input::get('id'))->first();

        foreach (range(1, 3) as $x) {

            $aTelefone[$x] = array(
                'tipo' => $item->{'telefone_tipo_' . $x},
                'icone' => $item->{'telefone_icone_' . $x},
                'telefone' => $item->{'telefone_valor_' . $x},
            );

            $aHorario[$x] = array(
                'tipo' => $item->{'horario_tipo_' . $x},
                'horario' => $item->{'horario_valor_' . $x},
            );

        }


        $enumeracao = new Enumeracao();


        $this->view('contato/form', array(
            'item' => $item,
            'aTelefone' => $aTelefone,
            'aHorario' => $aHorario,
            'custom_exibicao' => $enumeracao->simNao($item->custom_exibicao),
            'aEnumeracao' => array(
                'exibir_topo' => $enumeracao->simNao($item->exibir_topo),
                'endereco_uf' => $enumeracao->estado($item->endereco_uf),
                'contato_tipo' => $enumeracao->contatoTipo($item->tipo),
                'telefone_icone_1' => $enumeracao->tipoTelefone($aTelefone[1]['icone']),
                'telefone_icone_2' => $enumeracao->tipoTelefone($aTelefone[2]['icone']),
                'telefone_icone_3' => $enumeracao->tipoTelefone($aTelefone[3]['icone']),
            )
        ));

    }

    public final function actionPostForm()
    {

        $model = \Model\ContatoFilial::where('id', Input::get('id'))->first();

        if ($model->id == NULL) {

            $model = new \Model\ContatoFilial();

        }

        $model->saveArray([
            'nome' => Input::get('nome'),
            'tipo' => Input::get('tipo'),
            'email' => Input::get('email'),

            'custom_exibicao' => Input::get('custom_exibicao'),
            'descricao_exibicao' => Input::get('descricao_exibicao'),
            'chave' => Input::get('chave'),

            'exibir_topo' => Input::get('exibir_topo'),

            'endereco_rua' => Input::get('endereco_rua'),
            'endereco_numero' => Input::get('endereco_numero'),
            'endereco_cidade' => Input::get('endereco_cidade'),
            'endereco_uf' => Input::get('endereco_uf'),
            'endereco_cep' => Input::get('endereco_cep'),
            'endereco_complemento' => Input::get('endereco_complemento'),
            'endereco_bairro' => Input::get('endereco_bairro'),

            'endereco_mapa' => Input::get('mapa_link'),

            'telefone_tipo_1' => Input::get('telefone_tipo_1'),
            'telefone_icone_1' => Input::get('telefone_icone_1'),
            'telefone_valor_1' => Input::get('telefone_valor_1'),

            'telefone_tipo_2' => Input::get('telefone_tipo_2'),
            'telefone_icone_2' => Input::get('telefone_icone_2'),
            'telefone_valor_2' => Input::get('telefone_valor_2'),

            'telefone_tipo_3' => Input::get('telefone_tipo_3'),
            'telefone_icone_3' => Input::get('telefone_icone_3'),
            'telefone_valor_3' => Input::get('telefone_valor_3'),

            'horario_tipo_1' => Input::get('horario_tipo_1'),
            'horario_valor_1' => Input::get('horario_valor_1'),

            'horario_tipo_2' => Input::get('horario_tipo_2'),
            'horario_valor_2' => Input::get('horario_valor_2'),

            'horario_tipo_3' => Input::get('horario_tipo_3'),
            'horario_valor_3' => Input::get('horario_valor_3'),

            'descricao_endereco' => Input::get('descricao_endereco'),
        ]);

        Mensagem::sucesso('Contato alterados com sucesso!');
        Redirect::to('backend/contato-filial/index');

    }

    public final function actionGetDelete()
    {

        $model = new \Model\ContatoFilial();
        $model->delete(Input::get('id'));

        Mensagem::sucesso('Contato excluída com sucesso!');

        Redirect::to('backend/contato-filial/index');

    }

}