<?php

    namespace Backend;

    use Parvus\Redirect;

    class Base
    {

        protected $session = true;
        protected $titulo, $sub_titulo, $usuario, $URL, $nome_class;

        public function __construct()
        {

            $this->usuario = unserialize($_SESSION['usuario']);

            /** Validate session */
            if ($this->session && !$this->usuario)
            {
                Redirect::to();
            }

            /** Define o nome da classe */
            $this->nome_class = explode('\\',get_class($this))[1];

            /** Se não tem título define, gera baseado no nome do controller */
            if ($this->titulo == NULL)
            {

                $this->titulo = $this->nome_class.'s';

            }

            /** Define a URL do controller */
            if ($this->URL == NULL)
            {

                $this->URL = mb_strtolower(\Parvus\Text::camelCase($this->nome_class),'UTF-8').'/';

            }

        }

        public final function view ($prView, $prArray = array())
        {

            $view = new \Parvus\View();

            $prArray['view']['usuario'] = $this->usuario;
            $prArray['view']['titulo']  = $this->titulo.($this->sub_titulo ? '<br /><small>'.$this->sub_titulo.'</small>' : NULL);
            $prArray['view']['URL']     = $this->URL;

            print($view->render('backend/'.$prView, $prArray));

        }

    }