<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\Table;
    use Parvus\Date;
    use Parvus\Input;
    use Parvus\Redirect;

    class Banner extends Base
    {

        public final function actionGetIndex ()
        {

            $this->titulo = 'Banners';

            $table = new Table();

            $table->th('Ordem');
            $table->th('Descrição');
            $table->acao();

            foreach (\Model\Banner::get() as $item)
            {

                $table->td(array(
                    $item->ordem,
                    $item->descricao,
                    $table->button('Editar','backend/banner/form?id='.$item->id)
                ));

            }

            $this->view('banner/index', array(
                'table' => $table->html(),
            ));

        }

        public final function actionGetDelete ()
        {

            $model = new \Model\Banner();
            $model->delete(Input::get('id'));

            Mensagem::sucesso('Banner excluído com sucesso!');

            Redirect::to('backend/banner/index');

        }

        public final function actionPostForm ()
        {

            $model = \Model\Banner::where('id',Input::get('id'))->first();


            $link = Input::get('link');

            $aItem = array(
                'cliente_id'  => $this->usuario->cliente_id,
                'ordem'       => Input::get('ordem'),
                'descricao'   => Input::get('descricao'),
                'link'        => $link
            );

            if ($model->id == NULL){

                $model = new \Model\Banner();

            }

            if($model->ordem != Input::get('ordem'))
            {

                $ordem = Input::get('ordem');

                foreach (\Model\Banner::where('ordem', '>=', Input::get('ordem'))->get() as $item)
                {

                    $item->saveArray([
                        'ordem' => $ordem+1
                    ]);

                    $ordem++;

                }
            }

            if(Input::file('imagem') != NULL)
            {

                $geral = \Model\ParametroGeral::where('cliente_id',$this->usuario->cliente_id)->first();

                if($geral->tema == 'Tema 1')
                {

                    $larguraMaxima = 1082;
                    $alturaMaxima = 487;
                    $mensagem = "Imagem com proporção mínima de 1082px largura por 487px altura.";

                }
                else if ($geral->tema == 'Tema 2')
                {

                    $larguraMaxima = 2000;
                    $alturaMaxima = 550;
                    $mensagem = "Imagem com proporção mínima de 2000px largura por 550px altura.";

                }
                else
                {

                    $larguraMaxima = 2000;
                    $alturaMaxima = 550;
                    $mensagem = "Imagem com proporção mínima de 2000px largura por 550 altura.";

                }

                if(Input::file('imagem')['dimension']['width'] < $larguraMaxima || Input::file('imagem')['dimension']['height'] < $alturaMaxima)
                {

                    Mensagem::erro($mensagem);

                    Redirect::back();

                }

                if(Input::file('imagem')['size']['megabyte'] <= 2)
                {
                    $arquivo = new \Lib\Imagem(Input::file('imagem'), '', 'arquivo/'.$this->usuario->cliente_id.'/banner');

                    $aItem['arquivo'] = $arquivo->resize();
                }
                else
                {

                    Mensagem::erro('O tamanho do arquivo deve ser de até 2 MB');

                    Redirect::back();

                }

            }

            $model->saveArray($aItem);

            Mensagem::sucesso('Banner inserida com sucesso!');

            Redirect::to('backend/banner/index');

        }

        public final function actionGetForm ()
        {

            $this->titulo = 'Banner';

            $geral = \Model\ParametroGeral::where('cliente_id',$this->usuario->cliente_id)->first();

            if($geral->tema == 'Tema 1')
            {

                $labelBanner = 'Imagem com proporção mínima de 1082px largura por 487px altura (em formato JPG ou PNG de até 2MB).';

            }
            else if($geral->tema == 'Tema 2')
            {

                $labelBanner = 'Imagem com proporção mínima de 2000px largura por 550px altura (em formato JPG ou PNG de até 2MB).';

            }
            else
            {

                $labelBanner = 'Imagem com proporção mínima de 2000px largura por 550px altura (em formato JPG ou PNG de até 2MB).';

            }

            $this->view('banner/form', array(
                'item'        => \Model\Banner::where('id',Input::get('id'))->first(),
                'labelBanner' => $labelBanner,
            ));

        }

    }