<?php

namespace Automatico;

use Imagine\Gd\Imagine;
use Imagine\Image\Box;
use Model\Cliente;
use Model\ContatoFilial;
use Model\ParametroGeral;
use Model\Usuario;
use Model\Veiculo;
use Model\VeiculoImagem;
use Model\VeiculoMarca;
use Model\VeiculoMarcaModelo;
use Parvus\Input;

class Estoque
{

    public final function actionPostIndex()
    {



        if (!is_dir('arquivo/1/veiculo/'))
        {

            @mkdir('arquivo/1/veiculo/');

        }

        $aObrigatorio = array('ano_fabricacao', 'ano_modelo', 'valor_venda', 'data_entrada_estoque', 'marca', 'modelo', 'tipo', 'modelo_complemento');

        $aJSON = array(
            'status' => '403',
            'mensagem' => 'Permissão negada'
        );

        $aParametro = array(
            'XML'  => trim($_REQUEST['XML']),
            'hash' => trim($_REQUEST['hash'])
        );

        if ($aParametro['hash'] != NULL)
        {

            if ($aParametro['hash'] != '70MCvus6tvIifNrzxU5Ye87mAIK28OtyWegbFyQE4CX2gGoffG')
            {

                $aJSON['status'] = '403';
                $aJSON['mensagem'] = 'Hash inválida.';

            }
            elseif ($aParametro['XML'] == NULl)
            {

                $aJSON['status'] = '403';
                $aJSON['mensagem'] = 'XML não informado.';

            }
            else
            {

                $array = json_decode(json_encode((array)simplexml_load_string($aParametro['XML'])), true);

                $ano = null;

                if ($array['ano_fabricacao'] && $array['ano_modelo'])
                {

                    $ano = $array['ano_fabricacao'] . '/' . $array['ano_modelo'];

                }
                else if ($array['ano_fabricacao'] && !$array['ano_modelo'])
                {

                    $ano = $array['ano_fabricacao'];

                }
                else if (!$array['ano_fabricacao'] && $array['ano_modelo'])
                {

                    $ano = $array['ano_modelo'];

                }

                $ano = $ano ? ' '.$ano : NULL;
                $cor =  $array['cor'] ? ' '.$array['cor'] : NULL;




                $potencia = $array['potencia'];
                $arrPotencia = null;


                if(!empty($potencia)){
                    $arrPotencia = $array['potencia'];
                }



                $objParametro = ParametroGeral::query()->first();


                $nome_veiculo = $array['marca'].' '.$array['modelo'].' ' .$array['modelo_complemento']. $ano;

                if($objParametro->exibir_cores == "Sim"){
                    $nome_veiculo .= " " . $cor;
                };


                $aInformacao = array(
                    'codigo'        => $array['codigo_anuncio'],
                    'placa'         => $array['placa'],
                    'fabricacao'    => $array['ano_fabricacao'],
                    'modelo'        => $array['ano_modelo'],
                    'valor'         => $array['valor_venda'],
                    'data'          => date('Y-m-d H:i:s', strtotime($array['data_entrada_estoque'])),
                    'nome'          => $nome_veiculo,
                    'quilometragem' => $array['quilometragem'],
                    'potencia'      => $arrPotencia,
                    'porta'         => $array['portas'],
                    'cor'           => $array['cor'],
                    'tipo'          => $array['tipo'],
                    'cidade'        => $array['cidade'],
                    'combustivel'   => $array['combustivel'],
                    'observacao'    => $array['observacao'],
                    'opcional'      => implode(chr(10), explode(',', $array['opcionais'])),
                    'destaque'      => $array['destaque'],
                    'repasse'       => $array['repasse'],
                    'oferta'        => $array['oferta'],
                    'filial_apelido'=> $array['filial_apelido']
                );






                try
                {

                    if ($array['acao'] != 'EXCLUIR')
                    {

                        foreach ($aObrigatorio as $campo)
                        {

                            if ($array[$campo] == NULL)
                            {

                                $aJSON['status'] = '500';
                                $aJSON['mensagem'] = 'Veiculo sem a informação: ' . $campo . ".";

                            }

                        }

                    }

                    if ($aJSON['status'] != 500)
                    {

                        /**
                         * Verifica se o cliente existe
                         */
                        $usuario = \Model\Usuario::where('email',mb_strtolower($array['usuario'],'UTF-8'))
                            ->where('senha',md5(senhaPrefixo.base64_decode($array['senha'])))
                            ->first();

                        if ($usuario == NULL)
                        {

                            $aJSON['status'] = '500';
                            $aJSON['mensagem'] = 'Usuário não encontrado. ' . $array['usuario'];

                        }
                        else
                        {

                            $aInformacao['cliente_id'] = $usuario->cliente_id;

                            if ($array['acao'] == 'EXCLUIR')
                            {

                                $modelVeiculo = Veiculo::where('cliente_id', $usuario->cliente_id)
                                    ->where('codigo', $aInformacao['codigo'])
                                    ->first();

                                if ($modelVeiculo)
                                {

                                    VeiculoImagem::where('veiculo_id',$modelVeiculo->id)->delete();

                                    $modelVeiculo->delete();

                                    $diretorio = 'arquivo/'.$aInformacao['cliente_id'].'/veiculo/'.$modelVeiculo->id.'/';

                                    if (is_dir ($diretorio))
                                    {

                                        foreach(new \DirectoryIterator($diretorio) as $arquivo)
                                        {

                                            if ($arquivo->isFile())
                                            {

                                                unlink($diretorio.$arquivo->getFilename());

                                            }

                                        }

                                        rmdir($diretorio);

                                    }

                                    $aJSON['status']   = '200';
                                    $aJSON['mensagem'] = 'Veículo excluído com sucesso.';

                                }
                                else
                                {

                                    $aJSON['status'] = '500';
                                    $aJSON['mensagem'] = 'Veículo não encontrado.';

                                }

                            }
                            else
                            {

                                $aInformacao['cliente_id'] = $usuario->cliente_id;

                                /**
                                 * Verifica se a marca existe
                                 */
                                $modelMarca = VeiculoMarca::where('cliente_id', $aInformacao['cliente_id'])
                                    ->where('nome', $array['marca'])
                                    ->first();

                                $aInformacao['veiculo_marca_id'] = $modelMarca->id;

                                if (!$modelMarca)
                                {

                                    $modelMarca = new VeiculoMarca();

                                    $modelMarca->saveArray([
                                        'cliente_id' => $aInformacao['cliente_id'],
                                        'nome'      => $array['marca']
                                    ]);

                                    $aInformacao['veiculo_marca_id'] = $modelMarca->id;

                                }

                                /**
                                 * Verifica se existe a marca e modelo
                                 */
                                $modelModelo = VeiculoMarcaModelo::where('veiculo_marca_id', $aInformacao['veiculo_marca_id'])
                                    ->where('nome', $array['modelo'])
                                    ->first();

                                $aInformacao['veiculo_marca_modelo_id'] = $modelModelo->id;

                                if ($modelModelo == NULL)
                                {

                                    $modelModelo = new VeiculoMarcaModelo();

                                    $modelModelo->saveArray([
                                        'veiculo_marca_id'  => $aInformacao['veiculo_marca_id'],
                                        'nome'              => $array['modelo'],
                                        'complemento'       => $array['modelo_complemento']
                                    ]);

                                    $aInformacao['veiculo_marca_modelo_id'] = $modelModelo->id;

                                }
                                else
                                {

                                    $modelModelo->saveArray([
                                        'nome'              => $array['modelo'],
                                        'complemento'       => $array['modelo_complemento']
                                    ]);

                                    $aInformacao['veiculo_marca_modelo_id'] = $modelModelo->id;

                                }

                                /** Converte o tipo */
                                if ($aInformacao['tipo'] == 'Carro/Camioneta')
                                {

                                    $aInformacao['tipo'] = 'Carro';

                                }

                                $aInformacao['combustivel'] = str_replace('/', ',', $aInformacao['combustivel']);

                                /**
                                 * Verifica se o veiculo existe
                                 */
                                $modelVeiculo = Veiculo::where('cliente_id', $aInformacao['cliente_id'])
                                    ->where('codigo', $aInformacao['codigo'])
                                    ->first();


                                if (!$modelVeiculo)
                                {

                                    $aAlias = array_filter(array_unique([
                                        $aInformacao['codigo'],
                                        $aInformacao['nome'],
                                    ]));



                                    $aInformacao['alias'] = $this->formataNomeVeiculo(implode(' ', $aAlias));


                                    $modelVeiculo = new Veiculo();

                                    $modelVeiculo->saveArray($aInformacao);

                                    $veiculoId = $modelVeiculo->id;

                                }
                                else
                                {

                                    $aAlias = array_filter(array_unique([
                                        $aInformacao['codigo'],
                                        $aInformacao['nome'],
                                    ]));

                                    $aInformacao['alias'] = $this->formataNomeVeiculo(implode(' ', $aAlias));

                                    $veiculoId = $modelVeiculo->id;

                                    $modelVeiculo->saveArray($aInformacao);

                                    $aInformacao['alias'] = $modelVeiculo->alias;

                                }

                                $diretorio = 'arquivo/'.$aInformacao['cliente_id'].'/veiculo/'.$veiculoId.'/';

                                if(!is_array($array['foto']))
                                {

                                    $modelImagemVeiculo = VeiculoImagem::where('veiculo_id',$veiculoId)->first();

                                    $modelDadosImagemVeiculo = VeiculoImagem::where('veiculo_id',$veiculoId)->get();

                                    $modelVeiculo = Veiculo::where('id',$veiculoId)->first();

                                    if ($modelImagemVeiculo != NULL)
                                    {

                                        if(is_dir($diretorio))
                                        {

                                            foreach(new \DirectoryIterator($diretorio) as $arquivo)
                                            {

                                                if ($arquivo->isFile())
                                                {

                                                    chmod("arquivo/".$aInformacao['cliente_id']."/veiculo/".$veiculoId."/", 0777);

                                                    unlink($diretorio.$arquivo->getFilename());

                                                }

                                            }
                                        }

                                        foreach ($modelDadosImagemVeiculo as $dados)
                                        {

                                            VeiculoImagem::where('id', $dados->id)->delete();

                                        }

                                    }

                                    $foto = end(explode('=',$array['foto']));

                                    $modelImagem = VeiculoImagem::where('veiculo_id',$veiculoId)
                                        ->where('nome', $foto)
                                        ->first();

                                    if(!is_dir($diretorio))
                                    {

                                        @mkdir('arquivo/'.$aInformacao['cliente_id'].'/veiculo/'.$veiculoId.'/');

                                    }

                                    $file = fopen($diretorio.$foto,'x');

                                    if($file)
                                    {

                                        fwrite($file, $this->cURL($array['foto']));
                                        fclose($file);

                                        $modelImagem = new VeiculoImagem();

                                        $modelImagem->saveArray([
                                            'veiculo_id' => $veiculoId,
                                            'nome'       => $foto
                                        ]);

                                        $modelVeiculo = Veiculo::where('id', $veiculoId)->first();

                                        $modelVeiculo->saveArray([
                                            'imagem' => $foto
                                        ]);

                                    }
                                    elseif(!$foto && !$file)
                                    {

                                        $modelVeiculo = Veiculo::where('id', $veiculoId)->first();

                                        $modelVeiculo->saveArray([
                                            'imagem' => $foto
                                        ]);

                                        VeiculoImagem::where('veiculo_id',$veiculoId)->delete();

                                    }

                                }
                                else
                                {

                                    $diretorio = 'arquivo/'.$aInformacao['cliente_id'].'/veiculo/'.$veiculoId.'/';

                                    $modelImagemVeiculo = VeiculoImagem::where('veiculo_id',$veiculoId)->first();

                                    $modelDadosImagemVeiculo = VeiculoImagem::where('veiculo_id',$veiculoId)->get();

                                    if ($modelImagemVeiculo != NULL)
                                    {

                                        if(is_dir($diretorio))
                                        {

                                            foreach(new \DirectoryIterator($diretorio) as $arquivo)
                                            {

                                                if ($arquivo->isFile())
                                                {

                                                    chmod("arquivo/".$aInformacao['cliente_id']."/veiculo/".$veiculoId."/", 0777);

                                                    unlink($diretorio.$arquivo->getFilename());

                                                }

                                            }
                                        }
                                        foreach ($modelDadosImagemVeiculo as $dados)
                                        {

                                            VeiculoImagem::where('id', $dados['id'])->delete();

                                        }

                                    }

                                    foreach ($array['foto'] as $ordem => $foto) {

                                        parse_str($foto, $aImagem);

                                        $modelImagem = VeiculoImagem::where('veiculo_id', $veiculoId)
                                            ->where('nome', $aImagem['nf'])
                                            ->first();

                                        if (!$modelImagem) {

                                            if (!is_dir($diretorio))
                                            {

                                                @mkdir('arquivo/' . $aInformacao['cliente_id'] . '/veiculo/' . $veiculoId . '/');

                                            }

                                            $file = fopen($diretorio . $aImagem['nf'], 'x');

                                            if ($file) {

                                                fwrite($file, $this->cURL($foto));
                                                fclose($file);

                                                $modelImagem = new VeiculoImagem();

                                                $modelImagem->saveArray([
                                                    'veiculo_id' => $veiculoId,
                                                    'nome'       => $aImagem['nf']

                                                ]);

                                                if ($ordem == 0)
                                                {

                                                    $modelVeiculo = Veiculo::where('id', $veiculoId)->first();

                                                    $modelVeiculo->saveArray([
                                                        'imagem' => $aImagem['nf']
                                                    ]);

                                                }

                                            }

                                        }

                                    }

                                }

                                $aJSON['status']   = '200';
                                $aJSON['mensagem'] = 'Veículo salvo com sucesso.';

                                if($aInformacao['alias'])
                                {
                                    $aJSON['alias']    = $aInformacao['alias'];
                                }

                            }

                        }

                    }

                }
                catch (\Exception $e)
                {

                    $aJSON['status'] = '500';
                    $aJSON['mensagem'] = 'Erro: ' . $e->getMessage();

                }

            }

        }

        print json_encode($aJSON);

    }

    public final function formataNomeVeiculo($prNome)
    {


        if (is_string($prNome)) {
            $prNome = strtolower(trim(utf8_decode($prNome)));

            $before = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿRr';
            $after  = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr';
            $prNome = strtr($prNome, utf8_decode($before), $after);

            $replace = array(
                '/[^a-z0-9.-]/'	=> '-',
                '/-+/'			=> '-',
                '/\-{2,}/'		=> ''
            );
            $prNome = preg_replace(array_keys($replace), array_values($replace), $prNome);
        }
        return $prNome;


        /*$alias = strtolower($prNome);

        $alias = preg_replace('/[^\\pL0-9]+/u', '-', $alias);
        $alias = trim($alias, "-");
        $alias = iconv("utf-8", "us-ascii//TRANSLIT", $alias);
        $alias = preg_replace('/[^-a-z0-9]+/i', '', $alias);

        return $alias;*/

    }

    public final function cURL ($prLink) {

        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $prLink);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $conteudo = curl_exec($ch);
        curl_close($ch);

        return $conteudo;
    }


}