#TABLE#
ALTER TABLE `foto`
	CHANGE COLUMN `descricao` `descricao` VARCHAR(255) NULL DEFAULT NULL AFTER `cliente_id`;

#TABLE#
ALTER TABLE `cliente`
	ADD COLUMN `chat` LONGTEXT NULL DEFAULT NULL AFTER `endereco_complemento`;

#TABLE#
CREATE TABLE IF NOT EXISTS `contato` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` enum('Matriz','Filial') DEFAULT NULL,
  `nome` longtext,
  `email` varchar(255) DEFAULT NULL,
  `endereco_rua` varchar(255) DEFAULT NULL,
  `endereco_numero` varchar(255) DEFAULT NULL,
  `endereco_cep` varchar(255) DEFAULT NULL,
  `endereco_complemento` varchar(255) DEFAULT NULL,
  `endereco_bairro` varchar(255) DEFAULT NULL,
  `endereco_cidade` varchar(255) DEFAULT NULL,
  `endereco_uf` varchar(255) DEFAULT NULL,
  `endereco_mapa` longtext,
  `telefone_tipo_1` varchar(255) DEFAULT NULL,
  `telefone_valor_1` varchar(255) DEFAULT NULL,
  `telefone_tipo_2` varchar(255) DEFAULT NULL,
  `telefone_valor_2` varchar(255) DEFAULT NULL,
  `telefone_tipo_3` varchar(255) DEFAULT NULL,
  `telefone_valor_3` varchar(255) DEFAULT NULL,
  `horario_tipo_1` varchar(255) DEFAULT NULL,
  `horario_valor_1` varchar(255) DEFAULT NULL,
  `horario_tipo_2` varchar(255) DEFAULT NULL,
  `horario_valor_2` varchar(255) DEFAULT NULL,
  `horario_tipo_3` varchar(255) DEFAULT NULL,
  `horario_valor_3` varchar(255) DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
);

#TABLE#
CREATE TABLE IF NOT EXISTS  `rodape_fixo` (
	`id` INT NOT NULL AUTO_INCREMENT,
	`exibe` ENUM('Sim','Não') NOT NULL DEFAULT 'Não',
	`frase_principal` VARCHAR(255) NULL DEFAULT NULL,
	`frase_secundaria` VARCHAR(255) NULL DEFAULT NULL,
	`telefone_numero_1` VARCHAR(255) NULL DEFAULT NULL,
	`telefone_frase_1` VARCHAR(255) NULL DEFAULT NULL,
	`telefone_numero_2` VARCHAR(255) NULL DEFAULT NULL,
	`telefone_frase_2` VARCHAR(255) NULL DEFAULT NULL,
	`log_cadastro_data` DATETIME NOT NULL,
	`log_cadastro_usuario_id` INT NOT NULL,
	`log_alterado_data` DATETIME NULL DEFAULT NULL,
	`log_alterado_usuario_id` INT NULL DEFAULT NULL,
	`log_excluido_data` DATETIME NULL DEFAULT NULL,
	`log_excluido_usuario_id` INT NULL DEFAULT NULL,
	PRIMARY KEY (`id`)
);

#TABLE#
CREATE TABLE IF NOT EXISTS  `versao` (
	`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
	`data` DATE NOT NULL,
	`texto` TEXT NOT NULL COLLATE 'utf8_unicode_ci',
	PRIMARY KEY (`id`)
);


#TABLE#
ALTER TABLE `parametro_geral`
	ADD COLUMN `exibe_estoque_home` ENUM('Sim','Não') NOT NULL DEFAULT 'Não' AFTER `exibe_ano`;

#TABLE#
CREATE TABLE IF NOT EXISTS  `modal` (
	`id` INT(11) NOT NULL,
	`exibe` ENUM('Sim','Não') NOT NULL DEFAULT 'Não',
	`imagem` LONGTEXT NULL DEFAULT NULL,
	PRIMARY KEY (`id`)
);

#TABLE#
ALTER TABLE `parametro_geral`
	ADD COLUMN `exibe_placa_mascara` VARCHAR(50) NULL AFTER `exibe_placa`;

#TABLE#
ALTER TABLE `parametro_geral`
	ADD COLUMN `tipo_banner` ENUM('Largura fixa', 'Largura variável') NULL DEFAULT 'Largura fixa' AFTER `tema`;

#TABLE#
ALTER TABLE `ficha_cadastral`
	CHANGE COLUMN `rg` `rg` VARCHAR(255) NOT NULL AFTER `cpf`;


#TABLE#
ALTER TABLE `rodape_fixo`
    ADD COLUMN `telefone_tipo_1` ENUM('WhatsApp','Telefone') NULL DEFAULT 'WhatsApp' AFTER `frase_secundaria`,
    ADD COLUMN `telefone_tipo_2` ENUM('WhatsApp','Telefone') NULL DEFAULT 'Telefone' AFTER `telefone_frase_1`;

#TABLE#
ALTER TABLE `contato`
	ADD COLUMN `telefone_icone_1` ENUM('WhatsApp','Telefone') NULL DEFAULT 'Telefone' AFTER `endereco_mapa`,
	ADD COLUMN `telefone_icone_2` ENUM('WhatsApp', 'Telefone') NULL DEFAULT 'Telefone' AFTER `telefone_valor_1`,
	ADD COLUMN `telefone_icone_3` ENUM('WhatsApp', 'Telefone') NULL DEFAULT 'Telefone' AFTER `telefone_valor_2`;

#TABLE#
ALTER TABLE `analytics`
  ADD COLUMN `script_proposta` text DEFAULT NULL AFTER `script`,
  ADD COLUMN `script_facebook_pixel` text DEFAULT NULL AFTER `script_proposta`;

#TABLE#
CREATE TABLE IF NOT EXISTS `google360`(
  `id` INT NOT NULL AUTO_INCREMENT,
  `cliente_id` INT NOT NULL,
  `enabled` TEXT,
  `log_cadastro_usuario_id` INT,
  `log_alterado_usuario_id` INT,
  `log_cadastro_data` DATE,
  `log_alterado_data` DATE,
  `log_excluido_data` DATE,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_cliente_cadastro` FOREIGN KEY (`cliente_id`) REFERENCES `cliente`(`id`) ON UPDATE CASCADE ON DELETE CASCADE
);

#TABLE#
CREATE TABLE IF NOT EXISTS `seo`( `id` INT NOT NULL AUTO_INCREMENT, `palavra_chave` VARCHAR(255), `log_cadastro_data` DATE, `log_alterado_data` DATE, `log_excluido_data` DATE, PRIMARY KEY (`id`) );

#TABLE#
CREATE TABLE IF NOT EXISTS `youtube` (
  `id` INT(11) NOT NULL,
  `exibe` ENUM('Sim','Não') NOT NULL,
  `canal` TEXT DEFAULT NULL,
  `video_1` TEXT DEFAULT NULL,
  `video_2` TEXT DEFAULT NULL,
  `video_3` TEXT DEFAULT NULL,
  `log_cadastro_data` DATETIME NOT NULL,
  `log_cadastro_usuario_id` INT(11) NOT NULL,
  `log_alterado_data` DATETIME DEFAULT NULL,
  `log_alterado_usuario_id` INT(11) DEFAULT NULL,
  `log_excluido_data` DATETIME DEFAULT NULL,
  `log_excluido_usuario_id` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
);


#TABLE#
ALTER TABLE `noticia`
  CHANGE `imagem` `imagem` VARCHAR(255) CHARSET utf8 COLLATE utf8_general_ci NULL;

#TABLE#
ALTER TABLE `noticia` CHANGE `integra` `integra` TEXT NOT NULL;

#TABLE#
ALTER TABLE `parametro_geral`
  ADD COLUMN `nome_pagina_home` VARCHAR(25) DEFAULT 'Home'   NULL AFTER `log_excluido_usuario_id`;


#TABLE#
ALTER TABLE `parametro_geral`
  ADD COLUMN `filtro_exibe_modelo` ENUM('Sim') DEFAULT 'Sim'   NOT NULL AFTER `importa_noticia_blog`;

#TABLE#
ALTER TABLE `parametro_geral`
  ADD COLUMN `menu_fixo` ENUM('Sim','Não') DEFAULT 'Sim'   NOT NULL AFTER `tema`;


#TABLE#
ALTER TABLE `parametro_geral`
  ADD COLUMN `recaptcha` VARCHAR(255) NULL AFTER `nome_pagina_home`;


#TABLE#
ALTER TABLE `rodape_fixo`
  ADD COLUMN `telefone_tipo_4` ENUM('WhatsApp','Telefone') DEFAULT 'Telefone'   NULL AFTER `telefone_frase_3`,
  ADD COLUMN `telefone_numero_4` VARCHAR(255) NULL AFTER `telefone_tipo_4`,
  ADD COLUMN `telefone_frase_4` VARCHAR(255) NULL AFTER `telefone_numero_4`;


#TABLE#
ALTER TABLE `cliente`
  ADD COLUMN `url` VARCHAR(255) NULL AFTER `log_excluido_usuario_id`;



#TABLE#
CREATE TABLE IF NOT EXISTS `link`(
  `id` INT NOT NULL AUTO_INCREMENT,
  `titulo` VARCHAR(255) NOT NULL,
  `url` TEXT NOT NULL,
  PRIMARY KEY (`id`)
);

#TABLE#
ALTER TABLE `parametro_geral` ADD COLUMN `base_url` VARCHAR(255) NULL AFTER `log_excluido_usuario_id`;

#TABLE#
ALTER TABLE `parametro_geral` ADD COLUMN `versao` VARCHAR(255) NULL AFTER `base_url`;

#TABLE#
ALTER TABLE `parametro_geral` ADD COLUMN `header` TEXT NULL AFTER `base_url`, ADD COLUMN `footer` TEXT NULL AFTER `header`,ADD COLUMN `body` TEXT NULL AFTER `footer`;



#TABLE#
REPLACE INTO `pagina` (`id`, `nome`) values (10, 'Venda seu veículo');

#TABLE#
REPLACE INTO `versao` (`id`, `data`, `texto`) VALUES (8, '2017-08-28', '<p><strong>GERAIS</strong></p>\r\n\r\n<ul>\r\n  <li>Implementado o rodap&eacute; fixo no site que pode ser ocultado atrav&eacute;s do admin (#17932).</li>\r\n  <li>Alterado o rodap&eacute; do site para exibir em colunas as informa&ccedil;&otilde;es das filiais (#17928).</li>\r\n</ul>\r\n\r\n<p><strong>CONTATO</strong></p>\r\n\r\n<ul>\r\n <li>Alterado a p&aacute;gina de contato para exibir as filiais em mapas individuais (#17928).</li>\r\n</ul>\r\n\r\n<p><strong>VE&Iacute;CULO</strong></p>\r\n\r\n<ul>\r\n <li>Aplicado um slider na foto principal do ve&iacute;culo (#17930).</li>\r\n</ul>\r\n');

#TABLE#
REPLACE INTO `versao` (`id`, `data`, `texto`) VALUES (9, '2017-09-01', '<p><strong>Banner</strong></p>\r\n\r\n<ul>\r\n  <li>Inclu&iacute;do nos par&acirc;metros gerais, o campo &quot;Tipo de banner&quot;, que possibilita exibir o banner com largura fixa ou vari&aacute;vel. (#18149)</li>\r\n</ul>\r\n\r\n<p><strong>Gerais</strong></p>\r\n\r\n<ul>\r\n  <li>Inclu&iacute;do nos par&acirc;metros gerais, no painel &quot;Exibi&ccedil;&atilde;o do estoque&quot;, o campo &quot;Exibi&ccedil;&atilde;o placa&quot;, que permite o usu&aacute;rio definir quais ser&atilde;o os caracteres vis&iacute;veis da placa no site. Para exibir todos os caracteres, incluir a m&aacute;scara AAA-9999, para ocultar caracteres, substituir por &quot;*&quot;. Ex: AAA-9999 = QME-9524 | A**-***9 = Q-4. (#17933)</li>\r\n  <li>Inclu&iacute;do o menu &quot;Janela de aviso&quot;, que permite ao usu&aacute;rio carregar uma imagem para ser exibida na home do site quando aberto pela primeira vez. (#17931)</li>\r\n</ul>\r\n\r\n<p><strong>Contato</strong></p>\r\n\r\n<ul>\r\n <li>Alterado para que seja exibido at&eacute; 2 telefones da matriz no topo do site. (#17929)</li>\r\n  <li>Alterado para que seja exibido at&eacute; 2 telefones por filial no rodap&eacute; do site. (#17929)</li>\r\n</ul>\r\n');

#TABLE#
REPLACE INTO `versao` (`id`, `data`, `texto`) VALUES (10, '2017-09-11', '<p><strong>Ficha Cadastral</strong></p>\r\n\r\n<ul>\r\n  <li>Corrigida e melhorada a apresenta&ccedil;&atilde;o da ficha cadastral no corpo do e-mail. (18244)</li>\r\n</ul>\r\n\r\n<p><strong>Rodap&eacute; Fixo</strong></p>\r\n\r\n<ul>\r\n <li>Alterado para que seja permitido selecionar o &iacute;cone de telefone ou whatsapp para os n&uacute;meros de contato do rodap&eacute;. (18256)</li>\r\n</ul>\r\n\r\n<p><strong>Janela de Aviso</strong></p>\r\n\r\n<ul>\r\n <li>Alterado para que o bot&atilde;o de fechar (X) na janela de aviso fique mais pr&oacute;ximo do quadro de imagem. (18256)</li>\r\n</ul>\r\n');

#TABLE#
REPLACE INTO `versao` (`id`, `data`, `texto`) VALUES (11, '2017-09-14', '<p><strong>Contato</strong></p>\r\n\r\n<ul>\r\n  <li>Aumentado em 3px os t&iacute;tulos e as descri&ccedil;&otilde;es de contato nos mapas. (#18256)</li>\r\n  <li>Alterado o espa&ccedil;amento entre os mapas e o formul&aacute;rio de contato para que fiquem iguais. (#18256)</li>\r\n</ul>\r\n\r\n<p><strong>Rodap&eacute; Fixo</strong></p>\r\n\r\n<ul>\r\n  <li>Alinhado os &iacute;cones de telefone e whatsapp com o n&uacute;mero do telefone. (#18256)</li>\r\n <li>Alterado para que o tamanho do logotipo possa se estender at&eacute; 254px de largura. (#18256)</li>\r\n</ul>\r\n');

#TABLE#
REPLACE INTO `versao` (`id`, `data`, `texto`) VALUES (12, '2017-10-16', '<p><strong>Gerais</strong></p>\r\n\r\n<ul>\r\n <li>Alterado para exibir na cor preta o termo &quot;Sistema para loja de ve&iacute;culos&quot; no rodap&eacute; do modelo B.&nbsp;(#18764)</li>\r\n <li>Corrigido a exibi&ccedil;&atilde;o dos t&iacute;tulos das p&aacute;ginas para melhor apresenta&ccedil;&atilde;o nos sites de buscas.&nbsp;(#18764)</li>\r\n <li>Corrigido a exibi&ccedil;&atilde;o do release da vers&atilde;o no backend.&nbsp;(#18764)</li>\r\n</ul>\r\n\r\n<p><strong>Home</strong></p>\r\n\r\n<ul>\r\n  <li>Corrigido a exibi&ccedil;&atilde;o do banner com par&acirc;metro &quot;largura vari&aacute;vel&quot; no modelo C.&nbsp;(#18764)</li>\r\n  <li>Corrigido a exibi&ccedil;&atilde;o do modal &quot;Janela de aviso&quot;.&nbsp;(#18764)</li>\r\n <li>Corrigido o processo de upload de&nbsp;imagem para o banner.&nbsp;(#18764)</li>\r\n <li>Corrigido o processo de uplload de imagem para o logotipo e favicon.&nbsp;(#18764)</li>\r\n</ul>\r\n\r\n<p><strong>Empresa</strong></p>\r\n\r\n<ul>\r\n <li>Corrigido a exibi&ccedil;&atilde;o da imagem da empresa.&nbsp;(#18764)</li>\r\n</ul>\r\n\r\n<p><strong>Estoque</strong></p>\r\n\r\n<ul>\r\n <li>Corrigido a ordena&ccedil;&atilde;o dos intens de filtro.&nbsp;(#18764)</li>\r\n</ul>\r\n\r\n<p><strong>Not&iacute;cias</strong></p>\r\n\r\n<ul>\r\n  <li>Corrigido o processo de upload de imagem para uma not&iacute;cia.&nbsp;(#18764)</li>\r\n</ul>\r\n\r\n<p><strong>Contato</strong></p>\r\n\r\n<ul>\r\n  <li>Corrigido a exibi&ccedil;&atilde;o do campo &quot;complemento&quot; no endere&ccedil;o.&nbsp;(#18764)</li>\r\n  <li>Alterado para exibir o layout individual de endere&ccedil;o quando cadastrado apenas 01 contato.&nbsp;(#18764)</li>\r\n <li>Implementado um tra&ccedil;o no layout&nbsp;entre as filiais.&nbsp;(#18764)</li>\r\n</ul>\r\n');

#TABLE#
REPLACE INTO `versao` (`id`, `data`, `texto`) VALUES (13, '2017-10-18', '<p><strong>Gerais</strong></p>\r\n\r\n<ul>\r\n <li>Alterado no bot&atilde;o que exibe o valor do ve&iacute;culo, para que quando o valor for R$ 0,00, seja exibido o texto &quot;Consultar pre&ccedil;o&quot;. (#18764)</li>\r\n <li>Removido o espa&ccedil;amento entre os campos de telefone e e-mail no rodap&eacute; do site. (#18809)</li>\r\n</ul>\r\n\r\n<p><strong>Home&nbsp;</strong></p>\r\n\r\n<ul>\r\n <li>Corrigido a apresenta&ccedil;&atilde;o da descri&ccedil;&atilde;o dos ve&iacute;culos. (#18809)</li>\r\n  <li>Corrigido a apresenta&ccedil;&atilde;o das imagens dos ve&iacute;culos. (#18809)</li>\r\n <li>Corrigido a apresenta&ccedil;&atilde;o das imagens das not&iacute;cias. (#18809)</li>\r\n <li>Removido o espa&ccedil;amento entre o t&iacute;tulo &quot;Ve&iacute;culos em destaque&quot; e o banner do modelo C. (#18809)</li>\r\n</ul>\r\n\r\n<p><strong>Estoque</strong></p>\r\n\r\n<ul>\r\n <li>Aplicada a ordena&ccedil;&atilde;o dos filtros &quot;Combust&iacute;vel&quot; e &quot;Outros&quot;. (#18809)</li>\r\n</ul>\r\n\r\n<p><strong>Contato</strong></p>\r\n\r\n<ul>\r\n <li>Alterado para que o mapa se estenda at&eacute; o final do bot&atilde;o &quot;Enviar&quot; do formul&aacute;rio de contato. (#18809)</li>\r\n</ul>\r\n');

#TABLE#
REPLACE INTO `versao` (`id`, `data`, `texto`) VALUES (14, '2017-10-27', '<p><strong>HOME</strong></p>\r\n\r\n<ul>\r\n <li>Implementado a op&ccedil;&atilde;o para exibir o estoque na home. (#18771)</li>\r\n</ul>\r\n\r\n<p><strong>RODAP&Eacute;</strong></p>\r\n\r\n<ul>\r\n <li>Alterado para exibir at&eacute; 03 telefones no rodap&eacute;. (#18771)</li>\r\n  <li>Alterado para que seja permitido escolher o &iacute;cone do telefone (whatsapp/tel) no rodap&eacute;. (#18771)</li>\r\n</ul>\r\n\r\n<p><strong>NOT&Iacute;CIAS</strong></p>\r\n\r\n<ul>\r\n <li>Alterado o label &quot;Imagens&quot; para &quot;Miniatura&quot; no cadastro de imagem da not&iacute;cia (backend). (#18771)</li>\r\n</ul>\r\n');

#TABLE#
ALTER TABLE `parametro_geral` ADD COLUMN `exibe_localizacao` ENUM('Não','Sim') NULL AFTER `exibe_placa_mascara`;

#TABLE#
ALTER TABLE `contato` ADD COLUMN `chave` VARCHAR(255) NULL AFTER `log_excluido_usuario_id`, ADD COLUMN `descricao_exibicao` VARCHAR(255) NULL AFTER `chave`,ADD COLUMN `custom_exibicao` enum('Sim','Não') NULL after `descricao_exibicao`;

#TABLE#
ALTER TABLE `rodape_fixo` ADD COLUMN `frase_whatsapp` VARCHAR(255) NULL AFTER `frase_principal`;

#TABLE#
ALTER TABLE `contato` ADD COLUMN `exibir_topo` ENUM('Sim','Não') DEFAULT 'Não'   NULL AFTER `custom_exibicao`;


#TABLE#
ALTER TABLE `veiculo` CHANGE `tipo` `tipo` ENUM('Carro','Moto','Triciclo','Quadriciclo','Barco','Ônibus/Van','Jet Ski','Ônibus','Micronibus','Van','Motor home','Máquinas agrícolas','Implemento Rodoviário','Ônibus/Micronibus/Van','Caminhão','Motor Popa','Triciclo/Quadriciclo') CHARSET utf8 COLLATE utf8_general_ci NOT NULL;

#TABLE#
ALTER TABLE `parametro_geral` ADD COLUMN `versao` VARCHAR(255) NULL AFTER `body`;

#TABLE#
UPDATE ficha_cadastral SET data_nascimento = now();

#TABLE#
ALTER TABLE `ficha_cadastral` CHANGE `data_nascimento` `data_nascimento` DATE NULL;

#TABLE#
ALTER TABLE `ficha_cadastral` CHANGE `endereco_numero` `endereco_numero` VARCHAR(255) NULL;

#TABLE#
ALTER TABLE `parametro_geral` ADD COLUMN `tipo_formulario` ENUM('whatsapp','formulario') DEFAULT 'formulario' NULL AFTER `body`, ADD COLUMN `numero_whatsapp` VARCHAR(255) NULL AFTER `tipo_formulario`;

#TABLE#
ALTER TABLE `contato` ADD COLUMN `descricao_endereco` VARCHAR(255) NULL AFTER `exibir_topo`;

#TABLE#
ALTER TABLE `parametro_geral` ADD COLUMN `modelos` ENUM('modelo1','modelo2') DEFAULT 'modelo1' AFTER `body`, ADD COLUMN `exibir_cores` ENUM('Sim','Não') DEFAULT 'Sim' AFTER `modelos`;