<?php

add_action('cmb2_admin_init', 'config_whatsapp');

function config_whatsapp()
{
    //GERENCIAR CORES

    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup_contatos',
        'title' => 'Configurações de whatsapp',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_contato_header', // The option key and admin menu page slug.
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Whatsapp principal</h2>',
        'name' => 'Exibir whatsapp',
        'desc' => '',
        'id' => 'icone_whatsapp',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(

        'name' => 'Mostrar Whatsapp abaixo do titulo do veículo na listagem de estoque',
        'desc' => '',
        'id' => 'mostrar_whatsapp',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Exibir pop antes de redirecionar',
        'desc' => '',
        'id' => 'popup_whatsapp',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(

        'name' => 'Texto do botão',
        'default' => '',
        'id' => 'texto_do_botao',
        'type' => 'textarea_small',

    ));
    $cmb_options->add_field(array(
        'name' => 'Número do whatsapp',
        'desc' => 'Número do whatsapp padrão <strong>(Utilizar apenas números)</strong> exemplo 4788888888',
        'default' => '',
        'id' => 'numero_whatsapp',
        'type' => 'text',
    ));
    $cmb_options->add_field(array(
        'name' => 'Mensagem padrão do whatsapp',
        'desc' => '',
        'default' => '',
        'id' => 'mensagem_whatsapp',
        'type' => 'text'
    ));


}

function get_info_principal($matriz = false)
{

    if ($matriz) {
        $info = alt_get_filiais_matriz();

        if (!isset($info[0])) {

            echo "<div class='alert alert-danger'>Nenhuma matriz cadastrada</div>";

            return [];
        }

        $dados = $info[0];


    } else {
        $dados = get_option('alt_group_contato_header');

    }


    $retorno['nome_fantasia'] = $dados['nome_principal'] ?? null;
    $retorno['cnpj'] = $dados['cnpj_principal'] ?? null;


    $telefone_principal = $dados['telefone_principal'];
    $telefone_principal = str_replace(['(', ')', '-'], '', $telefone_principal);


    $retorno['telefone'] = $telefone_principal;


    $url_telefone = 'tel:' . $retorno['telefone'];
    $retorno['url_telefone'] = $url_telefone ?? null;


    $retorno['email'] = $dados['email_principal'] ?? null;
    $url_email = 'mailto:' . $dados['email_principal'];
    $retorno['url_email'] = $url_email ?? null;


    $numero = $dados['numero_whatsapp'] ?? null;

    if (strlen($numero) > 11) {
        $numero = substr($numero, 2);
    }


    $retorno['whatsapp_full'] = $dados['numero_whatsapp'];
    if (!empty($numero)) {

        if(strlen($numero)==10){
            $numero = alt_mascara('(##)####-#####', $numero);
        }else{
            $numero = alt_mascara('(##)#####-#####', $numero);
        }


    }




    $retorno['whatsapp'] = $numero;
    $url = 'https://wa.me/55' . $dados['numero_whatsapp'];
    $retorno['url_whatsapp'] = $url;

    $retorno['endereco'] = $dados['endereco_principal'] ?? null;
    $retorno['cidade'] = $dados['cidade_principal'] ?? null;
    $retorno['estado'] = $dados['estado_principal'] ?? null;

    $retorno['endereco_completo'] = $retorno['endereco'] . ' - ' . $retorno['cidade'] . ' - ' . $retorno['estado'];


    return $retorno;

}


function get_show_button_whatsapp_listagem()
{

    $dados = get_option('alt_group_contato_header');
    if (isset($dados['mostrar_whatsapp'])) {
        return $dados['mostrar_whatsapp'] == 'sim' ? true : false;
    }

    $dados = get_option('alt_group_listagem');
    return $dados['mostrar_whatsapp'] == 'sim' ? true : false;

    /*$dados = get_option('alt_group_contato_header');
    return $dados['mostrar_whatsapp'] == 'sim' ? true : false;*/
}

function get_show_button_whatsapp()
{

    $dados = get_option('alt_group_contato_header');
    if (isset($dados['icone_whatsapp'])) {
        return $dados['icone_whatsapp'] == 'sim' ? true : false;
    }
    return false;

}

function get_show_popup_whatsapp()
{

    $dados = get_option('alt_group_contato_header');
    if (isset($dados['popup_whatsapp'])) {
        return $dados['popup_whatsapp'] == 'sim' ? true : false;
    }
    return false;

}

function get_button_whatsapp_detalhes()
{

    $dados = get_option('alt_group_contato_header');

    if (isset($dados['numero_whatsapp'])) {
        $retorno['telefone'] = $dados['numero_whatsapp'];
        $retorno['texto_botao'] = $dados['texto_do_botao'];
        $retorno['mensagem'] = $dados['mensagem_whatsapp'];
        return $retorno;
    }


    $dados = get_option('alt_group_setup_detalhes');
    $retorno['telefone'] = $dados['numero_whatsapp'] ?? null;
    $retorno['texto_botao'] = $dados['texto_do_botao'] ?? null;
    $retorno['mensagem'] = $dados['mensagem_whatsapp'] ?? null;
    return $retorno;

}

function validarDados($value, $field_args, $field)
{

    if (filter_var($value, FILTER_VALIDATE_EMAIL)) {
        $sanitized_value = $value;
    } else {
        $sanitized_value = preg_replace("/[^0-9]/", "", $value);

    }

    return $sanitized_value;
}

function alt_check_exist_contatos_header()
{
    $dados = get_option('alt_group_contato_header');


    if (!isset($dados['contatos_header']['0']['valor'])) {
        return false;
    }

    return true;
}


function formataTelefone($phone)
{
    $formatedPhone = preg_replace('/[^0-9]/', '', $phone);
    $matches = [];
    preg_match('/^([0-9]{2})([0-9]{4,5})([0-9]{4})$/', $formatedPhone, $matches);
    if ($matches) {
        return '(' . $matches[1] . ') ' . $matches[2] . '-' . $matches[3];
    }

    return $phone; // return number without format
}


function alt_ativar_whatsapp()
{
    global $wp;
    $mostrar_whatsapp = get_show_button_whatsapp();
    $current_url = home_url(add_query_arg(array(), $wp->request));


    $info = get_button_whatsapp_detalhes();


    if (empty($info['telefone'])) {
        echo "<div class=''>Nenhum número de whatsapp informado. Acesses as configurações</div>";
        return;
    }

    $mensagem = $info['mensagem'] . '';

    $mensagem .= ' *' . $current_url . '*';
    $btn_text = $info['texto_botao'] ?? 'Whatsapp';
    $url = 'https://wa.me/' . $info['telefone'] . '?text=' . $mensagem;

    $configs = " modelo='5' ";
    $configs .= " url='{$url}'";
    $configs .= " nome_botao='{$btn_text}'";


    do_shortcode("[whatsapp_shorcode {$configs}]");

}
