<?php


if (!function_exists('alt_carregar_schema')) {

    function alt_carregar_schema($post)
    {
        global $post;

        $empresa = get_info_principal(true);

        $nome_da_loja = $empresa['nome_fantasia'];
        $logo_loja = alt_get_url_logo();
        $site_loja = "https://www.google.com.br";
        $valor_veiculo = 18000;
        $cidade_da_loja = $empresa['cidade'];
        $estado_da_loja = $empresa['estado'];
        $endereco_da_loja = $empresa['endereco'];
        $telefone_da_loja = formatarNumero($empresa['telefone']);

        if (empty($empresa['nome_fantasia'])) {
            echo "<div class='alert alert-danger' style='font-size: 24px;'><strong>Atenção:</strong> Informe o titulo da revenda matriz</div>";
        }

        if ($post->post_type == 'veiculos') {

            $arrImagens = alt_get_caracteristicas($post->ID, 'alt_imagens');
            $url_imagem = array_shift(array_slice($arrImagens, 0, 1));


            $titulo = get_titulo_produto($post->ID, true);
            $descricao = $post->post_content;
            $cor = alt_get_caracteristicas($post->ID, 'alt_cor') ?? 'Não definida';
            $ano_modelo = alt_get_caracteristicas($post->ID, 'alt_ano_mod') ?? 'Não definida';
            $cambio = alt_get_caracteristicas($post->ID, 'alt_cambio') ?? 'Não definida';

            $objCarroceria = get_the_terms($post->ID, 'carroceria');
            $carroceria = $objCarroceria[0]->name ?? 'Hatchback';



            $portas = alt_get_caracteristicas($post->ID, 'alt_portas') ?? 'Não definida';
            $combustivel = alt_get_caracteristicas($post->ID, 'alt_combustivel') ?? 'Não definida';
            $quilometragem = alt_get_caracteristicas($post->ID, 'alt_kilometragem') ?? 'Não definida';
            $marca = alt_get_marca_modelo_tipo($post->ID, 'marca') ?? 'Não definida';
            $modelo = alt_get_marca_modelo_tipo($post->ID, 'modelo') ?? 'Não definida';

            $cars = array(
                '@context' => 'http://schema.org',
                '@type' => 'Car',
                'name' => $titulo,
                'description' => $descricao,
                'bodyType' => $carroceria,
                'fuelType' => $combustivel,
                'numberOfDoors' => $portas,
                'vehicleModelDate' => $ano_modelo,
                'vehicleSeatingCapacity' => '5',
                'vehicleTransmission' => $cambio,
                'color' => $cor,
                'mileageFromOdometer' =>
                    array(
                        '@type' => 'QuantitativeValue',
                        'unitCode' => 'KMT',
                        'value' => $quilometragem,
                    ),
                'itemCondition' =>
                    array(
                        '@type' => 'OfferItemCondition',
                        'name' => 'Used',
                    ),
                'manufacturer' =>
                    array(
                        '@type' => 'Organization',
                        'name' => $marca,
                    ),
                'model' =>
                    array(
                        '@type' => 'ProductModel',
                        'name' => $modelo,
                    ),
                'offers' =>
                    array(
                        '@type' => 'Offer',
                        'price' => $valor_veiculo,
                        'priceCurrency' => 'BRL',
                        'seller' =>
                            array(
                                '@type' => 'Organization',
                                'name' => $nome_da_loja,
                                'telephone' => $telefone_da_loja,
                                'address' =>
                                    array(
                                        'addressLocality' => $cidade_da_loja,
                                        'addressRegion' => $estado_da_loja,
                                        'streetAddress' => $endereco_da_loja,
                                    ),
                                'aggregateRating' =>
                                    array(
                                        '@type' => 'AggregateRating',
                                        'ratingValue' => '4.7',
                                        'reviewCount' => $post->ID,
                                    ),
                            ),
                    ),
                'image' =>
                    array(
                        '@type' => 'ImageObject',
                        'contentUrl' => $url_imagem ?? 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/veiculo-sem-foto.jpg',
                    ),
                'priceSpecification' =>
                    array(
                        '@type' => 'UnitPriceSpecification',
                        'priceCurrency' => 'BRL',
                        'price' => $valor_veiculo,
                    ),
            );
            echo "<script type=\"application/ld+json\">" . json_encode($cars) . "</script>";
        }

        /**
         * Json LocalBusiness
         */

        $localBusiness = array(
            '@context' => 'https://schema.org',
            '@type' => 'AutoDealer',
            'name' => $nome_da_loja,
            'image' => $logo_loja,
            '@id' => $logo_loja,
            'url' => $site_loja,
            'telephone' => $telefone_da_loja,
            'priceRange' => '15000',
            'address' =>
                array(
                    '@type' => 'PostalAddress',
                    'streetAddress' => $endereco_da_loja,
                    'addressLocality' => $cidade_da_loja,
                    'addressCountry' => 'BR',
                ),
            'openingHoursSpecification' =>
                array(
                    '@type' => 'OpeningHoursSpecification',
                    'dayOfWeek' =>
                        array(
                            0 => 'Monday',
                            1 => 'Tuesday',
                            2 => 'Wednesday',
                            3 => 'Thursday',
                            4 => 'Friday',
                            5 => 'Saturday',
                        ),
                    'opens' => '07:00',
                    'closes' => '19:00',
                )
        );


        $facebook = get_social_links('facebook');
        $instagram = get_social_links('instagram');
        $youtube = get_social_links('youtube');

        if (!empty($facebook)) {
            $localBusiness['sameAs'][] = $facebook;
        }
        if (!empty($instagram)) {
            $localBusiness['sameAs'][] = $instagram;
        }
        if (!empty($youtube)) {
            $localBusiness['sameAs'][] = $youtube;
        }

        echo "<script type=\"application/ld+json\">" . json_encode($localBusiness) . "</script>";

    }

    add_action('after_body_open_tag', 'alt_carregar_schema', 10, 1);
}


?>
