<?php


//Buscar imagens dos veículos
if (!function_exists('buscar_imagem_placeholder')) {
    function buscar_imagem_placeholder($size)
    {

        $url = get_template_directory_uri() . '/assets/images/veiculo-sem-foto.png';

        $image_html = '<img src="' . esc_attr($url) . '" alt="sem imagem de veiculo" />';

        echo $image_html;
    }
}


//Listar todas as caracteristicas do veículos
if (!function_exists('alt_lista_caracteristicas')) {
    function alt_lista_caracteristicas($produto_id)
    {

        $arrCaracteristicas = get_caracteristas_widget();


        $list = '<ul class="slider-grid__info list-unstyled tmpl-slider-grid__info features_list">';

        if (empty($arrCaracteristicas)) {


            $km = get_post_meta($produto_id, 'alt_kilometragem', true);

            if (!empty($km)) {

                $valor = number_format($km, 0, '', '.');
                $valor .= ' km';

                $snZerokm = get_post_meta($produto_id, 'alt_zerokm', true);
                if ($snZerokm == 'on' || $snZerokm == true) {
                    $valor = "Zero KM";
                }


                $list .= '<li><i class="fas fa-tachometer-alt" aria-hidden="true"></i>' . $valor . '</li>';
            } else {
                $list .= '<li><i class="fas fa-tachometer-alt" aria-hidden="true"></i>Consultar</li>';
            }

            $cambio = get_post_meta($produto_id, 'alt_cambio', true);
            if (!empty($cambio)) {

                $cambio = str_replace('Câmbio ', '', $cambio);

                $list .= '<li><i class="fas fa-project-diagram" aria-hidden="true"></i>' . $cambio . '</li>';
            } else {
                $list .= '<li><i class="fas fa-project-diagram" aria-hidden="true"></i>Consultar</li>';
            }


            $tipo = get_ano_veiculo();

            $ano = get_post_meta($produto_id, 'alt_ano_mod', true);

            if ($tipo == 'ano_modelo_fabricacao') {
                $ano = get_post_meta($produto_id, 'alt_ano_mod', true) . '/' . get_post_meta($produto_id, 'alt_ano_fab', true);
            }
            if ($tipo == 'ano_fabricacao') {
                $ano = get_post_meta($produto_id, 'alt_ano_fab', true);
            }

            if (!empty($ano)) {
                $list .= '<li><i class="far fa-calendar-alt" aria-hidden="true"></i> Ano ' . $ano . '</li>';
            } else {
                $list .= '<li><i class="far fa-calendar-alt" aria-hidden="true"></i>Consultar</li>';
            }


            $combustivel = get_post_meta($produto_id, 'alt_combustivel', true);
            if (!empty($combustivel)) {

                $combustivel = mb_strimwidth($combustivel, 0, 18, '.');
                $list .= '<li><i class="fas fa-gas-pump" aria-hidden="true"></i>' . $combustivel . '</li>';
            } else {
                $list .= '<li><i class="fas fa-gas-pump" aria-hidden="true"></i>Consultar</li>';
            }
        } else {


            foreach ($arrCaracteristicas as $caracteristica) {


                $icone = get_icon_caracteristica($caracteristica);
                $titulo = get_title_caracteristica($caracteristica);

                $valor = get_post_meta($produto_id, $caracteristica, true);


                if ($caracteristica == 'alt_modelo') {
                    $valor = alt_get_marca_modelo_tipo($produto_id, 'modelo');
                }

                if ($caracteristica == 'alt_marca') {
                    $valor = alt_get_marca_modelo_tipo($produto_id, 'marca');
                }

                if ($caracteristica == 'alt_portas') {
                    $valor .= " Portas";
                }


                if ($caracteristica == 'alt_combustivel') {
                    $valor = mb_strimwidth($valor, 0, 18, '.');
                }


                if ($caracteristica == 'alt_kilometragem') {


                    $snZerokm = get_post_meta($produto_id, 'alt_zerokm', true);


                    if (empty($valor)) {
                        $valor = 0;
                    }
                    $valor = number_format($valor, '0', '', '.');

                    if ($snZerokm == 'on' || $snZerokm == true) {
                        $valor = "Zero KM";
                    }
                }

                if (!empty($valor)) {
                    $list .= '<li><i title="' . $titulo . '"  class="' . $icone . '" aria-hidden="true"></i>' . $valor . '</li>';
                } else {
                    $list .= '<li><i title="' . $titulo . '" class="' . $icone . '" aria-hidden="true"></i>Consultar</li>';
                }
            }
        };


        $list .= '</ul>';
        return $list;
    }

    add_action('alt_lista_caracteristicas', 'alt_lista_caracteristicas', 10);
}

//Icones das caracteristicas
if (!function_exists('get_icon_caracteristica')) {
    function get_icon_caracteristica($alt_name)
    {
        switch ($alt_name) {
            case 'alt_kilometragem':
                $icon = 'fas fa-tachometer-alt';
                break;
            case 'alt_cambio':
                $icon = 'fas fa-project-diagram';
                break;
            case 'alt_ano_fab':
            case 'alt_ano_mod':
                $icon = 'far fa-calendar-alt';
                break;
            case 'alt_combustivel':
                $icon = 'fas fa-gas-pump';
                break;
            case 'alt_marca':
            case 'alt_modelo':
                $icon = 'fab fa-bandcamp';
                break;
            case 'alt_cambio':
                $icon = 'fa fa-power-off';
                break;
            case 'alt_placa':
                $icon = 'fas fa-list';
                break;
            case 'alt_cor':
                $icon = 'fas fa-brush';
                break;
            case 'alt_portas':
                $icon = 'icon-portas icon-portas-altimus';
                break;
            default:
                $icon = 'fas fa-car';
        }

        return $icon;
    }
}


if (!function_exists('get_title_caracteristica')) {
    function get_title_caracteristica($alt_name)
    {
        switch ($alt_name) {
            case 'alt_kilometragem':
                $title = 'Quilometragem';
                break;
            case 'alt_cambio':
                $title = 'Câmbio';
                break;
            case 'alt_ano_fab':
                $title = 'Ano de Fabricação';
                break;
            case 'alt_ano_mod':
                $title = 'Ano modelo';
                break;
            case 'alt_combustivel':
                $title = 'Combustível';
                break;
            case 'alt_marca':
                $title = 'Marca';
                break;
            case 'alt_modelo':
                $title = 'Modelo';
                break;
            case 'alt_cambio':
                $title = 'Cambio';
                break;
            case 'alt_placa':
                $title = 'Placa';
                break;
            case 'alt_cor':
                $title = 'Cor';
                break;
            case 'alt_portas':
                $title = 'Portas';
                break;
            default:
                $title = 'Versão';
        }

        return $title;
    }
}


if (!function_exists('alt_get_marca_modelo_tipo')) {
    function alt_get_marca_modelo_tipo($produto_id, $cod_produto)
    {

        $arrTerm = get_the_terms($produto_id, $cod_produto, true);

        if (empty($arrTerm)) {
            return 'Não definido';
        }

        return $arrTerm['0']->name;
    }
}


if (!function_exists('alt_get_url_marca_modelo_tipo')) {
    function alt_get_url_marca_modelo_tipo($produto_id, $cod_produto)
    {
        $arrTerm = get_the_terms($produto_id, $cod_produto, true);

        if (empty($arrTerm)) {
            return 'Não definido';
        }


        $link = get_term_link($arrTerm[0]);


        return "<a href=" . $link . " class='label label-default'>" . $arrTerm['0']->name . "</a>";
    }
}


//Retornar se é um destaque
if (!function_exists('get_if_destaque')) {
    function get_if_destaque($produto_id)
    {

        $str_destaque = get_post_meta($produto_id, 'alt_destaque', true);
        $str_repasse = get_post_meta($produto_id, 'alt_repasse', true);


        if (!empty($str_destaque) && get_tarjeta_destaque()) {
            echo '<div class="ribbon_3"> <span class="tax-list">DESTAQUE</span></div>';
            return;
        }
    }

    add_action('get_if_destaque', 'get_if_destaque', 1);
}


//Retorna se é destaque
if (!function_exists('alt_get_if_repasse')) {
    function alt_get_if_repasse($produto_id)
    {


        $str_repasse = get_post_meta($produto_id, 'alt_repasse', true);

        if (!empty($str_repasse) && get_tarjeta_repasse()) {
            echo '<span title="Veículo de repasse">
                    <i class="fa fa-info-circle"></i>
                    Repasse
                </span>';
            return;
        }
    }

    add_action('get_if_destaque', 'get_if_destaque', 1);
}


if (!function_exists('alt_get_video')) {
    function alt_get_video($produto_id, $modelo = 1)
    {


        $str_data = get_post_meta($produto_id, 'alt_youtube', true);

        $height = '400';
        $width = '100%';


        if (empty(trim($str_data)) || $str_data == null) {
            return false;
        }

        if (strpos($str_data, 'embed') !== false) {
            /**
             * Tratar embad
             */
            $local = explode('embed', $str_data);
            $codigo = str_replace('/', '', $local['1']);
            $url = 'http://www.youtube.com/watch?v=' . $codigo;
            return iframe_youtube($url, $width, $height);
        } else {

            if (empty($str_data)) {
                return false;
            }
            return iframe_youtube($str_data, $width, $height);
        }
    }


    function iframe_youtube($url, $width = 560, $height = 315, $fullscreen = true)
    {
        parse_str(parse_url($url, PHP_URL_QUERY), $my_array_of_vars);


        $sizes = 'width="' . $width . '" height="' . $height . '" ';

        if (wp_is_mobile()) {
            $sizes = $sizes = 'width="100%" height="190"';
        }


        $youtube = '<iframe allowtransparency="true" scrolling="no" ' . $sizes . ' src="//www.youtube.com/embed/' . $my_array_of_vars['v'] . '" frameborder="0"' . ($fullscreen ? ' allowfullscreen' : NULL) . '></iframe>';
        return $youtube;
    }
}

if (!function_exists('alt_get_video_thumb')) {
    function alt_get_video_thumb($produto_id)
    {


        $str_data = get_post_meta($produto_id, 'alt_thumb_youtube', true);


        if (empty($str_data)) {

            $url_youtube = get_post_meta($produto_id, 'alt_youtube', true);


            if (strpos($url_youtube, 'embed') !== false) {

                $arrURL = explode('/', $url_youtube);
                $cod = $arrURL[count($arrURL) - 1];
            } else {
                parse_str(parse_url($url_youtube, PHP_URL_QUERY), $my_array_of_vars);
                $cod = $my_array_of_vars['v'] ?? null;
            }


            return "https://img.youtube.com/vi/" . $cod . "/default.jpg";
        }

        return $str_data;
    }
}


if (!function_exists('alt_buscar_ano')) {
    function alt_buscar_ano()
    {


        $cod_produto = 'alt_ano_mod';
        $cod_produto = 'alt_ano_fab';

        $str_data = get_post_meta($produto_id, $cod_produto, true);
    }
}

//Exibir informações de um veículo
if (!function_exists('alt_get_caracteristicas')) {
    function alt_get_caracteristicas($produto_id, $cod_produto, $string = true)
    {

        if (empty($cod_produto)) {
            return;
        }




        $str_data = get_post_meta($produto_id, $cod_produto, true);


        if ($cod_produto == 'alt_destaque') {
            return $str_data;
        }

        if ($cod_produto == 'alt_placa') {
            $str_data = alt_formatarPlaca($str_data);
        }


        if ($cod_produto == 'alt_kilometragem') {

            if (empty($str_data)) {
                $str_data = 'A consultar';
            } else {
                $str_data = number_format($str_data, 0, '', '.');
                if ($string) {
                    $str_data . ' KM';
                }
            }


            $snZerokm = get_post_meta($produto_id, 'alt_zerokm', true);
            if ($snZerokm == 'on' || $snZerokm == true) {
                $str_data = "Zero KM";
            }
        }

        if ($cod_produto == 'alt_ano_mod' || $cod_produto == 'alt_ano_fab') {

            $tipo = get_ano_veiculo();

            if ($tipo == 'ano_modelo') {
                $str_data = get_post_meta($produto_id, 'alt_ano_mod', true);
            }

            if ($tipo == 'ano_fabricacao') {
                $str_data = get_post_meta($produto_id, 'alt_ano_fab', true);
            }
        }

        if ($tipo == 'ano_modelo_fabricacao') {

            $str_data = get_post_meta($produto_id, 'alt_ano_fab', true) . '/' . get_post_meta($produto_id, 'alt_ano_mod', true);
        }



        if ($cod_produto == 'alt_acessorios') {

            if (empty($str_data)) {
                return;
            }


            $volume = [];

            if (gettype($str_data) == 'string') {
                return $str_data;
            }
            foreach ($str_data as $key => $row) {


                if (ocultarAcessorios($row['descricao'])) {
                    unset($str_data[$key]);
                    continue;
                }

                $volume[$key] = $row['descricao'];
            }


            if (!empty($volume) && !empty($str_data)) {
                array_multisort($volume, SORT_ASC, $str_data);
            }
        }

        if ($cod_produto == 'alt_imagens' && empty($str_data)) {
            return [];
        }


        if ($cod_produto == 'alt_zerokm') {

            $snZerokm = get_post_meta($produto_id, 'alt_zerokm', true);

            $str_data = "Não";
            if ($snZerokm == 'on' || $snZerokm == true) {
                $str_data = "Sim";
            }

            return $str_data;
        }

        if (empty($str_data)) {
            return '---';
        }



        if ($cod_produto == 'alt_combustivel') {
            $str_data = mb_strimwidth($str_data, 0, 10, '...');
        }






        return $str_data;
    }
}


if (!function_exists('get_alt_url_imagem_veiculo')) {

    function get_alt_url_imagem_veiculo($veiculo_id, $size, $option)
    {

        $option['alt'] = 'Foto veículo';
        $post_thumbnail_id = get_post_thumbnail_id($veiculo_id);
        if (empty($post_thumbnail_id)) {
            return get_alt_url_placeholder_imagem($size, $option);
        }


        $image = get_the_post_thumbnail_url($veiculo_id, $size, $option);

        if (empty($image)) {
            return get_alt_url_placeholder_imagem($size, $option);
        }

        return $image;
    }
}

if (!function_exists('get_alt_imagem_veiculo')) {

    function get_alt_imagem_veiculo($veiculo_id, $size, $option)
    {

        $option['alt'] = 'Foto veículo';
        $post_thumbnail_id = get_post_thumbnail_id($veiculo_id);
        if (empty($post_thumbnail_id)) {
            return get_alt_placeholder_imagem($size, $option);
        }

        $url_error = get_alt_url_placeholder_imagem('full',[]);
        $option['onerror'] = "this.onerror=null;this.src='".$url_error."';";

        $image = get_the_post_thumbnail($veiculo_id, $size, $option);

        if (empty($image)) {
            return get_alt_placeholder_imagem($size, $option);
        }

        return $image;
    }
}

if (!function_exists('alt_get_imagem_veiculo_box')) {
    function alt_get_imagem_veiculo_box($veiculo_id, $size, $option)
    {


        $url = "sem foto";
        echo "<img src='{$url}' class='img-responsive img-placeholder'/>";
    }
}


if (!function_exists('alt_check_url_imagem_s3')) {


    add_filter('wp_get_attachment_image_src', 'alt_replace_url', 10, 4);

    function alt_replace_url($image, $attachment_id, $size, $icon)
    {
        $url = $image['0'];
        $string_s3 = 'manutecao';
        if (strpos($url, $string_s3) !== false) {

            //Modificar a string
            //Verifiar o tamanho
            //Montar a URL correspondente ao tamanho da imagem no S3
            //Verificar se a imagem é valida
            //rescrever a URL da imagem

        }


        return $image;
    }
}


if (!function_exists('alt_get_url_imagem_veiculo')) {


    function alt_get_url_imagem_veiculo($attachment_id, $size = 'full', $option = [])
    {
        $url_imagem = wp_get_attachment_url($attachment_id);
        //Verificar se a URL é do S3
        //Modificar a URL para capturar o tamanho correto
        //Retornar a URL com o tamanho correrto
        return $url_imagem;
    }
}

if (!function_exists('get_alt_placeholder_imagem')) {
    function get_alt_placeholder_imagem($size, $option)
    {

        $id_image = get_imagem_padrao_veiculo_id();

        if (empty($id_image)) {
            return '<img src="https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/veiculo-sem-foto.jpg" class="img-responsive img-placeholder"/>';
        }

        return wp_get_attachment_image($id_image, $size, null, $option);
    }
}

if (!function_exists('get_alt_url_placeholder_imagem')) {
    function get_alt_url_placeholder_imagem($size, $option)
    {

        $id_image = get_imagem_padrao_veiculo_id();
        if (empty($id_image)) {
            return 'https://cdn-wp-altimus.s3-sa-east-1.amazonaws.com/imagens/veiculo-sem-foto.jpg';
        }
        return wp_get_attachment_image_url($id_image, $size, null, $option);
    }
}


if (!function_exists('get_tag_veiculo')) {
    function get_tag_veiculo($veiculo_id, $retorno = 'html')
    {


        $strTagGeral = get_post_meta($veiculo_id, 'alt_tags', true);
        //garantia, baixa_km, unico_dono
        $arrTags = explode(',', $strTagGeral);


        $html = '';
        $arrRetorno = [];
        foreach ($arrTags as $strTag) :
            if (trim($strTag) == 'unico_dono') {
                $html .= '<img src="' . get_template_directory_uri() . '/assets/img/selos/unico_dono.png" class="tag_img" alt="Único dono"/>';
                $arrRetorno[] = '<img src="' . get_template_directory_uri() . '/assets/img/selos/unico_dono.png" class="tag_img" alt="Único dono"/>';
            }
            if (trim($strTag) == 'baixa_km') {
                $html .= '<img src="' . get_template_directory_uri() . '/assets/img/selos/baixa_km.png" class="tag_img"  alt="Baixa KM"/>';
                $arrRetorno[] = '<img src="' . get_template_directory_uri() . '/assets/img/selos/baixa_km.png" class="tag_img"  alt="Baixa KM"/>';
            }
            if (trim($strTag) == 'garantia') {
                $html .= '<img src="' . get_template_directory_uri() . '/assets/img/selos/garantia_fabrica.png" class="tag_img"  alt="Baixa KM/">';
                $arrRetorno[] = '<img src="' . get_template_directory_uri() . '/assets/img/selos/garantia_fabrica.png" class="tag_img"  alt="Baixa KM/">';
            }
        endforeach;


        if ($retorno == 'array') {
            return $arrRetorno;
        }

        return $html;
    }
}

if (!function_exists('get_marca_thumb')) {

    function get_marca_thumb($post_id)
    {
        $objMarca = get_the_terms($post_id, 'marca');
        $term_id = $objMarca[0]->term_id;

        $url = get_term_meta($term_id, 'marca_img', true);
        if (empty($url)) {
            return null;
        }
        return "<img src=" . $url . " class=\"img-thumb-marca\" width=\"30\"/>";
    }
}

if (!function_exists('get_veiculo_km')) {
    function get_veiculo_km($post_id)
    {

        $str_data = get_post_meta($post_id, 'alt_kilometragem', true);

        if (empty($str_data)) {
            $str_data = 'KM a consultar';
        } else {
            $str_data = number_format($str_data, 0, '', '.');
            $str_data = $str_data . " KM";

        }


        $snZerokm = get_post_meta($post_id, 'alt_zerokm', true);
        if ($snZerokm == 'on' || $snZerokm == true) {
            $str_data = "Zero KM";
        }

        return $str_data;
    }
}

if (!function_exists('get_titulo_produto')) {
    function get_titulo_produto($post_id, $inline = false, $notHtml = false)
    {


        if (get_exibir_titulo_personalizado()) {
            $nome = alt_formatar_titulo($post_id, []);
            if (empty($nome)) {
                return 'Definir padrão do nome nas configurações';
            }
            return $nome;
        }

        $objMarca = get_the_terms($post_id, 'marca');
        $marca = $objMarca[0]->name;

        $objModelo = get_the_terms($post_id, 'modelo');
        $modelo = $objModelo[0]->name;

        $complemento = get_post_meta($post_id, 'alt_modelo_complemento', true);
        $ano = get_post_meta($post_id, 'alt_ano_mod', true);

        if ($notHtml) {
            return "{$marca} - {$modelo} {$complemento} - {$ano}";
        }

        if ($inline) {
            return "<rem class='titulo_veiculo line_1'>{$marca} - {$modelo} {$complemento} - {$ano}</rem>";
        }

        return "<div class='titulo_veiculo line_2'>{$marca} - {$modelo} <br/> <span>{$complemento} - {$ano}</span></div>";
    }
}

if (!function_exists('get_preco_veiculo')) {
    function get_preco_veiculo($post_id)
    {

        $preco_campo = alt_get_caracteristicas($post_id, 'alt_preco');


        if (empty($preco_campo)) {
            return 'A consultar';
        }

        if (intval($preco_campo) == 0) {
            return 'A consultar';
        }

        return 'R$' . number_format($preco_campo, '2', ',', '.');
    }
}

function ocultarAcessorios($tipo)
{

    $tipo = sanitize_title(strtolower($tipo));
    $acessoriosOcultar = [
        sanitize_title('automatizado'),
        sanitize_title('automático'),
        sanitize_title('câmbio automático'),
        sanitize_title('câmbio automatizado'),
        sanitize_title('câmbio manual'),
        sanitize_title('cvt')
    ];

    return in_array($tipo, $acessoriosOcultar);
}

//Formatar place do veículo
if (!function_exists('alt_formatarPlaca')) {
    function alt_formatarPlaca($prPlaca)
    {

        $prMascara = get_formatar_placa();


        if ($prPlaca == NULL || $prPlaca == 'Array' || $prPlaca == 'null') {

            return '';
        }

        if (empty($prMascara)) {
            return $prPlaca;
        }

        $ultimo = substr($prPlaca, -1);
        $primeiro = substr($prPlaca, 0, 1);

        return $primeiro . '*****' . $ultimo;
    }
}

if (!function_exists('alt_get_imagem_veiculo')) {
    function alt_get_imagem_veiculo($size)
    {

        global $product;
        //$html_image = $product ? get_imagem_product($product, $size, ['class' => 'img-responsive', 'alt' => $product->name]) : '';
        $html_image = buscar_imagem_produto($product, $size);
        echo $html_image;
    }

    add_action('alt_get_imagem_veiculo', 'alt_get_imagem_veiculo', 1);
}


if (!function_exists('buscar_imagem_produto')) {
    function buscar_imagem_produto($product, $size)
    {

        if (empty($product->get_image_id())) {
            return wc_placeholder_img($size, array("class" => "img-responsive", "alt" => 'Sem imagem definida'));
        }
        return wp_get_attachment_image($product->get_image_id(), $size, "", array("class" => "img-responsive"));
    }
}

if (!function_exists('get_imagem_product')) {
    function get_imagem_product($product, $size = 'alt_imagem_veiculo_destaque', $attr = array(), $placeholder = true)
    {
        $image = '';
        if ($product->get_image_id()) {
            $image = wp_get_attachment_image($product->get_image_id(), $size, false, $attr);
        } elseif ($product->get_parent_id()) {
            $parent_product = wc_get_product($product->get_parent_id());
            if ($parent_product) {
                $image = $parent_product->get_image($size, $attr, $placeholder);
            }
        }

        if (!$image && $placeholder) {


            $image = buscar_imagem_placeholder($size, $attr);
        }


        //return apply_filters('woocommerce_product_get_image', $image, $product, $size, $attr, $placeholder, $image);
    }
}

if (!function_exists('get_veiculos_mais_recentes')) {
    function get_veiculos_mais_recentes($total_mais_recentes = 5)
    {
        $total_de_veiculos_mais_recentes = $total_mais_recentes ?? get_total_veiculos_mais_recentes();
        $sn_exibir_repasses = get_exibir_repasse_recentes();
        $tipo_veiculos = get_tipo_veiculo_mais_recentes();


        $semDestaque = array(
            'relation' => 'OR',
            array(
                'key' => 'alt_destaque',
                'compare' => 'NOT EXISTS',
            ),
            array(
                'key' => 'alt_destaque',
                'compare' => '!=',
                'value' => 'on'
            ),
            array(
                'key' => 'alt_destaque',
                'compare' => '!=',
                'value' => '1'
            )

        );

        if ($sn_exibir_repasses == 'nao') {
            $semRepasse = array(
                'relation' => 'OR',
                array(
                    'key' => 'alt_repasse',
                    'compare' => '!=',
                    'value' => '1'
                )
            );
        } else {
            $semRepasse = [];
        }


        $arr['meta_query'] = array(
            'relation' => 'AND',
            $semRepasse,
            $semDestaque
        );


        if ($tipo_veiculos != 'todos') {
            $arr['tax_query'] = array(
                'relation' => 'OR',
                array(
                    'taxonomy' => 'tipo',
                    'terms' => $tipo_veiculos,
                    'operator' => 'AND',
                    'field' => 'slug',
                ),
            );
        }


        $arr['post_status'] = 'publish';
        $arr['post_type'] = 'veiculos';
        $arr['posts_per_page'] = $total_de_veiculos_mais_recentes;


        $query = new WP_Query($arr);
        $arrVeiculos = $query->posts;

        return $arrVeiculos;
    }
}

if (!function_exists('get_veiculos_similares')) {
    function get_veiculos_similares($product, $limit = 5)
    {
        $veiculo_id = $product;

        if (isset($product->ID)) {
            $veiculo_id = $product->ID;
        }


        $objTermModelo = get_the_terms($veiculo_id, 'modelo');

        $modelo = null;
        if (!empty($objTermModelo)) {
            $modelo = $objTermModelo[0]->slug;
        }

        $tax_query = array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'modelo',
                'field' => 'slug',
                'terms' => $modelo
            ),
            array(
                'taxonomy' => 'modelo',
                'terms' => 'any'
            )
        );
        $args = array(
            'post__not_in' => array($veiculo_id),
            'post_type' => array('veiculos'),
            'posts_per_page' => $limit,
            'columns' => 4,
            'post_status' => array('publish'),
            'tax_query' => $tax_query,
            'orderby' => 'title',
        );

        $query = new WP_Query($args);
        $arrVeiculosMesmoModelo = $query->posts;
        $total_encontrado = $query->found_posts;


        $total_atrazer = $limit - $total_encontrado;

        if ($total_encontrado == $limit) {
            return $arrVeiculosMesmoModelo;
        }




        $price = get_post_meta($veiculo_id, 'alt_preco', true);

        $percentesValue = $price / 100 * 30;
        $min = $price - $percentesValue;
        $max = $price + $percentesValue;

        $valorProximo = array(
            'relation' => 'OR',
            array(
                'key' => 'alt_preco',
                'value' => array($min, $max),
                'compare' => 'BETWEEN',
                'type' => 'NUMERIC'
            ),

        );


        $veiculos_exibidos[] = $veiculo_id;

        $args = array(
            'post__not_in' => $veiculos_exibidos,
            'post_type' => array('veiculos'),
            'posts_per_page' => $total_atrazer,
            'columns' => $total_atrazer,
            'post_status' => array('publish'),
            'meta_query' => $valorProximo,
            //'tax_query' => $tax_query,
            'orderby' => 'title',
        );


        $query_preco_similar = new WP_Query($args);

        $arrVeiculosSimilares = $query_preco_similar->posts;


        return array_merge($arrVeiculosMesmoModelo, $arrVeiculosSimilares);
    }
}


if (!function_exists('woocommerce_veiculos_similares')) {

    /**
     * Output the related products.
     */
    function woocommerce_veiculos_similares($product = null, $total_exibido = 4)
    {

        $veiculo_id = $product->ID;
        $objTermModelo = get_the_terms($veiculo_id, 'modelo');

        $modelo = null;
        if (!empty($objTermModelo)) {
            $modelo = $objTermModelo[0]->slug;
        }


        $tax_query = array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'modelo',
                'field' => 'slug',
                'terms' => $modelo
            ),
            array(
                'taxonomy' => 'modelo',
                'terms' => 'any'
            )
        );
        $args = array(
            'post__not_in' => array($veiculo_id),
            'post_type' => array('veiculos'),
            'posts_per_page' => $total_exibido,
            'columns' => $total_exibido,
            'post_status' => array('publish'),
            'tax_query' => $tax_query,
            'orderby' => 'title',
        );

        $modelos_similares = new WP_Query($args);

        $total_encontrado = 0;
        $veiculos_exibidos = [];
        if ($modelos_similares->have_posts()) {
            while ($modelos_similares->have_posts()) {


                $modelos_similares->the_post();
                $veiculos_exibidos[] = get_the_ID();

                $objVeiculo = get_post();
                get_template_part('veiculos/archive', 'veiculos-similares', array('data' => $objVeiculo));

                $total_encontrado++;
            }
            wp_reset_postdata();
        }
        wp_reset_query();


        //Prioritaramente trazer veiculos do mesmo modelo dpeois disso, a diferença em veiculos de preço similar
        $total_atrazer = $total_exibido - $total_encontrado;

        if ($total_encontrado >= $total_exibido) {
            return;
        }


        $price = alt_get_caracteristicas($veiculo_id, 'alt_preco');
        $percentesValue = $price / 100 * 30;
        $min = $price - $percentesValue;
        $max = $price + $percentesValue;

        $valorProximo = array(
            'relation' => 'OR',
            array(
                'key' => 'alt_preco',
                'value' => array($min, $max),
                'compare' => 'BETWEEN',
                'type' => 'NUMERIC'
            ),

        );


        $veiculos_exibidos[] = $veiculo_id;

        $args = array(
            'post__not_in' => $veiculos_exibidos,
            'post_type' => array('veiculos'),
            'posts_per_page' => $total_atrazer,
            'columns' => $total_atrazer,
            'post_status' => array('publish'),
            'meta_query' => $valorProximo,
            //'tax_query' => $tax_query,
            'orderby' => 'title',
        );


        $query_preco_similar = new WP_Query($args);
        if ($query_preco_similar->have_posts()) {
            while ($query_preco_similar->have_posts()) {


                $query_preco_similar->the_post();
                $objVeiculo = get_post();
                get_template_part('veiculos/archive', 'veiculos-similares', array('data' => $objVeiculo));
                $total_encontrado++;
            }
            wp_reset_postdata();
        }
        wp_reset_query();


        $shop_page_url = alt_get_url_estoque();

        if ($total_encontrado < $total_exibido) {

            echo "<div class='col-md-12 text-center'>
                    <a href='$shop_page_url' class='btn btn-primary mt-5'>Estoque completo</a>
                   </div>";
        }
    }
}


if (!function_exists('alt_get_theme')) {

    function alt_get_theme()
    {
        $theme_selected = 1;
        $theme = wp_get_theme();
        if ($theme->get('TextDomain') == 'altimus-2') {
            $theme_selected = 2;
        };


        return $theme_selected;
    }
}


if (!function_exists('alt_get_tags')) {
    function alt_get_tags($produto_id)
    {
        $str_tags = get_post_meta($produto_id, 'alt_tags', true);

        if (!empty($str_tags)) {
            $tags = explode(',', $str_tags);

            $str = '<div class="listagem_tags">';
            foreach ($tags as $tag) {
                $str .= '<div class="label_icon m-premium pull-right b-items__cars-one-img-type">' . $tag . '</div>';
            }
            $str .= '</div>';

            return $str;
        }
    }
}


if (!function_exists('alt_get_mais_recentes')) {
    function alt_get_mais_recentes($total_de_veiculos_mais_recentes = 5, $sn_exibir_repasses = false, $tipo_veiculos = 'todos')
    {


        $semDestaque = array(
            'relation' => 'OR',
            array(
                'key' => 'alt_destaque',
                'compare' => 'NOT EXISTS',
            ),
            array(
                'key' => 'alt_destaque',
                'compare' => '!=',
                'value' => 'on'
            ),
            array(
                'key' => 'alt_destaque',
                'compare' => '!=',
                'value' => '1'
            )

        );

        if ($sn_exibir_repasses == 'nao') {
            $semRepasse = array(
                'relation' => 'OR',
                array(
                    'key' => 'alt_repasse',
                    'compare' => '!=',
                    'value' => '1'
                )
            );
        } else {
            $semRepasse = [];
        }


        $arr['meta_query'] = array(
            'relation' => 'AND',
            $semRepasse,
            $semDestaque
        );


        if ($tipo_veiculos != 'todos') {
            $arr['tax_query'] = array(
                'relation' => 'OR',
                array(
                    'taxonomy' => 'tipo',
                    'terms' => $tipo_veiculos,
                    'operator' => 'AND',
                    'field' => 'slug',
                ),
            );
        }


        $arr['post_status'] = 'publish';
        $arr['post_type'] = 'veiculos';
        $arr['posts_per_page'] = $total_de_veiculos_mais_recentes;


        $query = new WP_Query($arr);
        $arrVeiculos = $query->posts;

        return $arrVeiculos;
    }
}


//Menor preço
if (!function_exists('alt_get_min_price')) {
    function alt_get_min_price()
    {

        global $wpdb;

        $sql = "

    SELECT  MIN( meta_value+0 ) as minprice

    FROM {$wpdb->posts} 

    INNER JOIN {$wpdb->term_relationships} ON ({$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id)

    INNER JOIN {$wpdb->postmeta} ON ({$wpdb->posts}.ID = {$wpdb->postmeta}.post_id) 

    WHERE  

       {$wpdb->posts}.post_type = 'veiculos' 

    AND {$wpdb->posts}.post_status = 'publish' 

    AND {$wpdb->postmeta}.meta_key = 'alt_preco'";

        $valor = $wpdb->get_var($wpdb->prepare($sql, null));
        return $valor ?? 0;
    }
}

//Maior preco
if (!function_exists('alt_get_max_price')) {
    function alt_get_max_price()
    {

        global $wpdb;

        $sql = "

    SELECT  max( meta_value+0 ) as minprice

    FROM {$wpdb->posts} 

    INNER JOIN {$wpdb->term_relationships} ON ({$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id)

    INNER JOIN {$wpdb->postmeta} ON ({$wpdb->posts}.ID = {$wpdb->postmeta}.post_id) 

    WHERE  

       {$wpdb->posts}.post_type = 'veiculos' 

    AND {$wpdb->posts}.post_status = 'publish' 

    AND {$wpdb->postmeta}.meta_key = 'alt_preco'";


        $valor = $wpdb->get_var($wpdb->prepare($sql, []));
        return $valor ?? 0;
    }
}


//Menor ano
if (!function_exists('alt_get_min_year')) {
    function alt_get_min_year()
    {

        global $wpdb;

        $sql = "

    SELECT  MIN( meta_value+0 ) as minprice

    FROM {$wpdb->posts} 

    INNER JOIN {$wpdb->term_relationships} ON ({$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id)

    INNER JOIN {$wpdb->postmeta} ON ({$wpdb->posts}.ID = {$wpdb->postmeta}.post_id) 

    WHERE  

       {$wpdb->posts}.post_type = 'veiculos' 

    AND {$wpdb->posts}.post_status = 'publish' 

    AND {$wpdb->postmeta}.meta_key = 'alt_ano_mod'";

        $valor = $wpdb->get_var($wpdb->prepare($sql, null));
        return $valor ?? 0;
    }
}


//Maior ano
if (!function_exists('alt_get_max_year')) {
    function alt_get_max_year()
    {

        global $wpdb;

        $sql = "

    SELECT  max( meta_value+0 ) as minprice

    FROM {$wpdb->posts} 

    INNER JOIN {$wpdb->term_relationships} ON ({$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id)

    INNER JOIN {$wpdb->postmeta} ON ({$wpdb->posts}.ID = {$wpdb->postmeta}.post_id) 

    WHERE  

       {$wpdb->posts}.post_type = 'veiculos' 

    AND {$wpdb->posts}.post_status = 'publish' 

    AND {$wpdb->postmeta}.meta_key = 'alt_ano_mod'";


        $valor = $wpdb->get_var($wpdb->prepare($sql, []));
        return $valor ?? 0;
    }
}


if (!function_exists('alt_get_url_venda')) {
    function alt_get_url_venda()
    {
        $name = get_pagina_padrao_estoque();

        $home = get_page_by_title($name);
        return get_permalink($home);
    }
}

if (!function_exists('alt_get_url_estoque')) {
    function alt_get_url_estoque()
    {
        $name = get_pagina_padrao_estoque();

        $home = get_page_by_title($name);
        return get_permalink($home);
    }
}


if (!function_exists('alt_get_url_venda')) {
    function alt_get_url_venda()
    {

        $home = get_page_by_title('vendas');
        if (empty($home)) {
            return;
        }
        return get_permalink($home);
    }
}




if (!function_exists('alt_get_url_contato')) {
    function alt_get_url_contato()
    {
        $name = get_page_by_path('contato');

        if (empty($name)) {
            return alt_get_url_estoque();
        }
        return get_permalink($name);
    }
}

if (!function_exists('alt_get_url_blog')) {
    function alt_get_url_blog()
    {
        if ('page' == get_option('show_on_front')) {
            if (get_option('page_for_posts')) {
                echo esc_url(get_permalink(get_option('page_for_posts')));
            } else {
                echo esc_url(home_url('/?post_type=post'));
            }
        } else {
            echo esc_url(home_url('/'));
        }
    }
}
