<?php

add_action('cmb2_admin_init', 'cmb2_veiculos_metaboxes', 1);
/**
 * Define the metabox and field configurations.
 */
function cmb2_veiculos_metaboxes()
{


    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    $cmb = new_cmb2_box(array(
        'id' => 'dados_do_veiculo',
        'title' => __('Dados do veiculo', 'cmb2'),
        'object_types' => array('veiculos'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => WP_REST_Server::ALLMETHODS,
        //'show_in_rest' => WP_REST_Server::READABLE,
    ));

    $cmb->add_field(array(
            'name' => __('Modelo complemento', 'cmb2'),
            'desc' => __('Informe o modelo complemento do veículo', 'cmb2'),
            'id' => $prefix . 'modelo_complemento',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats'
        )
    );

    $cmb->add_field(array(
            'name' => __('kilometragem', 'cmb2'),
            'desc' => __('Informe a kilometragem do veículo', 'cmb2'),
            'id' => $prefix . 'kilometragem',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats'
        )
    );

    $cmb->add_field(array(
            'name' => __('Ano modelo', 'cmb2'),
            'desc' => __('Informe a Ano/modelo do veículo', 'cmb2'),
            'id' => $prefix . 'ano_mod',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats'
        )
    );

    $cmb->add_field(array(
            'name' => 'Tags',
            'desc' => 'Tags separadas com virgula - Recomendado utilizar somente 1 tag',
            'id' => $prefix . 'tags',
            'type' => 'text',
        )
    );

    $cmb->add_field(array(
            'name' => __('Destaque', 'cmb2'),
            'desc' => __('Marcar como destaque', 'cmb2'),
            'id' => $prefix . 'destaque',
            'type' => 'checkbox',
            'default' => false,

        )
    );

    $cmb->add_field(array(
            'name' => 'Carro Zero (novo)',
            'desc' => 'Definir que o carro é um carro Zero KM ou classificado como novo',
            'id' => $prefix . 'zerokm',
            'type' => 'checkbox',
            'default' => false,

        )
    );


    $cmb->add_field(array(
            'name' => 'Destaque da semana',
            'desc' => 'Definir um veículo como destaque da semana',
            'id' => $prefix . 'destaque_semana',
            'type' => 'checkbox',
            'default' => false,

        )
    );

    $cmb->add_field(array(
            'name' => __('Repasse', 'cmb2'),
            'desc' => __('Veículo para repasse', 'cmb2'),
            'id' => $prefix . 'repasse',
            'type' => 'checkbox',
            'default' => false,

        )
    );

    $cmb->add_field(array(
            'name' => __('Cambio', 'cmb2'),
            'desc' => __('Informe a tipo de câmbio', 'cmb2'),
            'id' => $prefix . 'cambio',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',

        )
    );


    $cmb->add_field(array(
            'name' => 'Preço',
            'desc' => 'Informe o preço do veículo',
            'id' => $prefix . 'preco',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats'
        )
    );


    $cmb->add_field(array(
            'name' => __('Localizacao', 'cmb2'),
            'desc' => __('Informe a localização do veículo', 'cmb2'),
            'id' => $prefix . 'localizacao',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',

        )
    );

    $cmb->add_field(array(
            'name' => __('URL Youtube', 'cmb2'),
            'desc' => __('Informe url do vídeo no youtube', 'cmb2'),
            'id' => $prefix . 'youtube',
            'type' => 'text_url',


        )
    );

    $cmb->add_field(array(
            'name' => 'Thumb Youtube',
            'desc' => 'Selecione um thumb (Tamanho 146x109)',
            'id' => $prefix . 'thumb_youtube',
            'type' => 'file',
            'options' => array(
                'url' => false, // Hide the text input for the url
            ),
            'text' => array(
                'add_upload_file_text' => 'Selecione' // Change upload button text. Default: "Add or Upload File"
            )

        )
    );

    $cmb->add_field(array(
            'name' => __('ano de fabricacao', 'cmb2'),
            'desc' => __('Informe a ano de fabricacao do veículo', 'cmb2'),
            'id' => $prefix . 'ano_fab',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',

        )
    );

    $cmb->add_field(array(
            'name' => 'Potência',
            'desc' => '',
            'id' => $prefix . 'potencia',
            'type' => 'text',
            'show_on_cb' => '',

        )
    );

    $cmb->add_field(array(
            'name' => __('Combustivel', 'cmb2'),
            'desc' => __('Informe a tipo de combustivel', 'cmb2'),
            'id' => $prefix . 'combustivel',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
        )
    );

    $cmb->add_field(array(
            'name' => __('Portas', 'cmb2'),
            'desc' => __('Quantidade de portas', 'cmb2'),
            'id' => $prefix . 'portas',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
        )
    );

    $cmb->add_field(array(
            'name' => __('Cor', 'cmb2'),
            'desc' => '',
            'id' => $prefix . 'cor',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
        )
    );

    $cmb->add_field(array(
            'name' => __('Placa', 'cmb2'),
            'desc' => '',
            'id' => $prefix . 'placa',
            'type' => 'text',
            'show_on_cb' => 'validar_placa_do_veiculo',

        )
    );

    $group_field_id = $cmb->add_field(array(
        'id' => $prefix . 'acessorios',
        'type' => 'group',
        'description' => 'Acessórios',
        'options' => array(
            'group_title' => 'Acessório', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar acessórios',
            'remove_button' => 'Remover acessório',
            'sortable' => true,
            'closed' => true, // true to have the groups closed by default
            // 'remove_confirm' => esc_html__( 'Are you sure you want to remove?', 'cmb2' ), // Performs confirmation before removing group.
        ),
    ));

    $cmb->add_group_field($group_field_id, array(
        'name' => 'Decrição',
        'id' => 'descricao',
        'type' => 'text',
        // 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
    ));

    $cmb->add_field(array(
        'name' => 'Imagens',
        'desc' => 'Selecione as imagens do veículo',
        'id' => 'alt_imagens',
        'type' => 'file_list',
        'preview_size' => array(150, 150), // Default: array( 50, 50 )
        // 'query_args' => array( 'type' => 'image' ), // Only images attachment
        // Optional, override default text strings
        'text' => array(
            'add_upload_files_text' => 'Selecione as imagens', // default: "Add or Upload Files"
            'remove_image_text' => 'Remover imagem', // default: "Remove Image"
            //'file_text' => 'Arquivo', // default: "File:"
            //'file_download_text' => 'Replacement', // default: "Download"
            //'remove_text' => 'Replacement', // default: "Remove"
        ),
    ));

    $cmb->add_field(array(
            'name' => 'Imagem destaque',
            'desc' => 'Imagem de destaque',
            'id' => $prefix . 'imagem_destaque',
            'type' => 'text_url',


        )
    );


}





