<?php

add_action('cmb2_init', 'alt_metabox_endereco');
add_action('cmb2_init', 'alt_metabox_filial_contato');

/**
 * Define the metabox and field configurations.
 */
function alt_metabox_endereco()
{
    $estados = array(
        'AC' => 'Acre',
        'AL' => 'Alagoas',
        'AP' => 'Amapá',
        'AM' => 'Amazonas',
        'BA' => 'Bahia',
        'CE' => 'Ceará',
        'DF' => 'Distrito Federal',
        'ES' => 'Espirito Santo',
        'GO' => 'Goiás',
        'MA' => 'Maranhão',
        'MS' => 'Mato Grosso do Sul',
        'MT' => 'Mato Grosso',
        'MG' => 'Minas Gerais',
        'PA' => 'Pará',
        'PB' => 'Paraíba',
        'PR' => 'Paraná',
        'PE' => 'Pernambuco',
        'PI' => 'Piauí',
        'RJ' => 'Rio de Janeiro',
        'RN' => 'Rio Grande do Norte',
        'RS' => 'Rio Grande do Sul',
        'RO' => 'Rondônia',
        'RR' => 'Roraima',
        'SC' => 'Santa Catarina',
        'SP' => 'São Paulo',
        'SE' => 'Sergipe',
        'TO' => 'Tocantins',
    );
    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_dados',
        'title' => 'Informações',
        'object_types' => array('filiais',), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,

    ));


    $cmb->add_field(array(
        'name' => 'CNPJ',
        'desc' => 'Ex: XX.XXX.XXX/XXXX-XX',
        'id' => $prefix . 'cnpj_principal',
        'default' => '',
        'type' => 'text',

    ));
    $cmb->add_field(array(
        'name' => 'Endereço',
        'desc' => 'Ex: R.João Pessoa 2008 - Sala 01',
        'default' => '',
        'id' => $prefix . 'endereco_principal',
        'type' => 'text',
    ));
    $cmb->add_field(array(
        'name' => 'Cidade',
        'desc' => 'Ex: Blumenau',
        'default' => '',
        'id' => $prefix . 'cidade_principal',
        'type' => 'text',
    ));
    $cmb->add_field(array(
        'name' => 'Estado',
        'desc' => '',
        'default' => '',
        'id' => $prefix . 'estado_principal',
        'type' => 'select',
        'default' => 'SC',
        'options' => $estados,
    ));

    $cmb->add_field(array(
        'name' => 'CEP',
        'desc' => 'Somente números Ex: 89040400',
        'default' => '',
        'id' => $prefix . 'cep',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'URL Google Maps',
        'desc' => 'Acessar o Google maps para obter a URL. Ex: https://goo.gl/maps/BS6nTdNqkBQeoQbJ7',
        'default' => '',
        'id' => $prefix . 'google_maps',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'Telefone fixo',
        'desc' => 'Utilizar apenas números. exemplo 4788888888',
        'id' => $prefix . 'telefone_principal',
        'default' => '',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'Whatsapp Principal',
        'desc' => 'Utilizar apenas números. exemplo 4788888888',
        'id' => $prefix . 'whatsapp_principal',
        'default' => '',
        'type' => 'text',
    ));

    $cmb->add_field(array(
        'name' => 'E-mail principal',
        'desc' => '',
        'id' => $prefix . 'email_principal',
        'default' => '',
        'type' => 'text',
    ));


    $cmb->add_field(array(
            'name' => 'Matriz',
            'desc' => 'É uma matriz?',
            'id' => $prefix . 'matriz',
            'type' => 'checkbox',
            'default' => false,
            'show_on_cb' => true,

        )
    );

    $cmb->add_field(array(
            'name' => 'Script GoogleMaps',
            'desc' => '<a target="_blank" href="https://www.google.com.br/maps">Obter link</a>',
            'id' => $prefix . 'filial_mapa',
            'type' => 'wysiwyg',
        )
    );


    $cmb->add_field(array(
            'name' => 'Horário de funcionamento',
            'desc' => '',
            'id' => $prefix . 'horario_funcionamento',
            'type' => 'textarea',
        )
    );


    $cmb->add_field(array(
            'name' => 'Chave Altimus',
            'desc' => 'Chave fornecida pelo sistema Altimus para integração de veículos',
            'id' => $prefix . 'filiais_chave_altimus',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats'
        )
    );


}


function alt_metabox_filial_contato()
{
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_contato',
        'title' => 'Contatos da loja',
        'object_types' => array('filiais'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));


    $group_field_id = $cmb->add_field(array(
        'id' => $prefix . 'filial_contatos',
        'type' => 'group',
        'title' => 'Contatos',
        'description' => '',
        //'repeatable'  => false, // use false if you want non-repeatable group
        'options' => array(
            'group_title' => 'Contatos {#}', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar contatos',
            'remove_button' => 'Remover contatos',
            'sortable' => true,
            'closed' => true, // true to have the groups closed by default
            'remove_confirm' => 'Tem certeza que deseja remover esse contato?', // Performs confirmation before removing group.
        ),
    ));

    // Id's for group's fields only need to be unique for the group. Prefix is not needed.
    $cmb->add_group_field($group_field_id, array(
        'name' => 'Tipo',
        'id' => 'icone',
        'type' => 'select',
        'default' => 'telefone',
        'options' => array(
            'fab fa-whatsapp' => 'Whatsapp',
            'fa fa-phone' => 'Telefone',
            'fa fa-envelope' => 'E-mail',
            'fa fa-map-marked'=>'Mapa',
            'fa fa-car'=>'Carro',
        ),
    ));
    $cmb->add_group_field($group_field_id, array(
        'name' => 'Valor',
        'desc' => 'URL de ação',
        'id' => 'url_valor',
        'type' => 'text',
        'default'=>'#'
    ));



    $cmb->add_group_field($group_field_id, array(
        'name' => 'Titulo',
        'id' => 'titulo',
        'type' => 'text',
        // 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
    ));

    $cmb->add_group_field($group_field_id, array(
        'name' => 'Subtitulo',
        'id' => 'subtitulo',
        'type' => 'text',
        // 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
    ));
}


function alt_get_filiais_matriz()
{

    $matriz = array(
        'relation' => 'AND',
        array(
            'key' => 'alt_matriz',
            'compare' => '=',
            'value' => 'on',
        )
    );


    $args = array(
        'post_type' => 'filiais',
        'post_status' => array('publish'),
        'orderBy' => 'date',
        'order' => 'asc',
        'meta_query' => $matriz
    );


    $query = new WP_Query($args);

    $arrFiliais = $query->posts;

    $arrRetorno = [];

    foreach ($arrFiliais as $filial) {

        $data = alt_formatar_filial($filial);
        $arrRetorno[] = $data;
    }

    wp_reset_query();

    return $arrRetorno;
}

function alt_formatar_filial($filial)
{


    $id_filial = $filial->ID;


    $data['nome'] = $filial->post_title;
    $data['cnpj'] = get_post_meta($id_filial, 'alt_cnpj_principal', true);
    $data['telefone'] = get_post_meta($id_filial, 'alt_telefone_principal', true);
    $data['email'] = get_post_meta($id_filial, 'alt_email_principal', true);
    $data['whatsapp'] = get_post_meta($id_filial, 'alt_whatsapp_principal', true);
    $data['horarios'] = get_post_meta($id_filial, 'alt_horario_funcionamento', true);
    $data['matriz'] = get_post_meta($id_filial, 'alt_matriz', true);
    $data['endereco'] = get_post_meta($id_filial, 'alt_endereco_principal', true);
    $data['cidade'] = get_post_meta($id_filial, 'alt_cidade_principal', true);
    $data['estado'] = get_post_meta($id_filial, 'alt_estado_principal', true);
    $data['cep'] = get_post_meta($id_filial, 'alt_cep', true);


    $data['nome_principal'] = $data['nome'];
    $data['cnpj_principal'] = $data['cnpj'];
    $data['telefone_principal'] = $data['telefone'];
    $data['email_principal'] = $data['email'];
    $data['numero_whatsapp'] = $data['whatsapp'];


    $data['endereco_principal'] = $data['endereco'];
    $data['cidade_principal'] = $data['cidade'];
    $data['estado_principal'] = $data['estado'];


    if (!empty($data['telefone'])) {
        $data['url_telefone'] = 'tel:' . $data['telefone'];

        $data['telefone'] = alt_mascara('(##) ####-#####', $data['telefone']);


    }

    if (!empty($data['email'])) {
        $data['url_email'] = 'mailto:' . $data['email'];
    }

    if (!empty($data['whatsapp'])) {
        $data['url_whatsapp'] = 'https://wa.me/55' . $data['whatsapp'];

        if(strlen($data['whatsapp'])==11){
            $data['whatsapp'] = alt_mascara('(##) #####-####', $data['whatsapp']);
        }else{
            $data['whatsapp'] = alt_mascara('(##) ####-#####', $data['whatsapp']);
        }


    }


    $data['endereco_completo'] = $data['endereco'] . ' - ' . $data['cidade'] . ' - ' . $data['estado'];

    $data['url_mapa'] = get_post_meta($id_filial, 'alt_google_maps', true);


    $data['script_mapa'] = get_post_meta($id_filial, 'alt_filial_mapa', true);


    $data['outros_contatos'] =  get_post_meta($id_filial, 'alt_filial_contatos', true);



    return $data;

}

function alt_get_filiais()
{

    $args = array(
        'post_type' => 'filiais',
        'post_status' => array('publish'),
        'orderBy' => 'date',
        'order' => 'asc'
    );

    $query = new WP_Query($args);

    $arrFiliais = $query->posts;


    $arrRetorno = [];

    foreach ($arrFiliais as $filial) {


        $data = alt_formatar_filial($filial);
        $arrRetorno[] = $data;
    }


    return $arrRetorno;
}

