<?php
function alt_post_banners()
{

    //add_image_size('alt-banners', 1920, 830, true);

    $args_cursos_post_type = array(
        'labels' => array('name' => 'Banners', 'add_new' => 'Adicionar banner', 'add_new_item' => 'Titulo do banner', 'edit_item' => 'Titulo do banner'),
        'public' => true,
        'menu_icon' => 'dashicons-welcome-widgets-menus',
        'supports' => array('title', 'editor'),
        'show_ui' => true,
        'query_var' => true,
        'rewrite' => ['slug' => 'banners', 'with_front' => true],
        'publicly_queryable' => true,
        'register_meta_box_cb' => '');
    register_post_type('banners', $args_cursos_post_type);
}

add_action('init', 'alt_post_banners');


function api_banners_get()
{

    $args = array(
        'post_type' => 'banners',
        'post_status' => array('publish')
    );

    $query = new WP_Query($args);
    $banners = $query->posts;

    $return = [];
    foreach ($banners as $banner) {


        $dataInfo['id'] = $banner->ID;
        $dataInfo['post_title'] = $banner->post_title;
        $dataInfo['post_content'] = $banner->post_content;
        $dataInfo['guid'] = $banner->guid;


        $dataInfo['alt_banner_imagem'] = get_post_meta($banner->ID, 'alt_banner_imagem', true) ?? null;
        $dataInfo['alt_banner_imagem_mobile'] = get_post_meta($banner->ID, 'alt_banner_imagem_mobile', true) ?? null;
        $dataInfo['alt_banner_nova_guia'] = get_post_meta($banner->ID, 'alt_banner_nova_guia', true) ?? null;
        $dataInfo['alt_banner_link'] = get_post_meta($banner->ID, 'alt_banner_link', true) ?? null;
        $return[] = $dataInfo;
    }


    return rest_ensure_response($return);
}

function api_banners_post($request)
{
    $user = wp_get_current_user();


    try {

        //Validar informações obrigatórias

        if (!isset($user->data->ID)) {
            throw new \Exception('Usuário sem permissão', 403);
        }


        if (!isset($request['alt_banner_imagem']) || empty($request['alt_banner_imagem'])) {
            throw new \Exception('Nenhuma imagem desktop selecionada', 403);
        }


        $response = alt_editar_incluir_banner($request);

    } catch (\Exception $e) {

        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);
    }


    return rest_ensure_response($response);
}

function alt_editar_incluir_banner($request)
{

    $nome = $request['post_title'] ?? null;
    $description = $request['description'] ?? null;
    $id = $request['id'] ?? null;
    $alt_banner_imagem = $request['alt_banner_imagem'] ?? null;
    $alt_banner_imagem_mobile = $request['alt_banner_imagem_mobile'] ?? null;
    $alt_banner_nova_guia = $request['alt_banner_nova_guia'] ?? 'nao';
    $alt_banner_link = $request['alt_banner_link'] ?? null;


    $my_post = array(
        'ID' => $id,
        'post_title' => wp_strip_all_tags($nome),
        'post_content' => $description,
        'post_type' => 'banners',
        'post_status' => 'publish',
        'post_author' => get_current_user_id()
    );


    if (empty($id)) {
        $post_id = wp_insert_post($my_post);
    } else {
        $post_id = $id;
        wp_update_post($my_post);
    }


    if (!add_post_meta($post_id, 'alt_banner_imagem', $alt_banner_imagem, true)) {
        update_post_meta($post_id, 'alt_banner_imagem', $alt_banner_imagem);
    }

    if (!add_post_meta($post_id, 'alt_banner_imagem_mobile', $alt_banner_imagem_mobile, true)) {
        update_post_meta($post_id, 'alt_banner_imagem_mobile', $alt_banner_imagem_mobile);
    }

    if (!add_post_meta($post_id, 'alt_banner_nova_guia', $alt_banner_nova_guia, true)) {
        update_post_meta($post_id, 'alt_banner_nova_guia', $alt_banner_nova_guia);
    }

    if (!add_post_meta($post_id, 'alt_banner_link', $alt_banner_link, true)) {
        update_post_meta($post_id, 'alt_banner_link', $alt_banner_link);
    }


    $response = [
        'msg' => 'Adicionado com sucesso',
        'id' => $post_id,

    ];

    return $response;


}



function api_banners_delete($request)
{

    $user = wp_get_current_user();

    try {

        //Validar informações obrigatórias
        if (empty($user)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        $data = $request->get_params();
        if (isset($data['id'])) {
            $post_id = $data['id'];
        }else{
            throw new \Exception('Nenhum ID informado');
        }



        $response = alt_delete_banners($post_id);

    } catch (\Exception $e) {


        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);


    }


    return rest_ensure_response($response);


}


if (!function_exists('alt_delete_banners')) {
    function alt_delete_banners($post_id)
    {


        $post = get_post($post_id);

        if (empty($post)) {
            return ['msg' => 'Banner não encontrado'];
        }

        wp_delete_attachment($post_id);


        if (empty($post)) {
            return ['msg' => 'Nenhum veiculo localizado'];
        };

        wp_delete_post($post_id, true);

        return ['msg' => 'Removido com sucesso'];
    }
}

function registrar_api_rest_banners()
{
    register_rest_route(
        'api/v1',
        '/banners',
        [
            'methods' => WP_REST_Server::READABLE,
            'callback' => 'api_banners_get'
        ]
    );

    register_rest_route(
        'api/v1',
        '/banners',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_banners_post'
        ]
    );
    register_rest_route(
        'api/v1',
        '/banners/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_banners_post'
        ]
    );
    register_rest_route(
        'api/v1',
        '/banners/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::DELETABLE,
            'callback' => 'api_banners_delete'
        ]
    );

}

add_action('rest_api_init', 'registrar_api_rest_banners');

