var app = angular.module('financiamentoApp', ['ui.utils.masks']);
app.controller('financiamentoController', function ($scope, $http, $httpParamSerializerJQLike) {

    $scope.objForm = {
        entrada: null,
        valor: null
    };

    $scope.entrada = null;
    $scope.valor_financiado = null;
    $scope.arrPrazos = [];
    $scope.arrBancos = [];
    $scope.carregando = false;
    $scope.exibir_tabela = false;


    $scope.calcular = function () {

        $scope.carregando = true;

        var dataInfo = $httpParamSerializerJQLike($scope.objForm);


        var url_base = '/wp-admin/admin-ajax.php?action=buscar_financiamento';
        url = url_base.concat('&' + dataInfo);

        $http.get(url).then(
            function (response) {

                $scope.arrPrazos = response.data.prazos;
                $scope.arrBancos = response.data.bancos;
                $scope.entrada = response.data.entrada;
                $scope.valor_financiado = response.data.valor_financiado;
            },
            function (erros) {
                console.log(erros)
            }
        ).finally((response) => {
            $scope.carregando = false;
            $scope.exibir_tabela = true;
        });
    };


});
