<?php


if (!function_exists('get_preco_veiculo')) {
    function get_preco_veiculo($product)
    {

        if ($product->get_price() == 0) {
            return '<span class="preco_a_consultar">Consultar preço</span>';
        }

        return 'R$ ' . number_format($product->get_price(), '2', ',', '.');
    }
}


if (!function_exists('alterar_preco')) {
    add_filter('woocommerce_get_price_html', 'alterar_preco', 10, 2);
    function alterar_preco($price, $product)
    {
        if ($product->get_price() == 0) {
            return '<span class="preco_a_consultar">Consultar Preço</span>';
        };
        return $price;
    }

}

//Exibir titulo
if (!function_exists('get_titulo')) {
    function get_titulo($arr)
    {

        $title = mb_strimwidth($arr['content'], 0, $arr['size'], '...');


        $title = str_replace('- ...', '...', $title);
        $title = str_replace('-...', '...', $title);
        $title = str_replace('/...', '...', $title);


        echo '<a href="' . get_permalink() . '"><h2 class="' . esc_attr(apply_filters('woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title')) . '">' . $title . '</h2></a>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    add_action('get_titulo', 'get_titulo', 10);
}

if (!function_exists('alt_exibir_titulo_lista')) {

    /**
     * Show the product title in the product loop. By default this is an H2.
     */
    function alt_exibir_titulo_lista($size = 35)
    {

        $title = substr(get_the_title(), 0, $size);
        echo '<a href="' . get_permalink() . '"><h2 class="' . esc_attr(apply_filters('woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title')) . '">' . $title . '</h2></a>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    add_action('alt_exibir_titulo_lista', 'alt_exibir_titulo_lista', 10);

}

//Exibir titulo
if (!function_exists('alt_get_title_product')) {

    /**
     * Show the product title in the product loop. By default this is an H2.
     */
    function alt_get_title_product()
    {
        echo '<h5 class="' . esc_attr(apply_filters('woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title')) . '">' . get_the_title() . '</h2>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    add_action('alt_get_title_product', 'alt_get_title_product', 10);

}


//Exibir link do produto
if (!function_exists('alt_link_to_product')) {
    /**
     * Insert the opening anchor tag for products in the loop.
     */
    function alt_link_to_product()
    {
        global $product;
        $link = apply_filters('woocommerce_loop_product_link', get_the_permalink(), $product);
        echo esc_url($link);
    }

    add_action('alt_link_to_product', 'alt_link_to_product', 10);
}


//Cabeçalho do facebook graph
if (!function_exists('insert_fb_in_head')) {

    //Adicionar Open Graph
    function add_opengraph_doctype($output)
    {
        return $output . ' xmlns:og="http://opengraphprotocol.org/schema/" xmlns:fb="http://www.facebook.com/2008/fbml"';
    }

    apply_filters('language_attributes', 'add_opengraph_doctype');
    /**
     * Modificar open Graph
     *
     */
    function insert_fb_in_head()
    {
        global $post;
        if (!is_singular()) //if it is not a post or a page
            return;
        echo '<meta property="og:title" content="' . get_the_title() . '"/>';
        echo '<meta property="og:type" content="article"/>';
        echo '<meta property="og:url" content="' . get_permalink() . '"/>';
        echo '<meta property="og:site_name" content="' . get_site_url() . '"/>';
        if (!has_post_thumbnail($post->ID)) { //the post does not have featured image, use a default image
            $default_image = "http://example.com/image.jpg"; //replace this with a default image on your server or an image in your media library
            echo '<meta property="og:image" content="' . $default_image . '"/>';
        } else {
            $thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'medium');
            echo '<meta property="og:image" content="' . esc_attr($thumbnail_src[0]) . '"/>';
        }
        echo "";
    }

    /**
     * Adicionar opengraph nas páginas
     */
    add_action('wp_head', 'insert_fb_in_head', 5);

}


/**
 * Adicionar avaliação
 */
if (!function_exists('insert_review_product')) {

    function insert_view_product()
    {
        global $product;
        wpb_set_post_views($product->get_id());

        $_SESSION['showProduct'] = $product->get_id();


    }

    add_filter('woocommerce_before_single_product', 'insert_view_product', 10, 1);
}


if (!function_exists('wpb_get_post_views')) {
    function wpb_get_post_views($postID)
    {
        $count_key = 'wpb_post_views_count';
        $count = get_post_meta($postID, $count_key, true);
        if ($count == '') {
            delete_post_meta($postID, $count_key);
            add_post_meta($postID, $count_key, '0');
            return "0 visualizações";
        }
        return $count . ' visualizações';
    }
}


if (!function_exists('wpb_set_post_views')) {

    function wpb_set_post_views($postID)
    {
        $count_key = 'wpb_post_views_count';
        $count = get_post_meta($postID, $count_key, true);
        if ($count == '') {
            $count = 0;
            delete_post_meta($postID, $count_key);
            add_post_meta($postID, $count_key, '0');
        } else {
            $count++;
            update_post_meta($postID, $count_key, $count);
        }
    }
}

remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
