<?php

class FiltroShortCode
{


    public function __construct()
    {

        add_shortcode('filtro_de_veiculos_shorcode', array($this, 'filtro_de_veiculos_shorcode'));

    }

    function filtro_de_veiculos_shorcode()
    {
        $versao = 'v1';
        wp_enqueue_style('boostrap-slider-css', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap-slider/10.6.2/css/bootstrap-slider.min.css', array('master-css'), $versao, 'all');
        wp_enqueue_script('bootstrap-slider-js', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap-slider/10.6.2/bootstrap-slider.min.js', array(), $versao, true);
        wp_enqueue_script('angularjs', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.7.8/angular.min.js', 'jquery', $versao, false);
        wp_enqueue_script('altimus', plugins_url('altimus') . '/assets/js/altimus-filtro.js', 'angularjs', $versao, true);


        $arrVeiculos = $this->listarVeiculos();


        $arrFiliais = $this->buscarFiliais($arrVeiculos);
        $arrAnoModelo = $this->buscarAnos($arrVeiculos);
        $arrMarcas = $this->buscarMarcas($arrVeiculos);
        $arrModelos = $this->buscarModelos($arrVeiculos);
        $arrPrecos = $this->buscarPrecoMaximoEMinimo();


        ksort($arrMarcas);
        ksort($arrModelos);
        ksort($arrAnoModelo);


        $field_marca = $_GET['marca'] ?? null;
        $field_modelo = $_GET['modelo'] ?? null;
        $field_ano = $_GET['ano'] ?? null;
        $field_filial = $_GET['filial'] ?? null;
        $field_max_price = $_GET['max_price'] ?? $arrPrecos['maximo'];
        $field_min_price = $_GET['min_price'] ?? $arrPrecos['minimo'];
        include("templates/filtro_de_veiculos_shorcode.php");
    }

    private function listarVeiculos()
    {


        $args = array(
            'post_type' => 'product',
            'posts_per_page' => '-1'
        );
        $the_query = new WP_Query($args);


        while ($the_query->have_posts()) : $the_query->the_post();

            $objMarcas = wp_get_object_terms(get_the_ID(), 'marca');

            foreach ($objMarcas as $objMarca) {
                $marca['id'] = $objMarca->term_id;
                $marca['name'] = $objMarca->name;
                $marca['slug'] = $objMarca->slug;
                $arrReturn['marcas'][] = $marca;
            }


            $objModelos = wp_get_object_terms(get_the_ID(), 'modelo');

            foreach ($objModelos as $objMarca) {
                $marca['id'] = $objMarca->term_id;
                $marca['name'] = $objMarca->name;
                $marca['slug'] = $objMarca->slug;
                $arrReturn['modelos'][] = $marca;
            }


            $local = get_post_meta(get_the_ID(), 'alt_localizacao', true) ?? null;
            $ano = get_post_meta(get_the_ID(), 'alt_ano_mod', true) ?? null;

            $arrReturn['locais'][$local] = $local;
            $arrReturn['ano'][$ano] = $ano;


        endwhile;


        return $arrReturn;
    }

    private function buscarFiliais($arrLocais)
    {
        if (!isset($arrLocais['locais'])) {
            return [];
        }

        return $arrLocais['locais'];
    }

    private function buscarAnos($arrAnos)
    {

        if (!isset($arrAnos['ano'])) {
            return [];
        }


        return $arrAnos['ano'];
    }

    private function buscarMarcas($arrMarcas)
    {

        if (!isset($arrMarcas['marcas'])) {
            return [];
        }

        $arrReturn = [];
        foreach ($arrMarcas['marcas'] as $marca) {

            $slug = $marca['slug'] ?? null;
            $data['id'] = $marca['term_id'] ?? null;
            $data['name'] = $marca['name'] ?? null;
            $data['slug'] = $slug ?? null;
            $arrReturn[$slug] = $data;
        }

        return $arrReturn;
    }

    private function buscarModelos($arrModelos)
    {
        if (!isset($arrModelos['modelos'])) {
            return [];
        }

        $arrReturn = [];
        foreach ($arrModelos['modelos'] as $marca) {

            $slug = $marca['slug'];
            $data['id'] = $marca['term_id'] ?? null;
            $data['name'] = $marca['name'] ?? null;
            $data['slug'] = $slug ?? null;
            $arrReturn[$slug] = $data ?? null;
        }

        return $arrReturn;
    }

    private function buscarPrecoMaximoEMinimo()
    {

        $min_value = wpq_get_min_price();
        $max_value = wpq_get_max_price();

        return ['minimo' => $min_value, 'maximo' => $max_value];
    }
}
