<?php

class FinanciamentoShortcode
{


    public function __construct()
    {

        add_shortcode('alt_financiamento', array($this, 'alt_financiamento'));

    }


    function alt_financiamento($param)
    {
        $valor = $param['valor'] ?? null;
        $versao = 1;
        wp_enqueue_style('financiamentos-css', plugins_url('altimus') . '/assets/css/altimus-financiamento.css', '', $versao, 'all');

        wp_enqueue_script('angularjs', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.7.8/angular.min.js', 'jquery', 1, false);
        wp_enqueue_script('angular-input-pt_BR', 'https://cdnjs.cloudflare.com/ajax/libs/angular.js/1.7.8/i18n/angular-locale_pt-br.js', 'angularjs', $versao, true);
        wp_enqueue_script('angular-input-masks-standalone', 'https://cdnjs.cloudflare.com/ajax/libs/angular-input-masks/4.4.1/angular-input-masks-standalone.min.js', '', $versao, true);


        wp_enqueue_script('financiamentojs', plugins_url('altimus') . '/assets/js/altimus-financiamento.js', 'angularjs', 1, true);


        include("template.php");

    }


}


add_action('wp_ajax_buscar_financiamento', 'buscar_financiamento');
add_action('wp_ajax_nopriv_buscar_financiamento', 'buscar_financiamento');
function buscar_financiamento()
{

    if (isset($_REQUEST)) {

        $entrada = $_GET['entrada'] ?? 0;
        $valor_veiculo = $_GET['valor'] ?? 0;

        $valor_financiamento = $valor_veiculo - $entrada;

        $dados = [];
        $arrPrazos = ['12x', '24x', '48x', '32x', '36x', '72x'];

        $arrBancos['Bradesco'] = ['nome' => 'Bradesco', '12x' => 'R$ 111,00', '24x' => 'R$ 111,00', '32x' => 'R$ 111,00', '48x' => 'R$ 111,00'];
        $arrBancos['Safra'] = ['nome' => 'Safra', '12x' => 'R$ 222,00', '24x' => 'R$ 222,00', '32x' => 'R$ 222,00', '48x' => 'R$ 222,00'];
        $arrBancos['Santander'] = ['nome' => 'Santander', '12x' => 'R$ 333,00', '24x' => 'R$ 333,00', '32x' => 'R$ 333,00', '48x' => 'R$ 333,00', '36x' => 'R$ 333,00'];

        $results['bancos'] = $arrBancos;
        $results['prazos'] = $arrPrazos;
        $results['entrada'] = number_format($entrada, '2', ',', '.');
        $results['valor_financiado'] = number_format($valor_financiamento, '2', ',', '.');


    }

    header('Content-Type: application/json');
    echo json_encode($results);
    die();
}

