var app = angular.module('myApp', []);
app.controller('myCtrl', function ($scope, $http, $window, $parse, $httpParamSerializerJQLike) {


    angular.element("#price_range").slider({});


    $scope.objForm = {
        filial: null,
        modelo: null,
        marca: null,
        ano: null,
        max_price: null,
        min_price: null
    };

    $scope.arrModelos = [];
    $scope.arrFiliais = [];
    $scope.arrModelos = [];
    $scope.arrAnos = [];
    $scope.arrMarcas = [];

    $scope.carregando_modelos = false;
    $scope.carregando_ano_modelo = false;


    $scope.$watch('objForm.marca', function (value) {
        if (value != '') {
            $scope.carregarFiltroModelos();
            $scope.carregarAno();
        }
    });
    $scope.$watch('objForm.modelo', function (value) {
        if (value != '') {
            $scope.carregarAno();
        }
    });

    $scope.setValue = function (campo, value) {

        if (value == null || value == "") {
            return;
        }

        var dados = 'objForm.' + campo;
        var model = $parse(dados);
        model.assign($scope, value);


    };
    $scope.calcularPreco = function () {

        preco = angular.element('#price_range').val();

        if (preco == "") {
            return;
        }

        $scope.objForm.min_price = preco.split(',')[0];
        $scope.objForm.max_price = preco.split(',')[1];


    };


    $scope.carregarFiltroModelos = function () {

        $scope.arrModelos = [];
        $scope.carregando_modelos = true;

        var url_base = '/wp-admin/admin-ajax.php?action=get_taxonomy_product&taxonomy=marca';

        url = url_base.concat('&term=' + $scope.objForm.marca);


        $http.get(url).then(
            function (response) {
                $scope.arrModelos = [];
                angular.forEach(response.data.posts, function (v, k) {

                    $scope.arrModelos.push({'slug': v.slug, 'name': v.name});
                })


            },
            function (error) {

            }
        ).finally(function (response) {
            $scope.carregando_modelos = false;
        });


    };

    $scope.carregarAno = function () {


        var url = '/wp-admin/admin-ajax.php?action=buscar_veiculos&';

        var filter = $scope.serializeObj($scope.objForm);
        var url = url.concat(filter);


        if ($scope.objForm.marca == null || $scope.objForm.marca == '') {
            return;
        }

        $scope.carregando_ano_modelo = true;
        $http.get(url).then(
            function (response) {
                $scope.arrAnos = [];
                angular.forEach(response.data.ano, function (v, k) {

                    $scope.arrAnos.push({'slug': v, 'name': v});
                })

            },
            function (error) {

            }
        ).finally(function (response) {
            $scope.carregando_modelos = false;
            $scope.carregando_ano_modelo = false    ;
        });

    }

    $scope.filtrarVeiculos = function () {


        $scope.calcularPreco();

        var dados = $scope.serializeObj($scope.objForm);
        $window.location.href = '/estoque?' + dados;
        console.log(dados);
    };


    $scope.filtrarVeiculosHome = function () {


        $scope.calcularPreco();


        var dados = $scope.serializeObj($scope.objForm);
        $window.location.href = '/estoque/?' + dados;

    };


    $scope.serializeObj = function (obj) {
        var result = [];
        for (var property in obj)

            if (obj[property] != null) {
                result.push(encodeURIComponent(property) + "=" + encodeURIComponent(obj[property]));
            }
        return result.join("&");
    }


});

app.directive('myEnter', function () {
    return function (scope, element, attrs) {
        element.bind("keydown keypress", function (event) {
            if (event.which === 13) {
                scope.$apply(function () {
                    scope.$eval(attrs.myEnter);
                });

                event.preventDefault();
            }
        });
    };
});

(function ($) {
    'use strict';
    $(function (e) {


        $(function (e) {
            $("#price_range").slider({});
        });

    });


})(jQuery);
