<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class AltFiltroHome
{


    public function __construct()
    {

        add_shortcode('alt_filtro_home', array($this, 'alt_filtro_home'));
        add_action('wp_ajax_nopriv_buscar_veiculos', 'shortcode_buscar_veiculos');
        add_action('wp_ajax_buscar_veiculos', 'shortcode_buscar_veiculos');

    }

    function alt_filtro_home($arrParam = [])
    {


        $versao = 'v1';
        wp_enqueue_style('boostrap-slider-css', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap-slider/10.6.2/css/bootstrap-slider.min.css', array('master-css'), $versao, 'all');
        wp_enqueue_script('bootstrap-slider-js', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap-slider/10.6.2/bootstrap-slider.min.js', array(), $versao, true);
        wp_enqueue_script('angularjs', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.7.8/angular.min.js', 'jquery', $versao, false);
        wp_enqueue_script('altimus', plugin_dir_url(__FILE__) . '/assets/js/altimus-filtro.js', 'angularjs', $versao, true);

        wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', array(), 2, true);


        wp_enqueue_script('swiper-altimus', 'https://cdnjs.cloudflare.com/ajax/libs/Swiper/5.4.5/js/swiper.min.js', 'altimus', $versao, true);
        wp_enqueue_style('swiper-css', 'https://cdnjs.cloudflare.com/ajax/libs/Swiper/5.4.5/css/swiper.min.css', array('boostrap-slider-css'), $versao, 'all');


        $sn_mostrar_textual = get_show_textual_busca_home();


        $arrVeiculos = $this->listarVeiculos();


        $arrFiliais = $this->buscarFiliais($arrVeiculos);
        $arrAnoModelo = $this->buscarAnos($arrVeiculos);
        $arrMarcas = $this->buscarMarcas($arrVeiculos);
        $arrModelos = $this->buscarModelos($arrVeiculos);
        $arrPrecos = $this->buscarPrecoMaximoEMinimo();


        ksort($arrMarcas);
        ksort($arrModelos);
        ksort($arrAnoModelo);


        $field_marca = $_GET['marca'] ?? null;
        $field_modelo = $_GET['modelo'] ?? null;
        $field_ano = $_GET['ano'] ?? null;
        $field_filial = $_GET['filial'] ?? null;
        $field_max_price = $_GET['max_price'] ?? $arrPrecos['maximo'];
        $field_min_price = $_GET['min_price'] ?? $arrPrecos['minimo'];
        include("template.php");
    }

    private function listarVeiculos()
    {


        $args = array(
            'post_type' => 'product',
            'posts_per_page' => '-1',
            'post_status' => 'publish',

        );
        $query_filtro = new WP_Query($args);


        while ($query_filtro->have_posts()) : $query_filtro->the_post();


            $objMarcas = wp_get_object_terms(get_the_ID(), 'marca');

            foreach ($objMarcas as $objMarca) {
                $marca['id'] = $objMarca->term_id;
                $marca['name'] = $objMarca->name;
                $marca['slug'] = $objMarca->slug;
                $arrReturn['marcas'][] = $marca;
            }


            $objModelos = wp_get_object_terms(get_the_ID(), 'modelo');

            foreach ($objModelos as $objMarca) {
                $marca['id'] = $objMarca->term_id;
                $marca['name'] = $objMarca->name;
                $marca['slug'] = $objMarca->slug;
                $arrReturn['modelos'][] = $marca;
            }


            $local = get_post_meta(get_the_ID(), 'alt_localizacao', true) ?? null;
            $ano = get_post_meta(get_the_ID(), 'alt_ano_mod', true) ?? null;

            $arrReturn['locais'][$local] = $local;
            $arrReturn['ano'][$ano] = $ano;


        endwhile;

        wp_reset_postdata();

        return $arrReturn;
    }

    private function buscarFiliais($arrLocais)
    {
        if (!isset($arrLocais['locais'])) {
            return [];
        }

        return $arrLocais['locais'];
    }

    private function buscarAnos($arrAnos)
    {

        if (!isset($arrAnos['ano'])) {
            return [];
        }

        return $arrAnos['ano'];
    }

    private function buscarMarcas($arrMarcas)
    {

        if (!isset($arrMarcas['marcas'])) {
            return [];
        }

        $arrReturn = [];
        foreach ($arrMarcas['marcas'] as $marca) {

            $slug = $marca['slug'] ?? null;
            $data['id'] = $marca['term_id'] ?? null;
            $data['name'] = $marca['name'] ?? null;
            $data['slug'] = $slug ?? null;
            $arrReturn[$slug] = $data;
        }

        return $arrReturn;
    }

    private function buscarModelos($arrModelos)
    {
        if (!isset($arrModelos['modelos'])) {
            return [];
        }

        $arrReturn = [];
        foreach ($arrModelos['modelos'] as $marca) {

            $slug = $marca['slug'];
            $data['id'] = $marca['term_id'] ?? null;
            $data['name'] = $marca['name'] ?? null;
            $data['slug'] = $slug ?? null;
            $arrReturn[$slug] = $data ?? null;
        }

        return $arrReturn;
    }

    private function buscarPrecoMaximoEMinimo()
    {

        $min_value = wpq_get_min_price();
        $max_value = wpq_get_max_price();

        return ['minimo' => $min_value, 'maximo' => $max_value];
    }


}


function shortcode_buscar_veiculos()
{
    $filter = [];

    if (!empty($_GET['marca'])) {
        $filter[] = array(
            'taxonomy' => 'marca',
            'field' => 'slug',
            'terms' => $_GET['marca'],
        );
    }

    if (!empty($_GET['modelo'])) {
        $filter[] = array(
            'taxonomy' => 'modelo',
            'field' => 'slug',
            'terms' => $_GET['modelo'],
        );
    }

    //Busca os dados que queremos
    $args = array(
        'post_type' => 'product',
        'post_status' => 'publish',
        'posts_per_page' => '-1',
        'tax_query' => array($filter),
    );
    $the_query = new WP_Query($args);


    while ($the_query->have_posts()) : $the_query->the_post();

        $ano = get_post_meta(get_the_ID(), 'alt_ano_mod', true) ?? null;
        $arrReturn['ano'][$ano] = $ano;

    endwhile;

    if (empty($arrReturn)) {
        return [];
    }
    header('Content-Type: application/json');
    echo json_encode($arrReturn);
    die;

}