<?php

add_action('cmb2_admin_init', 'setup');


function setup()
{
    $versao = 1;


    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup',
        'title' => 'Configurações do tema Altimus',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_setup', // The option key and admin menu page slug.
        'icon_url' => 'dashicons-palmtree', // Menu icon. Only applicable if 'parent_slug' is left empty.

    ));

    $cmb_options->add_field(array(
        'name' => 'Logo',
        'desc' => 'Faça o upload da imagem ou informe a URL (Tamanho recomendado 153x43)',
        'id' => 'logo',
        'type' => 'file',
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Fazer upload' // Change upload button text. Default: "Add or Upload File"
        ),
        'query_args' => array(
            'type' => array(
                // 	'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),

    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir noticias na home',
        'desc' => '',
        'id' => 'exibir_noticias',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Modelo de cabeçalho',
        'desc' => '',
        'id' => 'modelo_cabecalho',
        'type' => 'select',
        'default' => '0',
        'options' => array(
            '0' => 'Modelo 1 (Padrão)',
            'modelo2' => 'Modelo 2',
            'modelo3' => 'Modelo 3',
        ),
    ));


    $cmb_options->add_field(array(

        'name' => 'Formato de visualização',
        'desc' => '',
        'id' => 'formato_visualizacao',
        'type' => 'select',
        'default' => 'box',
        'options' => array(
            'wide' => 'Wide',
            'box' => 'Box',
        ),
    ));


     $cmb_options->add_field(array(
         'before_row' => '<br/><h2>Sessão - Depoimentos</h2>',
        'name' => 'Exibir depoimentos',
        'desc' => '',
        'id' => 'exibir_depoimentos',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

     $cmb_options->add_field(array(
        'name' => 'Layout da sessão depoimentos',
        'desc' => '',
        'id' => 'layout_depoimentos',
        'type' => 'select',
        'default' => 'modelo-1',
        'options' => array(
            'modelo-1' => 'Modelo 1',
            'modelo-2' => 'Modelo 2',
        ),
    ));



    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Filtro</h2>',
        'name' => 'Exibir filtro na página inicial do site?',
        'desc' => '',
        'id' => 'exibir_filtro_home',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir opção de busca textual?',
        'desc' => '',
        'id' => 'exibir_filtro_busca_textual',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Carroceria</h2>',
        'name' => 'Deseja exibir o filtro por carroceria?',
        'desc' => 'Sedan, Esportivo, Hatch, etc',
        //'attributes' => ['onChange' => 'mostrarMarcas()'],
        'id' => 'filtro_por_carroceria',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Marcas</h2>',
        'name' => 'Mostrar marcas',
        'desc' => '',
        'id' => 'mostrar_marcas',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Deseja exibir somente marcas do estoque?',
        'desc' => '',
        'attributes' => ['onChange' => 'mostrarMarcas()'],
        'id' => 'mostrar_somente_estoque',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $group_field_id = $cmb_options->add_field(array(

        'id' => 'marcas_home',
        'type' => 'group',
        'description' => 'Marcas que serão exibidas na home (Tamanho recomendado 142x75) tamanhos fora dessa proporsão não serão exibidos corretamente.',

        'options' => array(
            'closed' => true,
            'group_title' => '{#}º Registro ', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar',
            'remove_button' => 'Remover',
            'remove_confirm' => 'Tem certeza que deseja remover esse registro?', // Performs confirmation before removing group.

        ),
    ));
    $cmb_options->add_group_field($group_field_id, array(

        'name' => 'Nome',
        'id' => 'nome',
        'description' => 'Esse campo será utilizado no ALT das imagens',
        'type' => 'text',
    ));
    $cmb_options->add_group_field($group_field_id, array(

        'name' => 'URL de destino',
        'id' => 'url_destino',
        'type' => 'text_url',
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Imagem',
        'desc' => 'Faça o upload da imagem',
        'id' => 'imagem',
        'type' => 'file',

    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos em destaque (Home)</h2>',
        'name' => 'Exibir veiculos em destaque',
        'desc' => '',
        'id' => 'exibir_destaques',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Destaques',
        'desc' => 'Total de veículos em destaque na Home',
        'id' => 'total_veiculos_em_destaque',
        'type' => 'text',
        'default' => '6',
    ));

    $cmb_options->add_field(array(
        'name' => 'Tipo de veículo a ser exibido como destaque',
        'desc' => '',
        'id' => 'tipo_veiculo_destaque',
        'type' => 'select',
        'default' => 'todos',
        'options' => listaTipos(),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir repasses em destaque',
        'desc' => '',
        'id' => 'exibir_repasse_destaque',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
     $cmb_options->add_field(array(
        'name' => 'Titulo da página destaques',
        'desc' => 'Titulo da página destaques',
        'default' => '',
        'id' => 'destaques_titulo',
        'type' => 'textarea_small',
    ));



    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos mais recentes (Home)</h2>',
        'name' => 'Exibir veiculos mais recentes',
        'desc' => '',
        'id' => 'exibir_mais_recentes',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Mais recentes',
        'desc' => 'Total de veículos mais recentes na Home',
        'id' => 'total_veiculos_mais_recentes',
        'type' => 'text',
        'default' => '6',
    ));
    $cmb_options->add_field(array(
        'name' => 'Tipo de veículo a ser exibido como mais recentes',
        'desc' => '',
        'id' => 'tipo_veiculo_recentes',
        'type' => 'select',
        'default' => 'todos',
        'options' => listaTipos(),
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir repasses em veículos mais recentes',
        'desc' => '',
        'id' => 'exibir_repasse_mais_recentes',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página mais recentes',
        'desc' => 'Titulo da página mais recentes',
        'default' => '',
        'id' => 'mais_recentes_titulo',
        'type' => 'textarea_small',
    ));




    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos mais procurados (Home)</h2>',
        'name' => 'Exibir veículos mais procurados',
        'desc' => '',
        'id' => 'exibir_mais_procurados',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Total de veículos mais procurados',
        'desc' => '',
        'id' => 'total_veiculos_mais_procurados',
        'type' => 'text',
        'default' => '3',
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página mais procurados',
        'desc' => 'Titulo da página mais procurados',
        'default' => '',
        'id' => 'mais_procurados_titulo',
        'type' => 'textarea_small',
    ));


    $titulo_totalizadores = '<br/><h2>Sessão - Totalizadores (Home)</h2>';
    if (alt_get_theme() == 2) {
        $titulo_totalizadores = '<br/><h2>Sessão - Apresentação (Home)</h2>';
    }



    $cmb_options->add_field(array(
        'before_row' => $titulo_totalizadores,
        'name' => 'Mostrar totalizadores na home',
        'desc' => '',
        'id' => 'mostrar_totalizadores',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Layout totalizadores',
        'desc' => '',
        'id' => 'layout_totalizadores',
        'type' => 'select',
        'default' => 'modelo-1',
        'options' => array(
            'modelo-1' => 'Modelo 1',
            'modelo-2' => 'Modelo 2',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Titulo',
        'desc' => htmlentities('Ex: <h2 class="ui-title-block ui-title-block_mod-a text-center">QUALIDADE E SEGURANÇA</h2>
                        <div class="ui-subtitle-block_mod-a">
                            POIS A SUA ESTRADA É O NOSSO
                            COMPROMISSO!
                        </div>'),
        'default' => '',
        'id' => 'titulo_sessao_totalizadores',
        'type' => 'textarea_small',
    ));

    $cmb_options->add_field(array(
        'name' => 'Layout totalizadores',
        'desc' => 'Selecione o layout de totalizadores',
        'default' => '',
        'id' => 'anos_experiencia',
        'type' => 'textarea_small',
    ));


    if (alt_get_theme() == 1) {
        $titulo = 'Exemplo: ' . htmlentities('<h2><i class="far fa-calendar-alt" aria-hidden="true"></i>99+</h2> <p>LOREN IPSUN</p>');
    } else {
        $titulo = htmlentities('<div class="list-services"><i class="icon icon-car-search-altimus"></i>
                                <div class="decor-1"></div>
                                <div class="list-services__inner">
                                    <h3 class="list-services__title">
                                        Titulo da <br/> Guia
                                    </h3>
                                    <div class="list-services__description">
                                        Loren Ipsun loren ipsun loren ipsun
                                    </div>
                                </div>
                            </div>');
    }

    $cmb_options->add_field(array(
        'name' => 'Item 1',
        'desc' => $titulo,
        'default' => '',
        'id' => 'anos_experiencia',
        'type' => 'textarea_small',
    ));

    $cmb_options->add_field(array(
        'name' => 'Item 2',
        'desc' => $titulo,
        'default' => '',
        'id' => 'total_veiculos',
        'type' => 'textarea_small',
    ));

    $cmb_options->add_field(array(
        'name' => 'Item 3',
        'desc' => $titulo,
        'default' => '',
        'id' => 'total_ofertas',
        'type' => 'textarea_small',
    ));

    $cmb_options->add_field(array(
        'name' => 'Item 4',
        'desc' => $titulo,
        'default' => '',
        'id' => 'total_clientes',
        'type' => 'textarea_small',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - (Welcome)</h2>',
        'name' => 'Exibir página welcome',
        'desc' => '',
        'id' => 'mostrar_welcome',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Selecione o layout',
        'desc' => '',
        'id' => 'sobre_layout',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'default' => 'Não usar layout',
            'modelo1' => 'Modelo 1',
            'modelo2' => 'Modelo 2',
        ),
    ));


    $content_welcome = "<div class=\"section-header text-center\">
<h2>Welcome to CarForYou</h2>
There are many variations of passages of Lorem Ipsum available, but the majority have suffered
alteration in some form, by injected humour, or randomised words which don't look even slightly
believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't
anything embarrassing hidden in the middle of text.

</div>";


    $cmb_options->add_field(array(
        'name' => 'Conteúdo da página',
        'desc' => '',
        'id' => 'content_welcome',
        'type' => 'wysiwyg',
        'default' => $content_welcome,
        'options' => array(),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Sobre (Home)</h2>',
        'name' => 'Exibir página sobre',
        'desc' => '',
        'id' => 'exibir_sobre',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $content_sobre = "<div class=\"section-header text-center\">
<h2>About to Client</h2>
There are many variations of passages of Lorem Ipsum available, but the majority have suffered
alteration in some form, by injected humour, or randomised words which don't look even slightly
believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't
anything embarrassing hidden in the middle of text.

</div>";;


    $cmb_options->add_field(array(
        'name' => 'Conteúdo do setor sobre',
        'desc' => '',
        'id' => 'content_sobre',
        'type' => 'wysiwyg',
        'default' => $content_sobre,
        'options' => array(),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - MAPA (Home)</h2>',
        'name' => 'Exibir mapa (Página inicial)',
        'desc' => '',
        'id' => 'exibir_mapa',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Mapa de localização <br/>(página inicial)',
        'desc' => '',
        'id' => 'content_mapa',
        'type' => 'wysiwyg',
        'default' => '',
        'options' => array(),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Apresentação de titulo dos veículos</h2>',
        'name' => 'Formação do titulo dos veículos',
        'desc' => '',
        'id' => 'titulo',
        'type' => 'multicheck',
        'default' => array('marca', 'modelo', 'modelo_complemento', 'ano_fabricacao'),
        'options' => array(
            'marca' => 'Marca',
            'modelo' => 'Modelo',
            'modelo_complemento' => 'Modelo complemento',
            'ano_fabricacao' => 'Ano fabricação',
            'ano_modelo' => 'Ano modelo',
            'cor' => 'Cor',
            'porta' => 'Porta',
            'cambio' => 'Cambio',
        ),
    ));


    $arrFormularios = buscarFormularios();


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Página de contato</h2>',
        'name' => 'Selecione o <br/>formulário padrão',
        'desc' => '',
        'id' => 'formulario_de_contato',
        'type' => 'select',
        'default' => 'modelo1',
        'options' => $arrFormularios,
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Página de notícias</h2>',
        'name' => 'Importar noticias automaticamente?',
        'id' => 'importar_noticias',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Formatar placa</h2>',
        'name' => 'Formatar placa',
        'desc' => 'Usar * para ocultar caracteres. Ex: A**-***A',
        'id' => 'formatar_placa',
        'type' => 'text',
        'default' => 'A**-***A',
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Barra de rolagem</h2>',
        'after_row'=>'<a href="/wp-admin/admin-ajax.php?action=fotos_nao_usadas">Limpar fotos não usadas</a>',
        'name' => 'Exibir icone top page?',
        'desc' => 'Icone que fica no campo esquerdo responsável por rolar a tela para o topo novamente quando clicado.',
        'id' => 'barra_rolagem',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    //Init plugin


    $values = get_option('alt_group_setup');
    if (count($values['marcas_home']) == 0) {

        if (empty($values['marcas_home'][0]['nome'])) {


            $values['marcas_home'][0]['nome'] = 'Volkswagen';
            $values['marcas_home'][0]['url_destino'] = '/estoque/?marca=volkswagen';
            $values['marcas_home'][0]['imagem'] = 'https://s3-sa-east-1.amazonaws.com/catarina-prd/base/marcas/volkswagem.png';


            $values['marcas_home'][1]['nome'] = 'Chevrolet';
            $values['marcas_home'][1]['url_destino'] = '/estoque/?marca=chevrolet';
            $values['marcas_home'][1]['imagem'] = 'https://s3-sa-east-1.amazonaws.com/catarina-prd/base/marcas/chevrolet.png';

            $values['marcas_home'][2]['nome'] = 'Fiat';
            $values['marcas_home'][2]['url_destino'] = '/estoque/?marca=fiat';
            $values['marcas_home'][2]['imagem'] = 'https://s3-sa-east-1.amazonaws.com/catarina-prd/base/marcas/fiat.png';

            $values['marcas_home'][3]['nome'] = 'Ford';
            $values['marcas_home'][3]['url_destino'] = '/estoque/?marca=ford';
            $values['marcas_home'][3]['imagem'] = 'https://s3-sa-east-1.amazonaws.com/catarina-prd/base/marcas/ford.png';

            $values['marcas_home'][4]['nome'] = 'Renault';
            $values['marcas_home'][4]['url_destino'] = '/estoque/?marca=renault';
            $values['marcas_home'][4]['imagem'] = 'https://s3-sa-east-1.amazonaws.com/catarina-prd/base/marcas/renault.png';

            $values['marcas_home'][5]['nome'] = 'Honda';
            $values['marcas_home'][5]['url_destino'] = '/estoque/?marca=honda';
            $values['marcas_home'][5]['imagem'] = 'https://s3-sa-east-1.amazonaws.com/catarina-prd/base/marcas/honda.png';

            $values['marcas_home'][6]['nome'] = 'Hyundai';
            $values['marcas_home'][6]['url_destino'] = '/estoque/?marca=hyundai';
            $values['marcas_home'][6]['imagem'] = 'https://s3-sa-east-1.amazonaws.com/catarina-prd/base/marcas/hyundai.png';
            update_option('alt_group_setup', $values);
        }
    };
}

function get_layout_totalizadores(){
    $dados = get_option('alt_group_setup');
    if (!empty($dados['layout_totalizadores'])) {
        return $dados['layout_totalizadores'];
    }
    return 'default';
}

function get_titulo_destaques()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['destaques_titulo'])) {
        return $dados['destaques_titulo'];
    }
    return null;
}
function get_titulo_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['mais_recentes_titulo'])) {
        return $dados['mais_recentes_titulo'];
    }
    return null;
}
function get_titulo_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['mais_procurados_titulo'])) {
        return $dados['mais_procurados_titulo'];
    }
    return null;
}

function get_layout_sobre()
{
    $dados = get_option('alt_group_setup');


    if (!empty($dados['sobre_layout'])) {
        return $dados['sobre_layout'];
    }

    return 'default';
}


function formato_visualizacao()
{
    $dados = get_option('alt_group_setup');


    if ($dados['formato_visualizacao'] == 'wide') {
        return 'container-fluid';
    }

    return 'container';
}

function get_todas_marcas()
{


    $dados = get_option('alt_group_setup');


    if ($dados['mostrar_somente_estoque'] == 'sim') {
        return get_marcas_do_estoque_com_veiculo();
    }

    return $dados['marcas_home'];
}

function get_marcas_do_estoque_com_veiculo()
{

    $categories = get_terms(['taxonomy' => 'marca', 'hide_empty' => true, 'orderby' => 'count', 'order' => 'DESC']);
    $arrRetorno = [];
    foreach ($categories as $key => $categoria) {


        $info['url_destino'] = get_term_link($categoria->term_id, 'marca');
        $info['imagem'] = get_term_meta($categoria->term_id, 'marca_img', true);
        $info['nome'] = $categoria->name;
        $info['total'] = $categoria->count;
        $info['slug'] = $categoria->slug;


        $arrRetorno[$key] = $info;
    }


    return $arrRetorno;


}


function get_show_barra_rolagem()
{
    $dados = get_option('alt_group_setup');
    return $dados['barra_rolagem'] == 'sim' ? true : false;
}

function get_importar_noticias()
{
    $dados = get_option('alt_group_setup');
    return $dados['importar_noticias'] == 'sim' ? true : false;
}


function get_exibir_mapa()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_mapa'] == 'sim' ? true : false;
}

function get_modelo_cabecalho()
{
    $dados = get_option('alt_group_setup');
    return $dados['modelo_cabecalho'];
}

function get_carregar_mapa()
{
    $dados = get_option('alt_group_setup');
    return $dados['content_mapa'];
}


function get_formatar_placa()
{
    $dados = get_option('alt_group_setup');
    return $dados['formatar_placa'];
}


function get_formacao_titulo()
{
    $dados = get_option('alt_group_setup');
    return $dados['titulo'];
}

function buscarFormularios($form_id = null)
{

    $args = array('post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1);
    $cf7Forms = get_posts($args);
    $arrIds = wp_list_pluck($cf7Forms, 'ID');
    $arrTitulos = wp_list_pluck($cf7Forms, 'post_title');
    $arrDados[0] = 'Inativo';

    foreach ($arrIds as $index => $ids) {
        $arrDados[$ids] = $arrTitulos[$index];
    }

    return $arrDados;
}

function listaTipos()
{


    $arrTermos = get_terms('tipo');

    $arrRet = [];

    $arrRet['todos'] = 'Todos';
    foreach ($arrTermos as $termos) {
        $arrRet[$termos->slug] = $termos->name;
    }
    return $arrRet;
}

function get_mostrar_ultimas_noticias()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_noticias'] == 'sim' ? true : false;
}
function get_layout_depoimentos(){

    $dados = get_option('alt_group_setup');
    $modelo = $dados['layout_depoimentos'];
    if(empty($modelo)){
        return 'modelo-1';
    }
    return $modelo;
}
function get_mostrar_depoimentos()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_depoimentos'] == 'sim' ? true : false;
}

function get_mostrar_veiculos_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_mais_procurados'] == 'sim' ? true : false;
}

function get_mostrar_total_veiculos_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    return $dados['total_veiculos_mais_procurados'];
}


function get_mostrar_veiculos_destaque()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_destaques'] == 'sim' ? true : false;
}

function get_total_veiculos_destaque()
{
    $dados = get_option('alt_group_setup');
    return $dados['total_veiculos_em_destaque'];
}

function get_exibir_repasse_destaques()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_repasse_destaque'];
}

function get_exibir_repasse_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_repasse_mais_recentes'];
}

function get_tipo_veiculo_destaques()
{
    $dados = get_option('alt_group_setup');
    return $dados['tipo_veiculo_destaque'];
}

function get_tipo_veiculo_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['tipo_veiculo_recentes'];
}

function get_mostrar_veiculos_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_mais_recentes'] == 'sim' ? true : false;
}

function get_mostrar_sobre()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_sobre'] == 'sim' ? true : false;
}

function mostrar_icones_sociais_header()
{
    $dados = get_option('alt_group_midias_sociais');
    return $dados['exibir_social_cabecalho'] == 'sim' ? true : false;
}

function mostrar_icones_sociais_footer()
{
    $dados = get_option('alt_group_midias_sociais');
    return $dados['exibir_social_rodape'] == 'sim' ? true : false;
}

function get_total_veiculos_mais_recentes()
{
    $dados = get_option('alt_group_setup');

    return $dados['total_veiculos_mais_recentes'];
}

add_shortcode('alt_short_code_logo', 'alt_short_code_logo');

function alt_get_url_logo()
{
    $arrOptions = get_option('alt_group_setup');
    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
    } else {
        $url = $arrOptions['logo'];
    }

    return $url;
}

function alt_short_code_logo($size = null)
{

    $arrOptions = get_option('alt_group_setup');

    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
        echo '<img alt="logo da empresa" src="' . $url . '" class="logo-header img-responsive" alt="Logo da loja" ' . $size . '/>';
    } else {
        echo '<img alt="logo da empresa"  src="' . $arrOptions['logo'] . '" class="logo-header img-responsive" alt="Logo da loja" ' . $size . '/>';
    }
}

function alt_url_logo()
{
    $arrOptions = get_option('alt_group_setup');

    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
        return $url;
    }

    return $arrOptions['logo'];
}

function get_mostrar_totalizadores()
{
    $dados = get_option('alt_group_setup');
    return $dados['mostrar_totalizadores'] == 'sim' ? true : false;
}

function get_totalizadores()
{
    $dados = get_option('alt_group_setup');


    $arr['titulo_sessao_totalizadores'] = $dados['titulo_sessao_totalizadores'] ?? null;
    $arr['experiencia'] = $dados['anos_experiencia'] ?? null;
    $arr['total_veiculos'] = $dados['total_veiculos'] ?? null;
    $arr['total_ofertas'] = $dados['total_ofertas'] ?? null;
    $arr['total_clientes'] = $dados['total_clientes'] ?? null;

    return $arr;
}

function get_mostrar_carroceria()
{
    $dados = get_option('alt_group_setup');
    return $dados['filtro_por_carroceria'] == 'sim' ? true : false;
}

function get_listar_carrocerias()
{
    $categories = get_terms(['taxonomy' => 'carroceria', 'hide_empty' => true, 'orderby' => 'count', 'order' => 'DESC']);
    $arrRetorno = [];

    $total = 0;
    foreach ($categories as $key => $categoria) {

        $total++;
        if ($total > 6) {
            continue;
        }
        $img = get_term_meta($categoria->term_id, 'carroceria_img', true);


        $info['slug'] = $categoria->slug;
        $info['imagem'] = $img;
        $info['nome'] = $categoria->name;
        $info['total'] = $categoria->count;
        $info['slug'] = $categoria->slug;


        $arrRetorno[$key] = $info;
    }


    return $arrRetorno;
}


function get_mostrar_marcas()
{
    $dados = get_option('alt_group_setup');
    return $dados['mostrar_marcas'] == 'sim' ? true : false;
}


function get_mostrar_welcome()
{
    $dados = get_option('alt_group_setup');
    return $dados['mostrar_welcome'] == 'sim' ? true : false;
}

function get_content_welcome()
{
    $dados = get_option('alt_group_setup');
    return $dados['content_welcome'];
}

function get_content_sobre()
{
    $dados = get_option('alt_group_setup');
    return html_entity_decode($dados['content_sobre']);
}

function get_formulario_contato()
{
    $dados = get_option('alt_group_setup');
    $formulario_id = $dados['formulario_de_contato'];

    if (empty($formulario_id)) {
        return false;
    }
    return do_shortcode('[contact-form-7 id="' . $formulario_id . '"]');
}

function get_show_filtro_home()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['exibir_filtro_home'])) {
        return true;
    }
    return $dados['exibir_filtro_home'] == 'sim' ? true : false;
}

function get_show_textual_busca_home()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['exibir_filtro_busca_textual'])) {
        return true;
    }
    return $dados['exibir_filtro_busca_textual'] == 'sim' ? true : false;
}




