<?php

add_action('cmb2_admin_init', 'setup_detalhes');

function setup_detalhes()
{


    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup_detalhes',
        'title' => 'Configurações Detalhes do veículo',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_setup_detalhes', // The option key and admin menu page slug.
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
    ));


    $cmb_options->add_field(array(
        'name' => 'Habilitar financiamentos',
        'desc' => '',
        'id' => 'habilita_financiamentos',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(

        'name' => 'Modelo da tela de <br/>Detalhes do produto',
        'desc' => '',
        'id' => 'layout_produto',
        'type' => 'select',
        'default' => 'modelo1',
        'options' => array(
            'modelo1' => 'Modelo I',
            'modelo2' => 'Modelo II',
            'modelo3' => 'Modelo III',
        ),
    ));


    $arrFormularios = buscarFormulariosModals();

    /*
    $cmb_options->add_field(array(
        'name' => 'Modal <br/>(Agende um teste drive)',
        'desc' => 'Selecione um formulário (Somente modelo II)',
        'id' => 'modal_teste_drive',
        'type' => 'select',
        'default' => 'modelo1',
        'options' => array('0' => 'Inativo'),
    ));
    $cmb_options->add_field(array(
            'name' => 'Modal <br/>(Faça uma oferta)',
            'desc' => 'Selecione um formulário (Somente modelo II)',
            'id' => 'modal_oferta',
            'type' => 'select',
            'default' => 'modelo1',
            'options' => array('0' => 'Inativo')
        )
    );
    $cmb_options->add_field(array(
        'name' => 'Modal <br/>(Encaminhe para um amigo)',
        'desc' => 'Selecione um formulário (Somente modelo II)',
        'id' => 'modal_encaminhe',
        'type' => 'select',
        'default' => 'modelo1',
        'options' => array('0' => 'Inativo'),
    ));
    $cmb_options->add_field(array(
        'name' => 'Modal <br/>(Solicitar mais informações)',
        'desc' => 'Selecione um formulário (Somente modelo II)',
        'id' => 'modal_mais_informacoes',
        'type' => 'select',
        'default' => 'modelo1',
        'options' => array('0' => 'Inativo'),
    ));
    */

    $group_field_id = $cmb_options->add_field(array(
        'before_group' => '<br/><h2>Formulários dinâmicos <strong>(Modelo III)</strong></h2>',
        'id' => 'formulario_contato_modal',
        'type' => 'group',
        'description' => 'Formulários de contato',

        'options' => array(
            'group_title' => '{#}º Formulário ', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar',
            'remove_button' => 'Remover',
            'remove_confirm' => 'Tem certeza que deseja remover esse formulário?', // Performs confirmation before removing group.

        ),
    ));


    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Descrição',
        'id' => 'titulo',
        'type' => 'text',
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Formulário',
        'id' => 'tipo',
        'type' => 'select',
        'options' => $arrFormularios,
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Icone',
        'id' => 'icone_modal',
        'type' => 'text',
        'default' => 'fa fa-car',
        'desc' => 'Selecione da lista <a href="https://fontawesome.com/icons" target="_blank">https://fontawesome.com/</a>'
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Exibição de ano/veículo</h2>',
        'name' => 'Como deseja exibir a informação de ano do veículo?',
        'desc' => '',
        'id' => 'formatar_ano',
        'type' => 'select',
        'default' => 'ano_modelo',
        'options' => [
            'ano_fabricacao' => 'Ano fabricação',
            'ano_modelo' => 'Ano modelo',
            'ano_modelo_fabricacao' => 'Ano fabricação e modelo',
        ],
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão de Características do veículo</h2>',
        'name' => 'Características dos veículos',
        'desc' => 'Recomendado ativar apenas 6 / Se nenhum item for selecionado então os 6 icons padrão serão ativados.',
        'id' => 'caracteristicas',
        'type' => 'multicheck',
        'default' => array('alt_kilometragem', 'alt_combustivel', 'alt_cambio', 'alt_ano_mod', 'alt_cor', 'alt_placa'),
        'options' => array(
            'alt_kilometragem' => 'Quilometragem',
            'alt_cambio' => 'Cambio',
            'alt_ano_mod' => 'Ano',
            'alt_combustivel' => 'Combustível',
            'alt_cor' => 'Cor',
            'alt_placa' => 'Placa',
            'alt_marca' => 'Marca',
            'alt_modelo' => 'Modelo',
            'alt_portas' => 'Porta',
        ),
    ));


}

function getCaracteristasSessionDetalhes()
{
    $dados = get_option('alt_group_setup_detalhes');
    if (!isset($dados['caracteristicas'])) {
        return false;
    }
    return $dados['caracteristicas'] ?? false;
}


function get_ano_veiculo()
{
    $dados = get_option('alt_group_setup_detalhes');
    return $dados['formatar_ano'];
}

function get_formulario_dinamicos()
{

    $dados = get_option('alt_group_setup_detalhes');


    if (empty($dados['formulario_contato_modal'])) {
        return [];
    }


    return $dados['formulario_contato_modal'];

}

function get_habilita_financiamentos()
{
    $dados = get_option('alt_group_setup_detalhes');
    return $dados['habilita_financiamentos'] == 'sim' ? true : false;
}


function buscarFormulariosModals($form_id = null)
{

    $args = array('post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1);
    $cf7Forms = get_posts($args);
    $arrIds = wp_list_pluck($cf7Forms, 'ID');
    $arrTitulos = wp_list_pluck($cf7Forms, 'post_title');
    $arrDados[0] = 'Inativo';

    foreach ($arrIds as $index => $ids) {
        $arrDados[$ids] = $arrTitulos[$index];
    }

    return $arrDados;
}


function get_layout_produto()
{
    $dados = get_option('alt_group_setup_detalhes');
    return $dados['layout_produto'];
}

function get_formulario_modal($tipo_do_formulario)
{

    $dados = get_option('alt_group_setup_detalhes');
    $formulario_id = $dados[$tipo_do_formulario];

    if (empty($formulario_id)) {
        return false;
    }
    return do_shortcode('[contact-form-7 id="' . $formulario_id . '"]');

}
