<?php

add_action('cmb2_admin_init', 'contato_header');

function contato_header()
{
    //GERENCIAR CORES

    $estados = array(
        'AC' => 'Acre',
        'AL' => 'Alagoas',
        'AP' => 'Amapá',
        'AM' => 'Amazonas',
        'BA' => 'Bahia',
        'CE' => 'Ceará',
        'DF' => 'Distrito Federal',
        'ES' => 'Espirito Santo',
        'GO' => 'Goiás',
        'MA' => 'Maranhão',
        'MS' => 'Mato Grosso do Sul',
        'MT' => 'Mato Grosso',
        'MG' => 'Minas Gerais',
        'PA' => 'Pará',
        'PB' => 'Paraíba',
        'PR' => 'Paraná',
        'PE' => 'Pernambuco',
        'PI' => 'Piauí',
        'RJ' => 'Rio de Janeiro',
        'RN' => 'Rio Grande do Norte',
        'RS' => 'Rio Grande do Sul',
        'RO' => 'Rondônia',
        'RR' => 'Roraima',
        'SC' => 'Santa Catarina',
        'SP' => 'São Paulo',
        'SE' => 'Sergipe',
        'TO' => 'Tocantins',
    );


    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup_contatos',
        'title' => 'Configurações de contato',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_contato_header', // The option key and admin menu page slug.
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Dados da empresa</h2>',
        'name' => 'Nome Fantasia',
        'desc' => 'Ex: Loja Maravilha Veículos',
        'id' => 'nome_principal',
        'default' => '',
        'type' => 'text',
    ));
    $cmb_options->add_field(array(
        'name' => 'CNPJ',
        'desc' => 'Ex: XX.XXX.XXX/XXXX-XX',
        'id' => 'cnpj_principal',
        'default' => '',
        'type' => 'text',
    ));
    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Endereço principal </h2>',
        'name' => 'Endereço',
        'desc' => 'Ex: R.João Pessoa 2008 - Sala 01',
        'default' => '',
        'id' => 'endereco_principal',
        'type' => 'text',
    ));
    $cmb_options->add_field(array(
        'name' => 'Cidade',
        'desc' => 'Ex: Blumenau',
        'default' => '',
        'id' => 'cidade_principal',
        'type' => 'text',
    ));
    $cmb_options->add_field(array(
        'name' => 'Estado',
        'desc' => '',
        'default' => '',
        'id' => 'estado_principal',
        'type' => 'select',
        'default' => 'SC',
        'options' => $estados,
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Telefone fixo principal</h2>',
        'name' => 'Telefone fixo',
        'desc' => '',
        'id' => 'telefone_principal',
        'default' => '',
        'type' => 'text',
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>E-mail principal</h2>',
        'name' => 'E-mail principal',
        'desc' => '',
        'id' => 'email_principal',
        'default' => '',
        'type' => 'text',
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Whatsapp principal</h2>',
        'name' => 'Mostrar Whatsapp abaixo do titulo do veículo na listagem de estoque',
        'desc' => '',
        'id' => 'mostrar_whatsapp',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Mostrar Whatsapp da tela de detalhes do veículo <strong>(Mobile - Modelo III)</strong>',
        'desc' => '',
        'id' => 'mostrar_whatsapp_detalhe_veiculo',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(

        'name' => 'Texto do botão',
        'desc' => 'Utilizar no máximo de 10 caracteres',
        'default' => '',
        'id' => 'texto_do_botao',
        'type' => 'text',
        'attributes' => array(
            'maxlength' => '10',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Número do whatsapp',
        'desc' => 'Número do whatsapp padrão <strong>(Utilizar apenas números)</strong> exemplo 554788888888',
        'default' => '',
        'id' => 'numero_whatsapp',
        'type' => 'text',
    ));
    $cmb_options->add_field(array(
        'name' => 'Mensagem padrão do whatsapp',
        'desc' => '',
        'default' => '',
        'id' => 'mensagem_whatsapp',
        'type' => 'text'
    ));


    $group_field_id = $cmb_options->add_field(array(
        'id' => 'contatos_header',
        'type' => 'group',
        'before_group' => '<br/><h2>Contatos</h2>',
        'description' => 'Contatos que serão exibidos no cabeçalho e rodape do site',
        'options' => array(
            'closed' => true,
            'group_title' => '{#}º Registro ', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar',
            'remove_button' => 'Remover',
            'remove_confirm' => 'Tem certeza que deseja remover esse registro?', // Performs confirmation before removing group.

        ),
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Tipo de contato',
        'id' => 'tipo',
        'type' => 'select',
        'options' => array(
            'email' => 'E-mail',
            'whatsapp' => 'Whatsapp',
            'texto' => 'texto',
            'telefone' => 'Telefone',
            'endereco' => 'Endereço',
        ),
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Titulo/Nome',
        'id' => 'titulo',
        'type' => 'text',
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Valor',
        'id' => 'valor',
        'type' => 'text',
        'desc' => 'Caso seja telefone usar o padrão DDD+NUMERO (Ex: 4788883333)'
        //'sanitization_cb' => 'validarDados',

    ));

}

function get_info_principal()
{
    $dados = get_option('alt_group_contato_header');

    $retorno['nome_fantasia'] = $dados['nome_principal'] ?? null;
    $retorno['cnpj'] = $dados['cnpj_principal'] ?? null;

    $retorno['telefone'] = $dados['telefone_principal'] ?? null;
    $retorno['email'] = $dados['email_principal'] ?? null;

    $numero_whatsapp = $dados['numero_whatsapp'] ?? null;


    $retorno['whatsapp'] = alt_mascara('(##)####-#####', substr($numero_whatsapp, 2, -1));
    $url = 'https://api.whatsapp.com/send?phone=' . $numero_whatsapp;
    $retorno['url_whatsapp'] = $url;

    $retorno['endereco'] = $dados['endereco_principal'] ?? null;
    $retorno['cidade'] = $dados['cidade_principal'] ?? null;
    $retorno['estado'] = $dados['estado_principal'] ?? null;


    $retorno['endereco_completo'] = $retorno['endereco'] . ' ' . $retorno['cidade'] . ' ' . $retorno['estado'];

    return $retorno;

}


function get_show_button_whatsapp_listagem()
{

    $dados = get_option('alt_group_contato_header');
    if (isset($dados['mostrar_whatsapp'])) {
        return $dados['mostrar_whatsapp'] == 'sim' ? true : false;
    }

    $dados = get_option('alt_group_listagem');
    return $dados['mostrar_whatsapp'] == 'sim' ? true : false;

    /*$dados = get_option('alt_group_contato_header');
    return $dados['mostrar_whatsapp'] == 'sim' ? true : false;*/
}

function get_show_button_whatsapp()
{

    $dados = get_option('alt_group_contato_header');
    if (isset($dados['mostrar_whatsapp'])) {
        return $dados['mostrar_whatsapp'] == 'sim' ? true : false;
    }

    $dados = get_option('alt_group_setup_detalhes');
    return $dados['mostrar_whatsapp'] == 'sim' ? true : false;

    /*$dados = get_option('alt_group_contato_header');
    return $dados['mostrar_whatsapp'] == 'sim' ? true : false;*/
}

function get_button_whatsapp_detalhes()
{

    $dados = get_option('alt_group_contato_header');

    if (isset($dados['numero_whatsapp'])) {
        $retorno['telefone'] = $dados['numero_whatsapp'];
        $retorno['texto_botao'] = $dados['texto_do_botao'];
        $retorno['mensagem'] = $dados['mensagem_whatsapp'];
        return $retorno;
    }


    $dados = get_option('alt_group_setup_detalhes');
    $retorno['telefone'] = $dados['numero_whatsapp'] ?? null;
    $retorno['texto_botao'] = $dados['texto_do_botao'] ?? null;
    $retorno['mensagem'] = $dados['mensagem_whatsapp'] ?? null;
    return $retorno;

}


function validarDados($value, $field_args, $field)
{

    if (filter_var($value, FILTER_VALIDATE_EMAIL)) {
        $sanitized_value = $value;
    } else {
        $sanitized_value = preg_replace("/[^0-9]/", "", $value);

    }

    return $sanitized_value;
}

function alt_check_exist_contatos_header()
{
    $dados = get_option('alt_group_contato_header');


    if (!isset($dados['contatos_header']['0']['valor'])) {
        return false;
    }

    return true;
}

function get_contatos_header()
{
    $dados = get_option('alt_group_contato_header');


    if (!isset($dados['contatos_header']['0']['valor'])) {
        return [];
    }

    foreach ($dados['contatos_header'] as $data) {


        $d['titulo'] = $data['titulo'];
        $d['valor'] = $data['valor'];

        if ($data['tipo'] == 'email') {
            $d['tipo'] = "E-mail";
            $d['icon'] = "far fa-envelope";
            $d['url'] = "mailto:" . $data['valor'];
        }

        if ($data['tipo'] == 'texto') {
            $d['tipo'] = "";
            $d['icon'] = "fas fa-info";
            $d['url'] = "";
        }

        if ($data['tipo'] == 'telefone') {

            $numero = preg_replace('/[^\d\*]/', '', $data['valor']);

            $d['tipo'] = "Telefone";
            $d['icon'] = "fas fa-phone";
            $d['url'] = "tel:" . $numero;
            $d['valor'] = formataTelefone($numero);
        }


        if ($data['tipo'] == 'whatsapp') {
            $d['tipo'] = "WhatsApp";
            $d['icon'] = "fab fa-whatsapp";


            $numero = preg_replace('/[^\d\*]/', '', $data['valor']);

            $url = 'https://api.whatsapp.com/send?phone=55' . $numero;

            $d['url'] = $url;

            $d['valor'] = formataTelefone($numero);
        }

        if ($data['tipo'] == 'endereco') {
            $d['icon'] = "fas fa-warehouse";
            $d['url'] = "#";
        }


        $arrReturn[] = $d;

    }

    return $arrReturn;


}

function formataTelefone($phone)
{
    $formatedPhone = preg_replace('/[^0-9]/', '', $phone);
    $matches = [];
    preg_match('/^([0-9]{2})([0-9]{4,5})([0-9]{4})$/', $formatedPhone, $matches);
    if ($matches) {
        return '(' . $matches[1] . ') ' . $matches[2] . '-' . $matches[3];
    }

    return $phone; // return number without format
}
